/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common.inliner;

import ai.timefold.solver.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import ai.timefold.solver.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.HardSoftLongScoreContext;
import ai.timefold.solver.core.impl.score.stream.common.inliner.WeightedScoreImpacter;
import java.util.Map;

final class HardSoftLongScoreInliner
extends AbstractScoreInliner<HardSoftLongScore> {
    long hardScore;
    long softScore;

    HardSoftLongScoreInliner(Map<Constraint, HardSoftLongScore> constraintWeightMap, boolean constraintMatchEnabled) {
        super(constraintWeightMap, constraintMatchEnabled);
    }

    @Override
    public WeightedScoreImpacter<HardSoftLongScore, ?> buildWeightedScoreImpacter(AbstractConstraint<?, ?, ?> constraint) {
        HardSoftLongScore constraintWeight = (HardSoftLongScore)this.constraintWeightMap.get(constraint);
        HardSoftLongScoreContext context = new HardSoftLongScoreContext(this, constraint, constraintWeight);
        if (constraintWeight.softScore() == 0L) {
            return WeightedScoreImpacter.of(context, (ctx, matchWeight, constraintMatchSupplier) -> ctx.changeHardScoreBy(matchWeight, constraintMatchSupplier));
        }
        if (constraintWeight.hardScore() == 0L) {
            return WeightedScoreImpacter.of(context, (ctx, matchWeight, constraintMatchSupplier) -> ctx.changeSoftScoreBy(matchWeight, constraintMatchSupplier));
        }
        return WeightedScoreImpacter.of(context, (ctx, matchWeight, constraintMatchSupplier) -> ctx.changeScoreBy(matchWeight, constraintMatchSupplier));
    }

    @Override
    public HardSoftLongScore extractScore(int initScore) {
        return HardSoftLongScore.ofUninitialized(initScore, this.hardScore, this.softScore);
    }

    public String toString() {
        return HardSoftLongScore.class.getSimpleName() + " inliner";
    }
}

