/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common.tri;

import ai.timefold.solver.core.api.function.QuadFunction;
import ai.timefold.solver.core.api.function.ToIntTriFunction;
import ai.timefold.solver.core.api.function.ToLongTriFunction;
import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.DefaultConstraintJustification;
import ai.timefold.solver.core.api.score.stream.quad.QuadConstraintStream;
import ai.timefold.solver.core.api.score.stream.quad.QuadJoiner;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintBuilder;
import ai.timefold.solver.core.api.score.stream.tri.TriConstraintStream;
import ai.timefold.solver.core.impl.score.stream.common.RetrievalSemantics;
import ai.timefold.solver.core.impl.score.stream.common.ScoreImpactType;
import ai.timefold.solver.core.impl.util.ConstantLambdaUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;

public interface InnerTriConstraintStream<A, B, C>
extends TriConstraintStream<A, B, C> {
    public static <A, B, C> QuadFunction<A, B, C, Score<?>, DefaultConstraintJustification> createDefaultJustificationMapping() {
        return (a, b, c, score) -> DefaultConstraintJustification.of(score, a, b, c);
    }

    public static <A, B, C> TriFunction<A, B, C, Collection<?>> createDefaultIndictedObjectsMapping() {
        return (xva$0, xva$1, xva$2) -> Arrays.asList(xva$0, xva$1, xva$2);
    }

    public RetrievalSemantics getRetrievalSemantics();

    public boolean guaranteesDistinct();

    @Override
    default public <D> QuadConstraintStream<A, B, C, D> join(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.join(this.getConstraintFactory().forEach(otherClass), joiners);
        }
        return this.join(this.getConstraintFactory().from(otherClass), joiners);
    }

    @Override
    default public <D> TriConstraintStream<A, B, C> ifExists(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.ifExists(this.getConstraintFactory().forEach(otherClass), joiners);
        }
        return this.ifExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
    }

    @Override
    default public <D> TriConstraintStream<A, B, C> ifExistsIncludingUnassigned(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.ifExists(this.getConstraintFactory().forEachIncludingUnassigned(otherClass), joiners);
        }
        return this.ifExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
    }

    @Override
    default public <D> TriConstraintStream<A, B, C> ifNotExists(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.ifNotExists(this.getConstraintFactory().forEach(otherClass), joiners);
        }
        return this.ifNotExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
    }

    @Override
    default public <D> TriConstraintStream<A, B, C> ifNotExistsIncludingUnassigned(Class<D> otherClass, QuadJoiner<A, B, C, D> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.ifNotExists(this.getConstraintFactory().forEachIncludingUnassigned(otherClass), joiners);
        }
        return this.ifNotExists(this.getConstraintFactory().fromUnfiltered(otherClass), joiners);
    }

    @Override
    default public TriConstraintStream<A, B, C> distinct() {
        if (this.guaranteesDistinct()) {
            return this;
        }
        return this.groupBy(ConstantLambdaUtils.triPickFirst(), ConstantLambdaUtils.triPickSecond(), ConstantLambdaUtils.triPickThird());
    }

    @Override
    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> penalize(Score_ constraintWeight, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> penalizeLong(Score_ constraintWeight, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> penalizeBigDecimal(Score_ constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> penalizeConfigurable(ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> penalizeConfigurableLong(ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> penalizeConfigurableBigDecimal(TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.PENALTY);
    }

    @Override
    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> reward(Score_ constraintWeight, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> rewardLong(Score_ constraintWeight, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> rewardBigDecimal(Score_ constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> rewardConfigurable(ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> rewardConfigurableLong(ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> rewardConfigurableBigDecimal(TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.REWARD);
    }

    @Override
    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> impact(Score_ constraintWeight, ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> impactLong(Score_ constraintWeight, ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> impactBigDecimal(Score_ constraintWeight, TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(constraintWeight, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> impactConfigurable(ToIntTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> impactConfigurableLong(ToLongTriFunction<A, B, C> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    @Override
    default public TriConstraintBuilder<A, B, C, ?> impactConfigurableBigDecimal(TriFunction<A, B, C, BigDecimal> matchWeigher) {
        return this.innerImpact(null, matchWeigher, ScoreImpactType.MIXED);
    }

    public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> innerImpact(Score_ var1, ToIntTriFunction<A, B, C> var2, ScoreImpactType var3);

    public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> innerImpact(Score_ var1, ToLongTriFunction<A, B, C> var2, ScoreImpactType var3);

    public <Score_ extends Score<Score_>> TriConstraintBuilder<A, B, C, Score_> innerImpact(Score_ var1, TriFunction<A, B, C, BigDecimal> var2, ScoreImpactType var3);

    @Override
    default public Constraint penalize(String constraintName, Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintName);
    }

    @Override
    default public Constraint penalize(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.penalize(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public Constraint penalizeConfigurable(String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintName);
    }

    @Override
    default public Constraint penalizeConfigurable(String constraintPackage, String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public Constraint reward(String constraintName, Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintName);
    }

    @Override
    default public Constraint reward(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.reward(constraintWeight).asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public Constraint rewardConfigurable(String constraintName) {
        return this.rewardConfigurable().asConstraint(constraintName);
    }

    @Override
    default public Constraint rewardConfigurable(String constraintPackage, String constraintName) {
        return this.penalizeConfigurable().asConstraint(constraintPackage, constraintName);
    }

    @Override
    default public Constraint impact(String constraintName, Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintName);
    }

    @Override
    default public Constraint impact(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        return this.impact(constraintWeight).asConstraint(constraintPackage, constraintName);
    }
}

