/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.impl.solver.BestSolutionContainingProblemChanges;
import ai.timefold.solver.core.impl.solver.BestSolutionHolder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

final class ConsumerSupport<Solution_, ProblemId_>
implements AutoCloseable {
    private final ProblemId_ problemId;
    private final Consumer<? super Solution_> bestSolutionConsumer;
    private final Consumer<? super Solution_> finalBestSolutionConsumer;
    private final Consumer<? super Solution_> firstInitializedSolutionConsumer;
    private final BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler;
    private final Semaphore activeConsumption = new Semaphore(1);
    private final Semaphore firstSolutionConsumption = new Semaphore(1);
    private final BestSolutionHolder<Solution_> bestSolutionHolder;
    private final ExecutorService consumerExecutor = Executors.newSingleThreadExecutor();
    private Solution_ firstInitializedSolution;

    public ConsumerSupport(ProblemId_ problemId, Consumer<? super Solution_> bestSolutionConsumer, Consumer<? super Solution_> finalBestSolutionConsumer, Consumer<? super Solution_> firstInitializedSolutionConsumer, BiConsumer<? super ProblemId_, ? super Throwable> exceptionHandler, BestSolutionHolder<Solution_> bestSolutionHolder) {
        this.problemId = problemId;
        this.bestSolutionConsumer = bestSolutionConsumer;
        this.finalBestSolutionConsumer = finalBestSolutionConsumer == null ? finalBestSolution -> {} : finalBestSolutionConsumer;
        this.firstInitializedSolutionConsumer = firstInitializedSolutionConsumer;
        this.exceptionHandler = exceptionHandler;
        this.bestSolutionHolder = bestSolutionHolder;
        this.firstInitializedSolution = null;
    }

    void consumeIntermediateBestSolution(Solution_ bestSolution, BooleanSupplier isEveryProblemChangeProcessed) {
        this.bestSolutionHolder.set(bestSolution, isEveryProblemChangeProcessed);
        if (this.bestSolutionConsumer != null) {
            this.tryConsumeWaitingIntermediateBestSolution();
        }
    }

    void consumeFirstInitializedSolution(Solution_ firstInitializedSolution) {
        try {
            this.firstSolutionConsumption.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted when waiting for the first initialized solution consumption.");
        }
        this.firstInitializedSolution = firstInitializedSolution;
        this.scheduleFirstInitializedSolutionConsumption();
    }

    void consumeFinalBestSolution(Solution_ finalBestSolution) {
        try {
            this.activeConsumption.acquire();
            this.firstSolutionConsumption.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted when waiting for the final best solution consumption.");
        }
        if (this.bestSolutionConsumer != null) {
            this.scheduleIntermediateBestSolutionConsumption();
        }
        this.consumerExecutor.submit(() -> {
            try {
                this.finalBestSolutionConsumer.accept(finalBestSolution);
            }
            catch (Throwable throwable) {
                this.exceptionHandler.accept(this.problemId, throwable);
            }
            finally {
                if (this.bestSolutionConsumer == null) {
                    this.bestSolutionHolder.take().completeProblemChanges();
                }
                this.bestSolutionHolder.cancelPendingChanges();
                this.activeConsumption.release();
                this.firstSolutionConsumption.release();
                this.disposeConsumerThread();
            }
        });
    }

    private void tryConsumeWaitingIntermediateBestSolution() {
        if (this.bestSolutionHolder.isEmpty()) {
            return;
        }
        if (this.activeConsumption.tryAcquire()) {
            this.scheduleIntermediateBestSolutionConsumption().thenRunAsync(this::tryConsumeWaitingIntermediateBestSolution, this.consumerExecutor);
        }
    }

    private CompletableFuture<Void> scheduleIntermediateBestSolutionConsumption() {
        return CompletableFuture.runAsync(() -> {
            BestSolutionContainingProblemChanges<Solution_> bestSolutionContainingProblemChanges = this.bestSolutionHolder.take();
            if (bestSolutionContainingProblemChanges != null) {
                try {
                    this.bestSolutionConsumer.accept(bestSolutionContainingProblemChanges.getBestSolution());
                    bestSolutionContainingProblemChanges.completeProblemChanges();
                }
                catch (Throwable throwable) {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.accept(this.problemId, throwable);
                    }
                    bestSolutionContainingProblemChanges.completeProblemChangesExceptionally(throwable);
                }
                finally {
                    this.activeConsumption.release();
                }
            }
        }, this.consumerExecutor);
    }

    private void scheduleFirstInitializedSolutionConsumption() {
        CompletableFuture.runAsync(() -> {
            try {
                if (this.firstInitializedSolutionConsumer != null && this.firstInitializedSolution != null) {
                    this.firstInitializedSolutionConsumer.accept(this.firstInitializedSolution);
                }
            }
            catch (Throwable throwable) {
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.accept(this.problemId, throwable);
                }
            }
            finally {
                this.firstSolutionConsumption.release();
            }
        }, this.consumerExecutor);
    }

    @Override
    public void close() {
        this.disposeConsumerThread();
        this.bestSolutionHolder.cancelPendingChanges();
    }

    private void disposeConsumerThread() {
        this.consumerExecutor.shutdownNow();
    }
}

