/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.ScoreExplanation;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.solver.RecommendedFit;
import ai.timefold.solver.core.api.solver.ScoreAnalysisFetchPolicy;
import ai.timefold.solver.core.api.solver.SolutionManager;
import ai.timefold.solver.core.api.solver.SolutionUpdatePolicy;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.api.solver.SolverManager;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.score.DefaultScoreExplanation;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import ai.timefold.solver.core.impl.solver.DefaultSolverManager;
import ai.timefold.solver.core.impl.solver.Fitter;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public final class DefaultSolutionManager<Solution_, Score_ extends Score<Score_>>
implements SolutionManager<Solution_, Score_> {
    private final DefaultSolverFactory<Solution_> solverFactory;
    private final InnerScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory;

    public <ProblemId_> DefaultSolutionManager(SolverManager<Solution_, ProblemId_> solverManager) {
        this(((DefaultSolverManager)solverManager).getSolverFactory());
    }

    public DefaultSolutionManager(SolverFactory<Solution_> solverFactory) {
        this.solverFactory = (DefaultSolverFactory)solverFactory;
        this.scoreDirectorFactory = this.solverFactory.getScoreDirectorFactory();
    }

    public InnerScoreDirectorFactory<Solution_, Score_> getScoreDirectorFactory() {
        return this.scoreDirectorFactory;
    }

    @Override
    public Score_ update(Solution_ solution, SolutionUpdatePolicy solutionUpdatePolicy) {
        if (solutionUpdatePolicy == SolutionUpdatePolicy.NO_UPDATE) {
            throw new IllegalArgumentException("Can not call " + this.getClass().getSimpleName() + ".update() with this solutionUpdatePolicy (" + solutionUpdatePolicy + ").");
        }
        return (Score_)this.callScoreDirector(solution, solutionUpdatePolicy, s -> s.getSolutionDescriptor().getScore(s.getWorkingSolution()), false, false);
    }

    private <Result_> Result_ callScoreDirector(Solution_ solution, SolutionUpdatePolicy solutionUpdatePolicy, Function<InnerScoreDirector<Solution_, Score_>, Result_> function, boolean enableConstraintMatch, boolean cloneSolution) {
        boolean isShadowVariableUpdateEnabled = solutionUpdatePolicy.isShadowVariableUpdateEnabled();
        Solution_ nonNullSolution = Objects.requireNonNull(solution);
        try (InnerScoreDirector<Solution_, Score_> scoreDirector = this.getScoreDirectorFactory().buildScoreDirector(cloneSolution, enableConstraintMatch, !isShadowVariableUpdateEnabled);){
            nonNullSolution = cloneSolution ? scoreDirector.cloneSolution(nonNullSolution) : nonNullSolution;
            scoreDirector.setWorkingSolution(nonNullSolution);
            if (enableConstraintMatch && !scoreDirector.isConstraintMatchEnabled()) {
                throw new IllegalStateException("Requested constraint matching but score director doesn't support it.\nMaybe use Constraint Streams instead of Easy or Incremental score calculator?");
            }
            if (isShadowVariableUpdateEnabled) {
                scoreDirector.forceTriggerVariableListeners();
            }
            if (solutionUpdatePolicy.isScoreUpdateEnabled()) {
                scoreDirector.calculateScore();
            }
            Result_ Result_ = function.apply(scoreDirector);
            return Result_;
        }
    }

    @Override
    public ScoreExplanation<Solution_, Score_> explain(Solution_ solution, SolutionUpdatePolicy solutionUpdatePolicy) {
        Object currentScore = this.scoreDirectorFactory.getSolutionDescriptor().getScore(solution);
        DefaultScoreExplanation explanation = this.callScoreDirector(solution, solutionUpdatePolicy, DefaultScoreExplanation::new, true, false);
        this.assertFreshScore(solution, currentScore, explanation.getScore(), solutionUpdatePolicy);
        return explanation;
    }

    private void assertFreshScore(Solution_ solution, Score_ currentScore, Score_ calculatedScore, SolutionUpdatePolicy solutionUpdatePolicy) {
        if (!solutionUpdatePolicy.isScoreUpdateEnabled() && currentScore != null && !calculatedScore.equals(currentScore)) {
            throw new IllegalStateException("Current score (%s) and freshly calculated score (%s) for solution (%s) do not match.\nMaybe run %s environment mode to check for score corruptions.\nOtherwise enable %s.%s to update the stale score.\n".formatted(new Object[]{currentScore, calculatedScore, solution, EnvironmentMode.TRACKED_FULL_ASSERT, SolutionUpdatePolicy.class.getSimpleName(), SolutionUpdatePolicy.UPDATE_ALL}));
        }
    }

    @Override
    public ScoreAnalysis<Score_> analyze(Solution_ solution, ScoreAnalysisFetchPolicy fetchPolicy, SolutionUpdatePolicy solutionUpdatePolicy) {
        Objects.requireNonNull(fetchPolicy, "fetchPolicy");
        Object currentScore = this.scoreDirectorFactory.getSolutionDescriptor().getScore(solution);
        ScoreAnalysis analysis = this.callScoreDirector(solution, solutionUpdatePolicy, scoreDirector -> scoreDirector.buildScoreAnalysis(fetchPolicy == ScoreAnalysisFetchPolicy.FETCH_ALL), true, false);
        this.assertFreshScore(solution, currentScore, analysis.score(), solutionUpdatePolicy);
        return analysis;
    }

    @Override
    public <In_, Out_> List<RecommendedFit<Out_, Score_>> recommendFit(Solution_ solution, In_ fittedEntityOrElement, Function<In_, Out_> propositionFunction, ScoreAnalysisFetchPolicy fetchPolicy) {
        Fitter fitter = new Fitter(this.solverFactory, solution, fittedEntityOrElement, propositionFunction, fetchPolicy);
        return (List)this.callScoreDirector(solution, SolutionUpdatePolicy.UPDATE_ALL, fitter, true, true);
    }
}

