/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.solver.RecommendedFit;
import ai.timefold.solver.core.api.solver.ScoreAnalysisFetchPolicy;
import ai.timefold.solver.core.impl.constructionheuristic.DefaultConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.constructionheuristic.placer.EntityPlacer;
import ai.timefold.solver.core.impl.constructionheuristic.placer.Placement;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.phase.Phase;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.DefaultRecommendedFit;
import ai.timefold.solver.core.impl.solver.DefaultSolver;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;

public final class FitProcessor<Solution_, In_, Out_, Score_ extends Score<Score_>>
implements Function<InnerScoreDirector<Solution_, Score_>, List<RecommendedFit<Out_, Score_>>> {
    private final DefaultSolverFactory<Solution_> solverFactory;
    private final ScoreAnalysis<Score_> originalScoreAnalysis;
    private final ScoreAnalysisFetchPolicy fetchPolicy;
    private final Function<In_, Out_> valueResultFunction;
    private final In_ clonedElement;

    public FitProcessor(DefaultSolverFactory<Solution_> solverFactory, Function<In_, Out_> valueResultFunction, ScoreAnalysis<Score_> originalScoreAnalysis, In_ clonedElement, ScoreAnalysisFetchPolicy fetchPolicy) {
        this.solverFactory = Objects.requireNonNull(solverFactory);
        this.originalScoreAnalysis = Objects.requireNonNull(originalScoreAnalysis);
        this.fetchPolicy = Objects.requireNonNull(fetchPolicy);
        this.valueResultFunction = valueResultFunction;
        this.clonedElement = clonedElement;
    }

    @Override
    public List<RecommendedFit<Out_, Score_>> apply(InnerScoreDirector<Solution_, Score_> scoreDirector) {
        EntityPlacer entityPlacer = this.buildEntityPlacer().rebuildWithFilter((solution, selection) -> selection == this.clonedElement);
        SolverScope<Solution_> solverScope = new SolverScope<Solution_>();
        solverScope.setWorkingRandom(new Random(0L));
        solverScope.setScoreDirector(scoreDirector);
        ConstructionHeuristicPhaseScope phaseScope = new ConstructionHeuristicPhaseScope(solverScope, -1);
        ConstructionHeuristicStepScope stepScope = new ConstructionHeuristicStepScope(phaseScope);
        entityPlacer.solvingStarted(solverScope);
        entityPlacer.phaseStarted(phaseScope);
        entityPlacer.stepStarted(stepScope);
        try {
            InnerScoreDirector<Solution_, Score_> innerScoreDirector = scoreDirector;
            try {
                Iterator placementIterator = entityPlacer.iterator();
                if (!placementIterator.hasNext()) {
                    throw new IllegalStateException("Impossible state: entity placer (%s) has no placements.\n".formatted(entityPlacer));
                }
                Placement placement = (Placement)placementIterator.next();
                ArrayList<RecommendedFit<Object, Score_>> recommendedFitList = new ArrayList<RecommendedFit<Object, Score_>>();
                long moveIndex = 0L;
                for (Move move : placement) {
                    recommendedFitList.add(this.execute(scoreDirector, move, moveIndex, this.clonedElement, this.valueResultFunction));
                    ++moveIndex;
                }
                recommendedFitList.sort(null);
                ArrayList<RecommendedFit<Object, Score_>> arrayList = recommendedFitList;
                if (innerScoreDirector != null) {
                    innerScoreDirector.close();
                }
                return arrayList;
            }
            catch (Throwable throwable) {
                if (innerScoreDirector != null) {
                    try {
                        innerScoreDirector.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            entityPlacer.stepEnded(stepScope);
            entityPlacer.phaseEnded(phaseScope);
            entityPlacer.solvingEnded(solverScope);
        }
    }

    private EntityPlacer<Solution_> buildEntityPlacer() {
        DefaultSolver solver = (DefaultSolver)this.solverFactory.buildSolver();
        List phaseList = solver.getPhaseList();
        long constructionHeuristicCount = phaseList.stream().filter(s -> s instanceof DefaultConstructionHeuristicPhase).count();
        if (constructionHeuristicCount != 1L) {
            throw new IllegalStateException("Fit Recommendation API requires the solver config to have exactly one construction heuristic phase, but it has (%s) instead.".formatted(constructionHeuristicCount));
        }
        Phase phase = phaseList.get(0);
        if (phase instanceof DefaultConstructionHeuristicPhase) {
            DefaultConstructionHeuristicPhase constructionHeuristicPhase = (DefaultConstructionHeuristicPhase)phase;
            return constructionHeuristicPhase.getEntityPlacer();
        }
        throw new IllegalStateException("Fit Recommendation API requires the first solver phase (%s) in the solver config to be a construction heuristic.".formatted(phase));
    }

    private RecommendedFit<Out_, Score_> execute(InnerScoreDirector<Solution_, Score_> scoreDirector, Move<Solution_> move, long moveIndex, In_ clonedElement, Function<In_, Out_> propositionFunction) {
        Move<Solution_> undo = move.doMove(scoreDirector);
        ScoreAnalysis<Score_> newScoreAnalysis = scoreDirector.buildScoreAnalysis(this.fetchPolicy == ScoreAnalysisFetchPolicy.FETCH_ALL);
        ScoreAnalysis<Score_> newScoreDifference = newScoreAnalysis.diff(this.originalScoreAnalysis);
        Out_ result = propositionFunction.apply(clonedElement);
        DefaultRecommendedFit<Out_, Score_> recommendation = new DefaultRecommendedFit<Out_, Score_>(moveIndex, result, newScoreDifference);
        undo.doMoveOnly(scoreDirector);
        return recommendation;
    }
}

