/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.analysis.ScoreAnalysis;
import ai.timefold.solver.core.api.solver.RecommendedFit;
import ai.timefold.solver.core.api.solver.ScoreAnalysisFetchPolicy;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.DefaultSolverFactory;
import ai.timefold.solver.core.impl.solver.FitProcessor;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

final class Fitter<Solution_, In_, Out_, Score_ extends Score<Score_>>
implements Function<InnerScoreDirector<Solution_, Score_>, List<RecommendedFit<Out_, Score_>>> {
    private final DefaultSolverFactory<Solution_> solverFactory;
    private final Solution_ originalSolution;
    private final In_ originalElement;
    private final Function<In_, Out_> propositionFunction;
    private final ScoreAnalysisFetchPolicy fetchPolicy;

    public Fitter(DefaultSolverFactory<Solution_> solverFactory, Solution_ originalSolution, In_ originalElement, Function<In_, Out_> propositionFunction, ScoreAnalysisFetchPolicy fetchPolicy) {
        this.solverFactory = Objects.requireNonNull(solverFactory);
        this.originalSolution = Objects.requireNonNull(originalSolution);
        this.originalElement = Objects.requireNonNull(originalElement);
        this.propositionFunction = Objects.requireNonNull(propositionFunction);
        this.fetchPolicy = Objects.requireNonNull(fetchPolicy);
    }

    @Override
    public List<RecommendedFit<Out_, Score_>> apply(InnerScoreDirector<Solution_, Score_> scoreDirector) {
        SolutionDescriptor<Solution_> solutionDescriptor = scoreDirector.getSolutionDescriptor();
        SolutionDescriptor.SolutionInitializationStatistics initializationStatistics = solutionDescriptor.computeInitializationStatistics(this.originalSolution);
        int uninitializedCount = initializationStatistics.uninitializedEntityCount() + initializationStatistics.unassignedValueCount();
        if (uninitializedCount > 1) {
            throw new IllegalStateException("Solution (%s) has (%d) uninitialized elements.\nFit Recommendation API requires at most one uninitialized element in the solution.".formatted(this.originalSolution, uninitializedCount));
        }
        ScoreAnalysis<Score_> originalScoreAnalysis = scoreDirector.buildScoreAnalysis(this.fetchPolicy == ScoreAnalysisFetchPolicy.FETCH_ALL, InnerScoreDirector.ScoreAnalysisMode.RECOMMENDATION_API);
        In_ clonedElement = scoreDirector.lookUpWorkingObject(this.originalElement);
        FitProcessor<Solution_, In_, Out_, Score_> processor = new FitProcessor<Solution_, In_, Out_, Score_>(this.solverFactory, this.propositionFunction, originalScoreAnalysis, clonedElement, this.fetchPolicy);
        return processor.apply(scoreDirector);
    }
}

