/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractTermination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;

public final class UnimprovedStepCountTermination<Solution_>
extends AbstractTermination<Solution_> {
    private final int unimprovedStepCountLimit;

    public UnimprovedStepCountTermination(int unimprovedStepCountLimit) {
        this.unimprovedStepCountLimit = unimprovedStepCountLimit;
        if (unimprovedStepCountLimit < 0) {
            throw new IllegalArgumentException("The unimprovedStepCountLimit (%d) cannot be negative.".formatted(unimprovedStepCountLimit));
        }
    }

    @Override
    public boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used for phase termination.");
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        int unimprovedStepCount = UnimprovedStepCountTermination.calculateUnimprovedStepCount(phaseScope);
        return unimprovedStepCount >= this.unimprovedStepCountLimit;
    }

    private static int calculateUnimprovedStepCount(AbstractPhaseScope<?> phaseScope) {
        int bestStepIndex = phaseScope.getBestSolutionStepIndex();
        int lastStepIndex = phaseScope.getLastCompletedStepScope().getStepIndex();
        return lastStepIndex - bestStepIndex;
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used for phase termination.");
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        int unimprovedStepCount = UnimprovedStepCountTermination.calculateUnimprovedStepCount(phaseScope);
        double timeGradient = (double)unimprovedStepCount / (double)this.unimprovedStepCountLimit;
        return Math.min(timeGradient, 1.0);
    }

    @Override
    public UnimprovedStepCountTermination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return new UnimprovedStepCountTermination<Solution_>(this.unimprovedStepCountLimit);
    }

    public String toString() {
        return "UnimprovedStepCount(" + this.unimprovedStepCountLimit + ")";
    }
}

