/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.util;

import java.util.Objects;

public final class MutablePair<A, B> {
    private A key;
    private B value;

    public static <A, B> MutablePair<A, B> of(A key, B value) {
        return new MutablePair<A, B>(key, value);
    }

    private MutablePair(A key, B value) {
        this.key = key;
        this.value = value;
    }

    public A getKey() {
        return this.key;
    }

    public MutablePair<A, B> setKey(A key) {
        this.key = key;
        return this;
    }

    public B getValue() {
        return this.value;
    }

    public MutablePair<A, B> setValue(B value) {
        this.value = value;
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof MutablePair) {
            MutablePair other = (MutablePair)o;
            return Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value);
        }
        return false;
    }

    public int hashCode() {
        int result = Objects.hashCode(this.key);
        result = 31 * result + Objects.hashCode(this.value);
        return result;
    }

    public String toString() {
        return "(" + this.key + ", " + this.value + ")";
    }
}

