/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.analysis;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.analysis.MatchAnalysis;
import ai.timefold.solver.core.api.score.calculator.ConstraintMatchAwareIncrementalScoreCalculator;
import ai.timefold.solver.core.api.score.constraint.ConstraintRef;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.impl.score.constraint.DefaultConstraintMatchTotal;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public record ConstraintAnalysis<Score_ extends Score<Score_>>(@NonNull ConstraintRef constraintRef, @NonNull Score_ weight, @NonNull Score_ score, @Nullable List<MatchAnalysis<Score_>> matches, int matchCount) {
    public ConstraintAnalysis(@NonNull ConstraintRef constraintRef, @NonNull Score_ weight, @NonNull Score_ score, @Nullable List<MatchAnalysis<Score_>> matches) {
        this(constraintRef, weight, score, matches, matches == null ? -1 : matches.size());
    }

    public ConstraintAnalysis(@NonNull ConstraintRef constraintRef, @NonNull Score_ weight, @NonNull Score_ score, @Nullable List<MatchAnalysis<Score_>> matches, int matchCount) {
        Objects.requireNonNull(constraintRef);
        Objects.requireNonNull(weight, () -> "The constraint weight must be non-null.\nMaybe use a non-deprecated %s constructor in your %s implementation?".formatted(DefaultConstraintMatchTotal.class.getSimpleName(), ConstraintMatchAwareIncrementalScoreCalculator.class.getSimpleName()));
        Objects.requireNonNull(score);
        if (matches != null && matchCount != matches.size()) {
            throw new IllegalArgumentException("The match count must be equal to the size of the matches list.");
        }
    }

    ConstraintAnalysis<Score_> negate() {
        if (this.matches == null) {
            return new ConstraintAnalysis(this.constraintRef, this.weight.negate(), this.score.negate(), null, this.matchCount);
        }
        List<MatchAnalysis<Score_>> negatedMatchAnalyses = this.matches.stream().map(MatchAnalysis::negate).toList();
        return new ConstraintAnalysis(this.constraintRef, this.weight.negate(), this.score.negate(), negatedMatchAnalyses);
    }

    static <Score_ extends Score<Score_>> ConstraintAnalysis<Score_> diff(ConstraintRef constraintRef, ConstraintAnalysis<Score_> constraintAnalysis, ConstraintAnalysis<Score_> otherConstraintAnalysis) {
        if (constraintAnalysis == null) {
            if (otherConstraintAnalysis == null) {
                throw new IllegalStateException("Impossible state: none of the score explanations provided constraint matches for a constraint (%s).".formatted(constraintRef));
            }
            return otherConstraintAnalysis.negate();
        }
        if (otherConstraintAnalysis == null) {
            return constraintAnalysis;
        }
        List<MatchAnalysis<Score_>> matchAnalyses = constraintAnalysis.matches();
        List<MatchAnalysis<Score_>> otherMatchAnalyses = otherConstraintAnalysis.matches();
        if (matchAnalyses == null && otherMatchAnalyses != null || matchAnalyses != null && otherMatchAnalyses == null) {
            throw new IllegalStateException("Impossible state: One of the score analyses (%s, %s) provided no match analysis for a constraint (%s).".formatted(constraintAnalysis, otherConstraintAnalysis, constraintRef));
        }
        Score_ constraintWeightDifference = constraintAnalysis.weight().subtract(otherConstraintAnalysis.weight());
        Score_ scoreDifference = constraintAnalysis.score().subtract(otherConstraintAnalysis.score());
        if (matchAnalyses == null) {
            int leftCount = constraintAnalysis.matchCount();
            int rightCount = otherConstraintAnalysis.matchCount();
            if (leftCount == -1 && rightCount != -1 || leftCount != -1 && rightCount == -1) {
                throw new IllegalStateException("Impossible state: One of the score analyses (%s, %s) provided no match count for a constraint (%s).".formatted(constraintAnalysis, otherConstraintAnalysis, constraintRef));
            }
            return new ConstraintAnalysis<Score_>(constraintRef, constraintWeightDifference, scoreDifference, null, leftCount - rightCount);
        }
        Map matchAnalysisMap = ConstraintAnalysis.mapMatchesToJustifications(matchAnalyses);
        Map otherMatchAnalysisMap = ConstraintAnalysis.mapMatchesToJustifications(otherMatchAnalyses);
        List<MatchAnalysis<Score_>> result = Stream.concat(matchAnalysisMap.keySet().stream(), otherMatchAnalysisMap.keySet().stream()).distinct().map(justification -> {
            MatchAnalysis matchAnalysis = (MatchAnalysis)matchAnalysisMap.get(justification);
            MatchAnalysis otherMatchAnalysis = (MatchAnalysis)otherMatchAnalysisMap.get(justification);
            if (matchAnalysis == null) {
                if (otherMatchAnalysis == null) {
                    throw new IllegalStateException("Impossible state: none of the match analyses provided for a constraint (%s).".formatted(constraintRef));
                }
                return otherMatchAnalysis.negate();
            }
            if (otherMatchAnalysis == null) {
                return matchAnalysis;
            }
            return new MatchAnalysis(constraintRef, matchAnalysis.score().subtract(otherMatchAnalysis.score()), (ConstraintJustification)justification);
        }).toList();
        return new ConstraintAnalysis<Score_>(constraintRef, constraintWeightDifference, scoreDifference, result);
    }

    private static <Score_ extends Score<Score_>> Map<ConstraintJustification, MatchAnalysis<Score_>> mapMatchesToJustifications(List<MatchAnalysis<Score_>> matchAnalyses) {
        Map<ConstraintJustification, MatchAnalysis<Score_>> matchAnalysisMap = CollectionUtils.newLinkedHashMap(matchAnalyses.size());
        for (MatchAnalysis<Score_> matchAnalysis : matchAnalyses) {
            MatchAnalysis<Score_> previous = matchAnalysisMap.put(matchAnalysis.justification(), matchAnalysis);
            if (previous == null) continue;
            throw new IllegalStateException("Impossible state: multiple constraint matches (%s, %s) have the same justification (%s).".formatted(previous, matchAnalysis, matchAnalysis.justification()));
        }
        return matchAnalysisMap;
    }

    @Deprecated(forRemoval=true, since="1.13.0")
    public String constraintPackage() {
        return this.constraintRef.packageName();
    }

    public @NonNull String constraintName() {
        return this.constraintRef.constraintName();
    }

    public @NonNull String summarize() {
        StringBuilder summary = new StringBuilder();
        summary.append("Explanation of score (%s):\n    Constraint matches:\n".formatted(this.score));
        Comparator<MatchAnalysis> matchScoreComparator = Comparator.comparing(MatchAnalysis::score);
        List<MatchAnalysis<Score_>> constraintMatches = this.matches();
        if (constraintMatches == null) {
            throw new IllegalArgumentException("The constraint matches must be non-null.\nMaybe use ScoreAnalysisFetchPolicy.FETCH_ALL to request the score analysis\n");
        }
        if (constraintMatches.isEmpty()) {
            summary.append("%8s%s: constraint (%s) has no matches.\n".formatted(" ", this.score().toShortString(), this.constraintRef().constraintName()));
        } else {
            summary.append("%8s%s: constraint (%s) has %s matches:\n".formatted(" ", this.score().toShortString(), this.constraintRef().constraintName(), constraintMatches.size()));
        }
        constraintMatches.stream().sorted(matchScoreComparator).limit(3L).forEach(match -> summary.append("%12S%s: justified with (%s)\n".formatted(" ", match.score().toShortString(), match.justification())));
        if (constraintMatches.size() > 3) {
            summary.append("%12s%s\n".formatted(" ", "..."));
        }
        return summary.toString();
    }

    @Override
    public String toString() {
        if (this.matches == null) {
            return "(%s at %s, no matches)".formatted(this.score, this.weight);
        }
        return "(%s at %s, %s matches)".formatted(this.score, this.weight, this.matches.size());
    }
}

