/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.bendablelong;

import ai.timefold.solver.core.api.score.IBendableScore;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class BendableLongScore
implements IBendableScore<BendableLongScore> {
    private final int initScore;
    private final long[] hardScores;
    private final long[] softScores;

    public static @NonNull BendableLongScore parseScore(@NonNull String scoreString) {
        String[][] scoreTokens = ScoreUtil.parseBendableScoreTokens(BendableLongScore.class, scoreString);
        int initScore = ScoreUtil.parseInitScore(BendableLongScore.class, scoreString, scoreTokens[0][0]);
        long[] hardScores = new long[scoreTokens[1].length];
        for (int i = 0; i < hardScores.length; ++i) {
            hardScores[i] = ScoreUtil.parseLevelAsLong(BendableLongScore.class, scoreString, scoreTokens[1][i]);
        }
        long[] softScores = new long[scoreTokens[2].length];
        for (int i = 0; i < softScores.length; ++i) {
            softScores[i] = ScoreUtil.parseLevelAsLong(BendableLongScore.class, scoreString, scoreTokens[2][i]);
        }
        return BendableLongScore.ofUninitialized(initScore, hardScores, softScores);
    }

    public static @NonNull BendableLongScore ofUninitialized(int initScore, long @NonNull [] hardScores, long @NonNull [] softScores) {
        return new BendableLongScore(initScore, hardScores, softScores);
    }

    public static @NonNull BendableLongScore of(long @NonNull [] hardScores, long @NonNull [] softScores) {
        return new BendableLongScore(0, hardScores, softScores);
    }

    public static @NonNull BendableLongScore zero(int hardLevelsSize, int softLevelsSize) {
        return new BendableLongScore(0, new long[hardLevelsSize], new long[softLevelsSize]);
    }

    public static @NonNull BendableLongScore ofHard(int hardLevelsSize, int softLevelsSize, int hardLevel, long hardScore) {
        long[] hardScores = new long[hardLevelsSize];
        hardScores[hardLevel] = hardScore;
        return new BendableLongScore(0, hardScores, new long[softLevelsSize]);
    }

    public static @NonNull BendableLongScore ofSoft(int hardLevelsSize, int softLevelsSize, int softLevel, long softScore) {
        long[] softScores = new long[softLevelsSize];
        softScores[softLevel] = softScore;
        return new BendableLongScore(0, new long[hardLevelsSize], softScores);
    }

    private BendableLongScore() {
        this(Integer.MIN_VALUE, new long[0], new long[0]);
    }

    private BendableLongScore(int initScore, long @NonNull [] hardScores, long @NonNull [] softScores) {
        this.initScore = initScore;
        this.hardScores = hardScores;
        this.softScores = softScores;
    }

    @Override
    public int initScore() {
        return this.initScore;
    }

    public long @NonNull [] hardScores() {
        return Arrays.copyOf(this.hardScores, this.hardScores.length);
    }

    @Deprecated(forRemoval=true)
    public long @NonNull [] getHardScores() {
        return this.hardScores();
    }

    public long @NonNull [] softScores() {
        return Arrays.copyOf(this.softScores, this.softScores.length);
    }

    @Deprecated(forRemoval=true)
    public long @NonNull [] getSoftScores() {
        return this.softScores();
    }

    @Override
    public int hardLevelsSize() {
        return this.hardScores.length;
    }

    public long hardScore(int index) {
        return this.hardScores[index];
    }

    @Deprecated(forRemoval=true)
    public long getHardScore(int index) {
        return this.hardScore(index);
    }

    @Override
    public int softLevelsSize() {
        return this.softScores.length;
    }

    public long softScore(int index) {
        return this.softScores[index];
    }

    @Deprecated(forRemoval=true)
    public long getSoftScore(int index) {
        return this.softScore(index);
    }

    @Override
    public @NonNull BendableLongScore withInitScore(int newInitScore) {
        return new BendableLongScore(newInitScore, this.hardScores, this.softScores);
    }

    public long hardOrSoftScore(int index) {
        if (index < this.hardScores.length) {
            return this.hardScores[index];
        }
        return this.softScores[index - this.hardScores.length];
    }

    @Deprecated(forRemoval=true)
    public long getHardOrSoftScore(int index) {
        return this.hardOrSoftScore(index);
    }

    @Override
    public boolean isFeasible() {
        if (this.initScore < 0) {
            return false;
        }
        for (long hardScore : this.hardScores) {
            if (hardScore >= 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public @NonNull BendableLongScore add(@NonNull BendableLongScore addend) {
        int i;
        this.validateCompatible(addend);
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] + addend.hardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] + addend.softScore(i);
        }
        return new BendableLongScore(this.initScore + addend.initScore(), newHardScores, newSoftScores);
    }

    @Override
    public @NonNull BendableLongScore subtract(@NonNull BendableLongScore subtrahend) {
        int i;
        this.validateCompatible(subtrahend);
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i] - subtrahend.hardScore(i);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i] - subtrahend.softScore(i);
        }
        return new BendableLongScore(this.initScore - subtrahend.initScore(), newHardScores, newSoftScores);
    }

    @Override
    public @NonNull BendableLongScore multiply(double multiplicand) {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (long)Math.floor((double)this.hardScores[i] * multiplicand);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (long)Math.floor((double)this.softScores[i] * multiplicand);
        }
        return new BendableLongScore((int)Math.floor((double)this.initScore * multiplicand), newHardScores, newSoftScores);
    }

    @Override
    public @NonNull BendableLongScore divide(double divisor) {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (long)Math.floor((double)this.hardScores[i] / divisor);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (long)Math.floor((double)this.softScores[i] / divisor);
        }
        return new BendableLongScore((int)Math.floor((double)this.initScore / divisor), newHardScores, newSoftScores);
    }

    @Override
    public @NonNull BendableLongScore power(double exponent) {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = (long)Math.floor(Math.pow(this.hardScores[i], exponent));
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = (long)Math.floor(Math.pow(this.softScores[i], exponent));
        }
        return new BendableLongScore((int)Math.floor(Math.pow(this.initScore, exponent)), newHardScores, newSoftScores);
    }

    @Override
    public @NonNull BendableLongScore negate() {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = -this.hardScores[i];
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = -this.softScores[i];
        }
        return new BendableLongScore(-this.initScore, newHardScores, newSoftScores);
    }

    @Override
    public @NonNull BendableLongScore abs() {
        int i;
        long[] newHardScores = new long[this.hardScores.length];
        long[] newSoftScores = new long[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = Math.abs(this.hardScores[i]);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = Math.abs(this.softScores[i]);
        }
        return new BendableLongScore(Math.abs(this.initScore), newHardScores, newSoftScores);
    }

    @Override
    public @NonNull BendableLongScore zero() {
        return BendableLongScore.zero(this.hardLevelsSize(), this.softLevelsSize());
    }

    @Override
    public Number @NonNull [] toLevelNumbers() {
        int i;
        Number[] levelNumbers = new Number[this.hardScores.length + this.softScores.length];
        for (i = 0; i < this.hardScores.length; ++i) {
            levelNumbers[i] = this.hardScores[i];
        }
        for (i = 0; i < this.softScores.length; ++i) {
            levelNumbers[this.hardScores.length + i] = this.softScores[i];
        }
        return levelNumbers;
    }

    public boolean equals(Object o) {
        if (o instanceof BendableLongScore) {
            int i;
            BendableLongScore other = (BendableLongScore)o;
            if (this.hardLevelsSize() != other.hardLevelsSize() || this.softLevelsSize() != other.softLevelsSize()) {
                return false;
            }
            if (this.initScore != other.initScore()) {
                return false;
            }
            for (i = 0; i < this.hardScores.length; ++i) {
                if (this.hardScores[i] == other.hardScore(i)) continue;
                return false;
            }
            for (i = 0; i < this.softScores.length; ++i) {
                if (this.softScores[i] == other.softScore(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, Arrays.hashCode(this.hardScores), Arrays.hashCode(this.softScores));
    }

    @Override
    public int compareTo(@NonNull BendableLongScore other) {
        int i;
        this.validateCompatible(other);
        if (this.initScore != other.initScore()) {
            return Integer.compare(this.initScore, other.initScore());
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            if (this.hardScores[i] == other.hardScore(i)) continue;
            return Long.compare(this.hardScores[i], other.hardScore(i));
        }
        for (i = 0; i < this.softScores.length; ++i) {
            if (this.softScores[i] == other.softScore(i)) continue;
            return Long.compare(this.softScores[i], other.softScore(i));
        }
        return 0;
    }

    @Override
    public @NonNull String toShortString() {
        return ScoreUtil.buildBendableShortString(this, n -> n.longValue() != 0L);
    }

    public String toString() {
        StringBuilder s = new StringBuilder((this.hardScores.length + this.softScores.length) * 4 + 13);
        s.append(ScoreUtil.getInitPrefix(this.initScore));
        s.append("[");
        boolean first = true;
        for (long hardScore : this.hardScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(hardScore);
        }
        s.append("]hard/[");
        first = true;
        for (long softScore : this.softScores) {
            if (first) {
                first = false;
            } else {
                s.append("/");
            }
            s.append(softScore);
        }
        s.append("]soft");
        return s.toString();
    }

    public void validateCompatible(BendableLongScore other) {
        if (this.hardLevelsSize() != other.hardLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with hardScoreSize (" + this.hardLevelsSize() + ") is not compatible with the other score (" + other + ") with hardScoreSize (" + other.hardLevelsSize() + ").");
        }
        if (this.softLevelsSize() != other.softLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with softScoreSize (" + this.softLevelsSize() + ") is not compatible with the other score (" + other + ") with softScoreSize (" + other.softLevelsSize() + ").");
        }
    }
}

