/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.hardmediumsoft;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class HardMediumSoftScore
implements Score<HardMediumSoftScore> {
    public static final @NonNull HardMediumSoftScore ZERO = new HardMediumSoftScore(0, 0, 0, 0);
    public static final @NonNull HardMediumSoftScore ONE_HARD = new HardMediumSoftScore(0, 1, 0, 0);
    private static final @NonNull HardMediumSoftScore MINUS_ONE_HARD = new HardMediumSoftScore(0, -1, 0, 0);
    public static final @NonNull HardMediumSoftScore ONE_MEDIUM = new HardMediumSoftScore(0, 0, 1, 0);
    private static final @NonNull HardMediumSoftScore MINUS_ONE_MEDIUM = new HardMediumSoftScore(0, 0, -1, 0);
    public static final @NonNull HardMediumSoftScore ONE_SOFT = new HardMediumSoftScore(0, 0, 0, 1);
    private static final @NonNull HardMediumSoftScore MINUS_ONE_SOFT = new HardMediumSoftScore(0, 0, 0, -1);
    private final int initScore;
    private final int hardScore;
    private final int mediumScore;
    private final int softScore;

    public static @NonNull HardMediumSoftScore parseScore(@NonNull String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(HardMediumSoftScore.class, scoreString, "hard", "medium", "soft");
        int initScore = ScoreUtil.parseInitScore(HardMediumSoftScore.class, scoreString, scoreTokens[0]);
        int hardScore = ScoreUtil.parseLevelAsInt(HardMediumSoftScore.class, scoreString, scoreTokens[1]);
        int mediumScore = ScoreUtil.parseLevelAsInt(HardMediumSoftScore.class, scoreString, scoreTokens[2]);
        int softScore = ScoreUtil.parseLevelAsInt(HardMediumSoftScore.class, scoreString, scoreTokens[3]);
        return HardMediumSoftScore.ofUninitialized(initScore, hardScore, mediumScore, softScore);
    }

    public static @NonNull HardMediumSoftScore ofUninitialized(int initScore, int hardScore, int mediumScore, int softScore) {
        if (initScore == 0) {
            return HardMediumSoftScore.of(hardScore, mediumScore, softScore);
        }
        return new HardMediumSoftScore(initScore, hardScore, mediumScore, softScore);
    }

    public static @NonNull HardMediumSoftScore of(int hardScore, int mediumScore, int softScore) {
        if (hardScore == -1 && mediumScore == 0 && softScore == 0) {
            return MINUS_ONE_HARD;
        }
        if (hardScore == 0) {
            if (mediumScore == -1 && softScore == 0) {
                return MINUS_ONE_MEDIUM;
            }
            if (mediumScore == 0) {
                if (softScore == -1) {
                    return MINUS_ONE_SOFT;
                }
                if (softScore == 0) {
                    return ZERO;
                }
                if (softScore == 1) {
                    return ONE_SOFT;
                }
            } else if (mediumScore == 1 && softScore == 0) {
                return ONE_MEDIUM;
            }
        } else if (hardScore == 1 && mediumScore == 0 && softScore == 0) {
            return ONE_HARD;
        }
        return new HardMediumSoftScore(0, hardScore, mediumScore, softScore);
    }

    public static @NonNull HardMediumSoftScore ofHard(int hardScore) {
        return switch (hardScore) {
            case -1 -> MINUS_ONE_HARD;
            case 0 -> ZERO;
            case 1 -> ONE_HARD;
            default -> new HardMediumSoftScore(0, hardScore, 0, 0);
        };
    }

    public static @NonNull HardMediumSoftScore ofMedium(int mediumScore) {
        return switch (mediumScore) {
            case -1 -> MINUS_ONE_MEDIUM;
            case 0 -> ZERO;
            case 1 -> ONE_MEDIUM;
            default -> new HardMediumSoftScore(0, 0, mediumScore, 0);
        };
    }

    public static @NonNull HardMediumSoftScore ofSoft(int softScore) {
        return switch (softScore) {
            case -1 -> MINUS_ONE_SOFT;
            case 0 -> ZERO;
            case 1 -> ONE_SOFT;
            default -> new HardMediumSoftScore(0, 0, 0, softScore);
        };
    }

    private HardMediumSoftScore() {
        this(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    private HardMediumSoftScore(int initScore, int hardScore, int mediumScore, int softScore) {
        this.initScore = initScore;
        this.hardScore = hardScore;
        this.mediumScore = mediumScore;
        this.softScore = softScore;
    }

    @Override
    public int initScore() {
        return this.initScore;
    }

    public int hardScore() {
        return this.hardScore;
    }

    @Deprecated(forRemoval=true)
    public int getHardScore() {
        return this.hardScore;
    }

    public int mediumScore() {
        return this.mediumScore;
    }

    @Deprecated(forRemoval=true)
    public int getMediumScore() {
        return this.mediumScore;
    }

    public int softScore() {
        return this.softScore;
    }

    @Deprecated(forRemoval=true)
    public int getSoftScore() {
        return this.softScore;
    }

    @Override
    public @NonNull HardMediumSoftScore withInitScore(int newInitScore) {
        return HardMediumSoftScore.ofUninitialized(newInitScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore >= 0;
    }

    @Override
    public @NonNull HardMediumSoftScore add(@NonNull HardMediumSoftScore addend) {
        return HardMediumSoftScore.ofUninitialized(this.initScore + addend.initScore(), this.hardScore + addend.hardScore(), this.mediumScore + addend.mediumScore(), this.softScore + addend.softScore());
    }

    @Override
    public @NonNull HardMediumSoftScore subtract(@NonNull HardMediumSoftScore subtrahend) {
        return HardMediumSoftScore.ofUninitialized(this.initScore - subtrahend.initScore(), this.hardScore - subtrahend.hardScore(), this.mediumScore - subtrahend.mediumScore(), this.softScore - subtrahend.softScore());
    }

    @Override
    public @NonNull HardMediumSoftScore multiply(double multiplicand) {
        return HardMediumSoftScore.ofUninitialized((int)Math.floor((double)this.initScore * multiplicand), (int)Math.floor((double)this.hardScore * multiplicand), (int)Math.floor((double)this.mediumScore * multiplicand), (int)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public @NonNull HardMediumSoftScore divide(double divisor) {
        return HardMediumSoftScore.ofUninitialized((int)Math.floor((double)this.initScore / divisor), (int)Math.floor((double)this.hardScore / divisor), (int)Math.floor((double)this.mediumScore / divisor), (int)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public @NonNull HardMediumSoftScore power(double exponent) {
        return HardMediumSoftScore.ofUninitialized((int)Math.floor(Math.pow(this.initScore, exponent)), (int)Math.floor(Math.pow(this.hardScore, exponent)), (int)Math.floor(Math.pow(this.mediumScore, exponent)), (int)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public @NonNull HardMediumSoftScore abs() {
        return HardMediumSoftScore.ofUninitialized(Math.abs(this.initScore), Math.abs(this.hardScore), Math.abs(this.mediumScore), Math.abs(this.softScore));
    }

    @Override
    public @NonNull HardMediumSoftScore zero() {
        return ZERO;
    }

    @Override
    public Number @NonNull [] toLevelNumbers() {
        return new Number[]{this.hardScore, this.mediumScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (o instanceof HardMediumSoftScore) {
            HardMediumSoftScore other = (HardMediumSoftScore)o;
            return this.initScore == other.initScore() && this.hardScore == other.hardScore() && this.mediumScore == other.mediumScore() && this.softScore == other.softScore();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public int compareTo(@NonNull HardMediumSoftScore other) {
        if (this.initScore != other.initScore()) {
            return Integer.compare(this.initScore, other.initScore());
        }
        if (this.hardScore != other.hardScore()) {
            return Integer.compare(this.hardScore, other.hardScore());
        }
        if (this.mediumScore != other.mediumScore()) {
            return Integer.compare(this.mediumScore, other.mediumScore());
        }
        return Integer.compare(this.softScore, other.softScore());
    }

    @Override
    public @NonNull String toShortString() {
        return ScoreUtil.buildShortString(this, n -> n.intValue() != 0, "hard", "medium", "soft");
    }

    public String toString() {
        return ScoreUtil.getInitPrefix(this.initScore) + this.hardScore + "hard/" + this.mediumScore + "medium/" + this.softScore + "soft";
    }
}

