/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.hardmediumsoftbigdecimal;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class HardMediumSoftBigDecimalScore
implements Score<HardMediumSoftBigDecimalScore> {
    public static final @NonNull HardMediumSoftBigDecimalScore ZERO = new HardMediumSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    public static final @NonNull HardMediumSoftBigDecimalScore ONE_HARD = new HardMediumSoftBigDecimalScore(0, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final @NonNull HardMediumSoftBigDecimalScore MINUS_ONE_HARD = new HardMediumSoftBigDecimalScore(0, BigDecimal.ONE.negate(), BigDecimal.ZERO, BigDecimal.ZERO);
    public static final @NonNull HardMediumSoftBigDecimalScore ONE_MEDIUM = new HardMediumSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO);
    private static final @NonNull HardMediumSoftBigDecimalScore MINUS_ONE_MEDIUM = new HardMediumSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ONE.negate(), BigDecimal.ZERO);
    public static final @NonNull HardMediumSoftBigDecimalScore ONE_SOFT = new HardMediumSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE);
    private static final @NonNull HardMediumSoftBigDecimalScore MINUS_ONE_SOFT = new HardMediumSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE.negate());
    private final int initScore;
    private final @NonNull BigDecimal hardScore;
    private final @NonNull BigDecimal mediumScore;
    private final @NonNull BigDecimal softScore;

    public static @NonNull HardMediumSoftBigDecimalScore parseScore(@NonNull String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(HardMediumSoftBigDecimalScore.class, scoreString, "hard", "medium", "soft");
        int initScore = ScoreUtil.parseInitScore(HardMediumSoftBigDecimalScore.class, scoreString, scoreTokens[0]);
        BigDecimal hardScore = ScoreUtil.parseLevelAsBigDecimal(HardMediumSoftBigDecimalScore.class, scoreString, scoreTokens[1]);
        BigDecimal mediumScore = ScoreUtil.parseLevelAsBigDecimal(HardMediumSoftBigDecimalScore.class, scoreString, scoreTokens[2]);
        BigDecimal softScore = ScoreUtil.parseLevelAsBigDecimal(HardMediumSoftBigDecimalScore.class, scoreString, scoreTokens[3]);
        return HardMediumSoftBigDecimalScore.ofUninitialized(initScore, hardScore, mediumScore, softScore);
    }

    public static @NonNull HardMediumSoftBigDecimalScore ofUninitialized(int initScore, @NonNull BigDecimal hardScore, @NonNull BigDecimal mediumScore, @NonNull BigDecimal softScore) {
        if (initScore == 0) {
            return HardMediumSoftBigDecimalScore.of(hardScore, mediumScore, softScore);
        }
        return new HardMediumSoftBigDecimalScore(initScore, hardScore, mediumScore, softScore);
    }

    public static @NonNull HardMediumSoftBigDecimalScore of(@NonNull BigDecimal hardScore, @NonNull BigDecimal mediumScore, @NonNull BigDecimal softScore) {
        if (Objects.equals(hardScore, BigDecimal.ONE.negate()) && mediumScore.signum() == 0 && softScore.signum() == 0) {
            return MINUS_ONE_HARD;
        }
        if (hardScore.signum() == 0) {
            if (Objects.equals(mediumScore, BigDecimal.ONE.negate()) && softScore.signum() == 0) {
                return MINUS_ONE_MEDIUM;
            }
            if (mediumScore.signum() == 0) {
                if (Objects.equals(softScore, BigDecimal.ONE.negate())) {
                    return MINUS_ONE_SOFT;
                }
                if (softScore.signum() == 0) {
                    return ZERO;
                }
                if (Objects.equals(softScore, BigDecimal.ONE)) {
                    return ONE_SOFT;
                }
            } else if (Objects.equals(mediumScore, BigDecimal.ONE) && softScore.signum() == 0) {
                return ONE_MEDIUM;
            }
        } else if (Objects.equals(hardScore, BigDecimal.ONE) && mediumScore.signum() == 0 && softScore.signum() == 0) {
            return ONE_HARD;
        }
        return new HardMediumSoftBigDecimalScore(0, hardScore, mediumScore, softScore);
    }

    public static @NonNull HardMediumSoftBigDecimalScore ofHard(@NonNull BigDecimal hardScore) {
        if (Objects.equals(hardScore, BigDecimal.ONE.negate())) {
            return MINUS_ONE_HARD;
        }
        if (hardScore.signum() == 0) {
            return ZERO;
        }
        if (Objects.equals(hardScore, BigDecimal.ONE)) {
            return ONE_HARD;
        }
        return new HardMediumSoftBigDecimalScore(0, hardScore, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public static @NonNull HardMediumSoftBigDecimalScore ofMedium(@NonNull BigDecimal mediumScore) {
        if (Objects.equals(mediumScore, BigDecimal.ONE.negate())) {
            return MINUS_ONE_MEDIUM;
        }
        if (mediumScore.signum() == 0) {
            return ZERO;
        }
        if (Objects.equals(mediumScore, BigDecimal.ONE)) {
            return ONE_MEDIUM;
        }
        return new HardMediumSoftBigDecimalScore(0, BigDecimal.ZERO, mediumScore, BigDecimal.ZERO);
    }

    public static @NonNull HardMediumSoftBigDecimalScore ofSoft(@NonNull BigDecimal softScore) {
        if (Objects.equals(softScore, BigDecimal.ONE.negate())) {
            return MINUS_ONE_SOFT;
        }
        if (softScore.signum() == 0) {
            return ZERO;
        }
        if (Objects.equals(softScore, BigDecimal.ONE)) {
            return ONE_SOFT;
        }
        return new HardMediumSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ZERO, softScore);
    }

    private HardMediumSoftBigDecimalScore() {
        this(Integer.MIN_VALUE, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private HardMediumSoftBigDecimalScore(int initScore, @NonNull BigDecimal hardScore, @NonNull BigDecimal mediumScore, @NonNull BigDecimal softScore) {
        this.initScore = initScore;
        this.hardScore = hardScore;
        this.mediumScore = mediumScore;
        this.softScore = softScore;
    }

    @Override
    public int initScore() {
        return this.initScore;
    }

    public @NonNull BigDecimal hardScore() {
        return this.hardScore;
    }

    @Deprecated(forRemoval=true)
    public @NonNull BigDecimal getHardScore() {
        return this.hardScore;
    }

    public @NonNull BigDecimal mediumScore() {
        return this.mediumScore;
    }

    @Deprecated(forRemoval=true)
    public @NonNull BigDecimal getMediumScore() {
        return this.mediumScore;
    }

    public @NonNull BigDecimal softScore() {
        return this.softScore;
    }

    @Deprecated(forRemoval=true)
    public @NonNull BigDecimal getSoftScore() {
        return this.softScore;
    }

    @Override
    public @NonNull HardMediumSoftBigDecimalScore withInitScore(int newInitScore) {
        return HardMediumSoftBigDecimalScore.ofUninitialized(newInitScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore.compareTo(BigDecimal.ZERO) >= 0;
    }

    @Override
    public @NonNull HardMediumSoftBigDecimalScore add(@NonNull HardMediumSoftBigDecimalScore addend) {
        return HardMediumSoftBigDecimalScore.ofUninitialized(this.initScore + addend.initScore(), this.hardScore.add(addend.hardScore()), this.mediumScore.add(addend.mediumScore()), this.softScore.add(addend.softScore()));
    }

    @Override
    public @NonNull HardMediumSoftBigDecimalScore subtract(@NonNull HardMediumSoftBigDecimalScore subtrahend) {
        return HardMediumSoftBigDecimalScore.ofUninitialized(this.initScore - subtrahend.initScore(), this.hardScore.subtract(subtrahend.hardScore()), this.mediumScore.subtract(subtrahend.mediumScore()), this.softScore.subtract(subtrahend.softScore()));
    }

    @Override
    public @NonNull HardMediumSoftBigDecimalScore multiply(double multiplicand) {
        BigDecimal multiplicandBigDecimal = BigDecimal.valueOf(multiplicand);
        return HardMediumSoftBigDecimalScore.ofUninitialized((int)Math.floor((double)this.initScore * multiplicand), this.hardScore.multiply(multiplicandBigDecimal).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.mediumScore.multiply(multiplicandBigDecimal).setScale(this.mediumScore.scale(), RoundingMode.FLOOR), this.softScore.multiply(multiplicandBigDecimal).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public @NonNull HardMediumSoftBigDecimalScore divide(double divisor) {
        BigDecimal divisorBigDecimal = BigDecimal.valueOf(divisor);
        return HardMediumSoftBigDecimalScore.ofUninitialized((int)Math.floor((double)this.initScore / divisor), this.hardScore.divide(divisorBigDecimal, this.hardScore.scale(), RoundingMode.FLOOR), this.mediumScore.divide(divisorBigDecimal, this.mediumScore.scale(), RoundingMode.FLOOR), this.softScore.divide(divisorBigDecimal, this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public @NonNull HardMediumSoftBigDecimalScore power(double exponent) {
        BigDecimal exponentBigDecimal = BigDecimal.valueOf(exponent);
        return HardMediumSoftBigDecimalScore.ofUninitialized((int)Math.floor(Math.pow(this.initScore, exponent)), this.hardScore.pow(exponentBigDecimal.intValue()).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.mediumScore.pow(exponentBigDecimal.intValue()).setScale(this.mediumScore.scale(), RoundingMode.FLOOR), this.softScore.pow(exponentBigDecimal.intValue()).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public @NonNull HardMediumSoftBigDecimalScore abs() {
        return HardMediumSoftBigDecimalScore.ofUninitialized(Math.abs(this.initScore), this.hardScore.abs(), this.mediumScore.abs(), this.softScore.abs());
    }

    @Override
    public @NonNull HardMediumSoftBigDecimalScore zero() {
        return ZERO;
    }

    @Override
    public @NonNull Number @NonNull [] toLevelNumbers() {
        return new Number[]{this.hardScore, this.mediumScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (o instanceof HardMediumSoftBigDecimalScore) {
            HardMediumSoftBigDecimalScore other = (HardMediumSoftBigDecimalScore)o;
            return this.initScore == other.initScore() && this.hardScore.stripTrailingZeros().equals(other.hardScore().stripTrailingZeros()) && this.mediumScore.stripTrailingZeros().equals(other.mediumScore().stripTrailingZeros()) && this.softScore.stripTrailingZeros().equals(other.softScore().stripTrailingZeros());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.hardScore.stripTrailingZeros(), this.mediumScore.stripTrailingZeros(), this.softScore.stripTrailingZeros());
    }

    @Override
    public int compareTo(@NonNull HardMediumSoftBigDecimalScore other) {
        if (this.initScore != other.initScore()) {
            return Integer.compare(this.initScore, other.initScore());
        }
        int hardScoreComparison = this.hardScore.compareTo(other.hardScore());
        if (hardScoreComparison != 0) {
            return hardScoreComparison;
        }
        int mediumScoreComparison = this.mediumScore.compareTo(other.mediumScore());
        if (mediumScoreComparison != 0) {
            return mediumScoreComparison;
        }
        return this.softScore.compareTo(other.softScore());
    }

    @Override
    public @NonNull String toShortString() {
        return ScoreUtil.buildShortString(this, n -> ((BigDecimal)n).compareTo(BigDecimal.ZERO) != 0, "hard", "medium", "soft");
    }

    public String toString() {
        return ScoreUtil.getInitPrefix(this.initScore) + this.hardScore + "hard/" + this.mediumScore + "medium/" + this.softScore + "soft";
    }
}

