/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.hardmediumsoftlong;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class HardMediumSoftLongScore
implements Score<HardMediumSoftLongScore> {
    public static final @NonNull HardMediumSoftLongScore ZERO = new HardMediumSoftLongScore(0, 0L, 0L, 0L);
    public static final @NonNull HardMediumSoftLongScore ONE_HARD = new HardMediumSoftLongScore(0, 1L, 0L, 0L);
    private static final @NonNull HardMediumSoftLongScore MINUS_ONE_HARD = new HardMediumSoftLongScore(0, -1L, 0L, 0L);
    public static final @NonNull HardMediumSoftLongScore ONE_MEDIUM = new HardMediumSoftLongScore(0, 0L, 1L, 0L);
    private static final @NonNull HardMediumSoftLongScore MINUS_ONE_MEDIUM = new HardMediumSoftLongScore(0, 0L, -1L, 0L);
    public static final @NonNull HardMediumSoftLongScore ONE_SOFT = new HardMediumSoftLongScore(0, 0L, 0L, 1L);
    private static final @NonNull HardMediumSoftLongScore MINUS_ONE_SOFT = new HardMediumSoftLongScore(0, 0L, 0L, -1L);
    private final int initScore;
    private final long hardScore;
    private final long mediumScore;
    private final long softScore;

    public static @NonNull HardMediumSoftLongScore parseScore(@NonNull String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(HardMediumSoftLongScore.class, scoreString, "hard", "medium", "soft");
        int initScore = ScoreUtil.parseInitScore(HardMediumSoftLongScore.class, scoreString, scoreTokens[0]);
        long hardScore = ScoreUtil.parseLevelAsLong(HardMediumSoftLongScore.class, scoreString, scoreTokens[1]);
        long mediumScore = ScoreUtil.parseLevelAsLong(HardMediumSoftLongScore.class, scoreString, scoreTokens[2]);
        long softScore = ScoreUtil.parseLevelAsLong(HardMediumSoftLongScore.class, scoreString, scoreTokens[3]);
        return HardMediumSoftLongScore.ofUninitialized(initScore, hardScore, mediumScore, softScore);
    }

    public static @NonNull HardMediumSoftLongScore ofUninitialized(int initScore, long hardScore, long mediumScore, long softScore) {
        if (initScore == 0) {
            return HardMediumSoftLongScore.of(hardScore, mediumScore, softScore);
        }
        return new HardMediumSoftLongScore(initScore, hardScore, mediumScore, softScore);
    }

    public static @NonNull HardMediumSoftLongScore of(long hardScore, long mediumScore, long softScore) {
        if (hardScore == -1L && mediumScore == 0L && softScore == 0L) {
            return MINUS_ONE_HARD;
        }
        if (hardScore == 0L) {
            if (mediumScore == -1L && softScore == 0L) {
                return MINUS_ONE_MEDIUM;
            }
            if (mediumScore == 0L) {
                if (softScore == -1L) {
                    return MINUS_ONE_SOFT;
                }
                if (softScore == 0L) {
                    return ZERO;
                }
                if (softScore == 1L) {
                    return ONE_SOFT;
                }
            } else if (mediumScore == 1L && softScore == 0L) {
                return ONE_MEDIUM;
            }
        } else if (hardScore == 1L && mediumScore == 0L && softScore == 0L) {
            return ONE_HARD;
        }
        return new HardMediumSoftLongScore(0, hardScore, mediumScore, softScore);
    }

    public static @NonNull HardMediumSoftLongScore ofHard(long hardScore) {
        if (hardScore == -1L) {
            return MINUS_ONE_HARD;
        }
        if (hardScore == 0L) {
            return ZERO;
        }
        if (hardScore == 1L) {
            return ONE_HARD;
        }
        return new HardMediumSoftLongScore(0, hardScore, 0L, 0L);
    }

    public static @NonNull HardMediumSoftLongScore ofMedium(long mediumScore) {
        if (mediumScore == -1L) {
            return MINUS_ONE_MEDIUM;
        }
        if (mediumScore == 0L) {
            return ZERO;
        }
        if (mediumScore == 1L) {
            return ONE_MEDIUM;
        }
        return new HardMediumSoftLongScore(0, 0L, mediumScore, 0L);
    }

    public static @NonNull HardMediumSoftLongScore ofSoft(long softScore) {
        if (softScore == -1L) {
            return MINUS_ONE_SOFT;
        }
        if (softScore == 0L) {
            return ZERO;
        }
        if (softScore == 1L) {
            return ONE_SOFT;
        }
        return new HardMediumSoftLongScore(0, 0L, 0L, softScore);
    }

    private HardMediumSoftLongScore() {
        this(Integer.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE, Long.MIN_VALUE);
    }

    private HardMediumSoftLongScore(int initScore, long hardScore, long mediumScore, long softScore) {
        this.initScore = initScore;
        this.hardScore = hardScore;
        this.mediumScore = mediumScore;
        this.softScore = softScore;
    }

    @Override
    public int initScore() {
        return this.initScore;
    }

    public long hardScore() {
        return this.hardScore;
    }

    @Deprecated(forRemoval=true)
    public long getHardScore() {
        return this.hardScore;
    }

    public long mediumScore() {
        return this.mediumScore;
    }

    @Deprecated(forRemoval=true)
    public long getMediumScore() {
        return this.mediumScore;
    }

    public long softScore() {
        return this.softScore;
    }

    @Deprecated(forRemoval=true)
    public long getSoftScore() {
        return this.softScore;
    }

    @Override
    public @NonNull HardMediumSoftLongScore withInitScore(int newInitScore) {
        return HardMediumSoftLongScore.ofUninitialized(newInitScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore >= 0L;
    }

    @Override
    public @NonNull HardMediumSoftLongScore add(@NonNull HardMediumSoftLongScore addend) {
        return HardMediumSoftLongScore.ofUninitialized(this.initScore + addend.initScore(), this.hardScore + addend.hardScore(), this.mediumScore + addend.mediumScore(), this.softScore + addend.softScore());
    }

    @Override
    public @NonNull HardMediumSoftLongScore subtract(@NonNull HardMediumSoftLongScore subtrahend) {
        return HardMediumSoftLongScore.ofUninitialized(this.initScore - subtrahend.initScore(), this.hardScore - subtrahend.hardScore(), this.mediumScore - subtrahend.mediumScore(), this.softScore - subtrahend.softScore());
    }

    @Override
    public @NonNull HardMediumSoftLongScore multiply(double multiplicand) {
        return HardMediumSoftLongScore.ofUninitialized((int)Math.floor((double)this.initScore * multiplicand), (long)Math.floor((double)this.hardScore * multiplicand), (long)Math.floor((double)this.mediumScore * multiplicand), (long)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public @NonNull HardMediumSoftLongScore divide(double divisor) {
        return HardMediumSoftLongScore.ofUninitialized((int)Math.floor((double)this.initScore / divisor), (long)Math.floor((double)this.hardScore / divisor), (long)Math.floor((double)this.mediumScore / divisor), (long)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public @NonNull HardMediumSoftLongScore power(double exponent) {
        return HardMediumSoftLongScore.ofUninitialized((int)Math.floor(Math.pow(this.initScore, exponent)), (long)Math.floor(Math.pow(this.hardScore, exponent)), (long)Math.floor(Math.pow(this.mediumScore, exponent)), (long)Math.floor(Math.pow(this.softScore, exponent)));
    }

    @Override
    public @NonNull HardMediumSoftLongScore abs() {
        return HardMediumSoftLongScore.ofUninitialized(Math.abs(this.initScore), Math.abs(this.hardScore), Math.abs(this.mediumScore), Math.abs(this.softScore));
    }

    @Override
    public @NonNull HardMediumSoftLongScore zero() {
        return ZERO;
    }

    @Override
    public Number @NonNull [] toLevelNumbers() {
        return new Number[]{this.hardScore, this.mediumScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (o instanceof HardMediumSoftLongScore) {
            HardMediumSoftLongScore other = (HardMediumSoftLongScore)o;
            return this.initScore == other.initScore() && this.hardScore == other.hardScore() && this.mediumScore == other.mediumScore() && this.softScore == other.softScore();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.hardScore, this.mediumScore, this.softScore);
    }

    @Override
    public int compareTo(@NonNull HardMediumSoftLongScore other) {
        if (this.initScore != other.initScore()) {
            return Integer.compare(this.initScore, other.initScore());
        }
        if (this.hardScore != other.hardScore()) {
            return Long.compare(this.hardScore, other.hardScore());
        }
        if (this.mediumScore != other.mediumScore()) {
            return Long.compare(this.mediumScore, other.mediumScore());
        }
        return Long.compare(this.softScore, other.softScore());
    }

    @Override
    public @NonNull String toShortString() {
        return ScoreUtil.buildShortString(this, n -> n.longValue() != 0L, "hard", "medium", "soft");
    }

    public String toString() {
        return ScoreUtil.getInitPrefix(this.initScore) + this.hardScore + "hard/" + this.mediumScore + "medium/" + this.softScore + "soft";
    }
}

