/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.simplebigdecimal;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class SimpleBigDecimalScore
implements Score<SimpleBigDecimalScore> {
    public static final @NonNull SimpleBigDecimalScore ZERO = new SimpleBigDecimalScore(0, BigDecimal.ZERO);
    public static final @NonNull SimpleBigDecimalScore ONE = new SimpleBigDecimalScore(0, BigDecimal.ONE);
    private final int initScore;
    private final @NonNull BigDecimal score;

    public static @NonNull SimpleBigDecimalScore parseScore(@NonNull String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(SimpleBigDecimalScore.class, scoreString, "");
        int initScore = ScoreUtil.parseInitScore(SimpleBigDecimalScore.class, scoreString, scoreTokens[0]);
        BigDecimal score = ScoreUtil.parseLevelAsBigDecimal(SimpleBigDecimalScore.class, scoreString, scoreTokens[1]);
        return SimpleBigDecimalScore.ofUninitialized(initScore, score);
    }

    public static @NonNull SimpleBigDecimalScore ofUninitialized(int initScore, @NonNull BigDecimal score) {
        if (initScore == 0) {
            return SimpleBigDecimalScore.of(score);
        }
        return new SimpleBigDecimalScore(initScore, score);
    }

    public static @NonNull SimpleBigDecimalScore of(@NonNull BigDecimal score) {
        if (score.signum() == 0) {
            return ZERO;
        }
        if (score.equals(BigDecimal.ONE)) {
            return ONE;
        }
        return new SimpleBigDecimalScore(0, score);
    }

    private SimpleBigDecimalScore() {
        this(Integer.MIN_VALUE, BigDecimal.ZERO);
    }

    private SimpleBigDecimalScore(int initScore, @NonNull BigDecimal score) {
        this.initScore = initScore;
        this.score = score;
    }

    @Override
    public int initScore() {
        return this.initScore;
    }

    public @NonNull BigDecimal score() {
        return this.score;
    }

    @Deprecated(forRemoval=true)
    public @NonNull BigDecimal getScore() {
        return this.score;
    }

    @Override
    public @NonNull SimpleBigDecimalScore withInitScore(int newInitScore) {
        return SimpleBigDecimalScore.ofUninitialized(newInitScore, this.score);
    }

    @Override
    public @NonNull SimpleBigDecimalScore add(@NonNull SimpleBigDecimalScore addend) {
        return SimpleBigDecimalScore.ofUninitialized(this.initScore + addend.initScore(), this.score.add(addend.score()));
    }

    @Override
    public @NonNull SimpleBigDecimalScore subtract(@NonNull SimpleBigDecimalScore subtrahend) {
        return SimpleBigDecimalScore.ofUninitialized(this.initScore - subtrahend.initScore(), this.score.subtract(subtrahend.score()));
    }

    @Override
    public @NonNull SimpleBigDecimalScore multiply(double multiplicand) {
        BigDecimal multiplicandBigDecimal = BigDecimal.valueOf(multiplicand);
        return SimpleBigDecimalScore.ofUninitialized((int)Math.floor((double)this.initScore * multiplicand), this.score.multiply(multiplicandBigDecimal).setScale(this.score.scale(), RoundingMode.FLOOR));
    }

    @Override
    public @NonNull SimpleBigDecimalScore divide(double divisor) {
        BigDecimal divisorBigDecimal = BigDecimal.valueOf(divisor);
        return SimpleBigDecimalScore.ofUninitialized((int)Math.floor((double)this.initScore / divisor), this.score.divide(divisorBigDecimal, this.score.scale(), RoundingMode.FLOOR));
    }

    @Override
    public @NonNull SimpleBigDecimalScore power(double exponent) {
        BigDecimal exponentBigDecimal = BigDecimal.valueOf(exponent);
        return SimpleBigDecimalScore.ofUninitialized((int)Math.floor(Math.pow(this.initScore, exponent)), this.score.pow(exponentBigDecimal.intValue()).setScale(this.score.scale(), RoundingMode.FLOOR));
    }

    @Override
    public @NonNull SimpleBigDecimalScore abs() {
        return SimpleBigDecimalScore.ofUninitialized(Math.abs(this.initScore), this.score.abs());
    }

    @Override
    public @NonNull SimpleBigDecimalScore zero() {
        return ZERO;
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0;
    }

    @Override
    public @NonNull Number @NonNull [] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleBigDecimalScore) {
            SimpleBigDecimalScore other = (SimpleBigDecimalScore)o;
            return this.initScore == other.initScore() && this.score.stripTrailingZeros().equals(other.score().stripTrailingZeros());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.score.stripTrailingZeros());
    }

    @Override
    public int compareTo(@NonNull SimpleBigDecimalScore other) {
        if (this.initScore != other.initScore()) {
            return Integer.compare(this.initScore, other.initScore());
        }
        return this.score.compareTo(other.score());
    }

    @Override
    public @NonNull String toShortString() {
        return ScoreUtil.buildShortString(this, n -> ((BigDecimal)n).compareTo(BigDecimal.ZERO) != 0, "");
    }

    public String toString() {
        return ScoreUtil.getInitPrefix(this.initScore) + this.score;
    }
}

