/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.simplelong;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class SimpleLongScore
implements Score<SimpleLongScore> {
    public static final SimpleLongScore ZERO = new SimpleLongScore(0, 0L);
    public static final SimpleLongScore ONE = new SimpleLongScore(0, 1L);
    public static final SimpleLongScore MINUS_ONE = new SimpleLongScore(0, -1L);
    private final int initScore;
    private final long score;

    public static @NonNull SimpleLongScore parseScore(@NonNull String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(SimpleLongScore.class, scoreString, "");
        int initScore = ScoreUtil.parseInitScore(SimpleLongScore.class, scoreString, scoreTokens[0]);
        long score = ScoreUtil.parseLevelAsLong(SimpleLongScore.class, scoreString, scoreTokens[1]);
        return SimpleLongScore.ofUninitialized(initScore, score);
    }

    public static @NonNull SimpleLongScore ofUninitialized(int initScore, long score) {
        if (initScore == 0) {
            return SimpleLongScore.of(score);
        }
        return new SimpleLongScore(initScore, score);
    }

    public static @NonNull SimpleLongScore of(long score) {
        if (score == -1L) {
            return MINUS_ONE;
        }
        if (score == 0L) {
            return ZERO;
        }
        if (score == 1L) {
            return ONE;
        }
        return new SimpleLongScore(0, score);
    }

    private SimpleLongScore() {
        this(Integer.MIN_VALUE, Long.MIN_VALUE);
    }

    private SimpleLongScore(int initScore, long score) {
        this.initScore = initScore;
        this.score = score;
    }

    @Override
    public int initScore() {
        return this.initScore;
    }

    public long score() {
        return this.score;
    }

    @Deprecated(forRemoval=true)
    public long getScore() {
        return this.score;
    }

    @Override
    public @NonNull SimpleLongScore withInitScore(int newInitScore) {
        return SimpleLongScore.ofUninitialized(newInitScore, this.score);
    }

    @Override
    public @NonNull SimpleLongScore add(@NonNull SimpleLongScore addend) {
        return SimpleLongScore.ofUninitialized(this.initScore + addend.initScore(), this.score + addend.score());
    }

    @Override
    public @NonNull SimpleLongScore subtract(@NonNull SimpleLongScore subtrahend) {
        return SimpleLongScore.ofUninitialized(this.initScore - subtrahend.initScore(), this.score - subtrahend.score());
    }

    @Override
    public @NonNull SimpleLongScore multiply(double multiplicand) {
        return SimpleLongScore.ofUninitialized((int)Math.floor((double)this.initScore * multiplicand), (long)Math.floor((double)this.score * multiplicand));
    }

    @Override
    public @NonNull SimpleLongScore divide(double divisor) {
        return SimpleLongScore.ofUninitialized((int)Math.floor((double)this.initScore / divisor), (long)Math.floor((double)this.score / divisor));
    }

    @Override
    public @NonNull SimpleLongScore power(double exponent) {
        return SimpleLongScore.ofUninitialized((int)Math.floor(Math.pow(this.initScore, exponent)), (long)Math.floor(Math.pow(this.score, exponent)));
    }

    @Override
    public @NonNull SimpleLongScore abs() {
        return SimpleLongScore.ofUninitialized(Math.abs(this.initScore), Math.abs(this.score));
    }

    @Override
    public @NonNull SimpleLongScore zero() {
        return ZERO;
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0;
    }

    @Override
    public Number @NonNull [] toLevelNumbers() {
        return new Number[]{this.score};
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleLongScore) {
            SimpleLongScore other = (SimpleLongScore)o;
            return this.initScore == other.initScore() && this.score == other.score();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.score);
    }

    @Override
    public int compareTo(@NonNull SimpleLongScore other) {
        if (this.initScore != other.initScore()) {
            return Integer.compare(this.initScore, other.initScore());
        }
        return Long.compare(this.score, other.score());
    }

    @Override
    public @NonNull String toShortString() {
        return ScoreUtil.buildShortString(this, n -> n.longValue() != 0L, "");
    }

    public String toString() {
        return ScoreUtil.getInitPrefix(this.initScore) + this.score;
    }
}

