/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.list;

import ai.timefold.solver.core.config.heuristic.selector.SelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"entitySelectorConfig", "valueSelectorConfig", "nearbySelectionConfig"})
public class DestinationSelectorConfig
extends SelectorConfig<DestinationSelectorConfig> {
    @XmlElement(name="entitySelector")
    private EntitySelectorConfig entitySelectorConfig;
    @XmlElement(name="valueSelector")
    private ValueSelectorConfig valueSelectorConfig;
    @XmlElement(name="nearbySelection")
    private NearbySelectionConfig nearbySelectionConfig;

    public DestinationSelectorConfig() {
    }

    public DestinationSelectorConfig(@Nullable DestinationSelectorConfig inheritedConfig) {
        if (inheritedConfig != null) {
            this.inherit(inheritedConfig);
        }
    }

    public @Nullable EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(@Nullable EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public @Nullable ValueSelectorConfig getValueSelectorConfig() {
        return this.valueSelectorConfig;
    }

    public void setValueSelectorConfig(@Nullable ValueSelectorConfig valueSelectorConfig) {
        this.valueSelectorConfig = valueSelectorConfig;
    }

    public @Nullable NearbySelectionConfig getNearbySelectionConfig() {
        return this.nearbySelectionConfig;
    }

    public void setNearbySelectionConfig(@Nullable NearbySelectionConfig nearbySelectionConfig) {
        this.nearbySelectionConfig = nearbySelectionConfig;
    }

    public @NonNull DestinationSelectorConfig withEntitySelectorConfig(@NonNull EntitySelectorConfig entitySelectorConfig) {
        this.setEntitySelectorConfig(entitySelectorConfig);
        return this;
    }

    public @NonNull DestinationSelectorConfig withValueSelectorConfig(@NonNull ValueSelectorConfig valueSelectorConfig) {
        this.setValueSelectorConfig(valueSelectorConfig);
        return this;
    }

    public @NonNull DestinationSelectorConfig withNearbySelectionConfig(@NonNull NearbySelectionConfig nearbySelectionConfig) {
        this.setNearbySelectionConfig(nearbySelectionConfig);
        return this;
    }

    @Override
    public @NonNull DestinationSelectorConfig inherit(@NonNull DestinationSelectorConfig inheritedConfig) {
        this.entitySelectorConfig = ConfigUtils.inheritConfig(this.entitySelectorConfig, inheritedConfig.getEntitySelectorConfig());
        this.valueSelectorConfig = ConfigUtils.inheritConfig(this.valueSelectorConfig, inheritedConfig.getValueSelectorConfig());
        this.nearbySelectionConfig = ConfigUtils.inheritConfig(this.nearbySelectionConfig, inheritedConfig.getNearbySelectionConfig());
        return this;
    }

    @Override
    public @NonNull DestinationSelectorConfig copyConfig() {
        return new DestinationSelectorConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
        if (this.entitySelectorConfig != null) {
            this.entitySelectorConfig.visitReferencedClasses(classVisitor);
        }
        if (this.valueSelectorConfig != null) {
            this.valueSelectorConfig.visitReferencedClasses(classVisitor);
        }
        if (this.nearbySelectionConfig != null) {
            this.nearbySelectionConfig.visitReferencedClasses(classVisitor);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + ", " + this.valueSelectorConfig + ")";
    }

    @Override
    public boolean hasNearbySelectionConfig() {
        return this.nearbySelectionConfig != null || this.entitySelectorConfig != null && this.entitySelectorConfig.hasNearbySelectionConfig() || this.valueSelectorConfig != null && this.valueSelectorConfig.hasNearbySelectionConfig();
    }
}

