/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.move.composite;

import ai.timefold.solver.core.config.heuristic.selector.SelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.NearbyAutoConfigurationEnabled;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.factory.MoveIteratorFactoryConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.factory.MoveListFactoryConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.PillarChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.PillarSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.RuinRecreateMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.chained.SubChainChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.chained.SubChainSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.chained.TailChainSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListRuinRecreateMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.SubListChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.SubListSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.kopt.KOptListMoveSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"moveSelectorConfigList", "selectorProbabilityWeightFactoryClass"})
public class UnionMoveSelectorConfig
extends MoveSelectorConfig<UnionMoveSelectorConfig>
implements NearbyAutoConfigurationEnabled<UnionMoveSelectorConfig> {
    public static final String XML_ELEMENT_NAME = "unionMoveSelector";
    @XmlElements(value={@XmlElement(name="cartesianProductMoveSelector", type=CartesianProductMoveSelectorConfig.class), @XmlElement(name="changeMoveSelector", type=ChangeMoveSelectorConfig.class), @XmlElement(name="kOptListMoveSelector", type=KOptListMoveSelectorConfig.class), @XmlElement(name="listChangeMoveSelector", type=ListChangeMoveSelectorConfig.class), @XmlElement(name="listSwapMoveSelector", type=ListSwapMoveSelectorConfig.class), @XmlElement(name="moveIteratorFactory", type=MoveIteratorFactoryConfig.class), @XmlElement(name="moveListFactory", type=MoveListFactoryConfig.class), @XmlElement(name="pillarChangeMoveSelector", type=PillarChangeMoveSelectorConfig.class), @XmlElement(name="pillarSwapMoveSelector", type=PillarSwapMoveSelectorConfig.class), @XmlElement(name="ruinRecreateMoveSelector", type=RuinRecreateMoveSelectorConfig.class), @XmlElement(name="listRuinRecreateMoveSelector", type=ListRuinRecreateMoveSelectorConfig.class), @XmlElement(name="subChainChangeMoveSelector", type=SubChainChangeMoveSelectorConfig.class), @XmlElement(name="subChainSwapMoveSelector", type=SubChainSwapMoveSelectorConfig.class), @XmlElement(name="subListChangeMoveSelector", type=SubListChangeMoveSelectorConfig.class), @XmlElement(name="subListSwapMoveSelector", type=SubListSwapMoveSelectorConfig.class), @XmlElement(name="swapMoveSelector", type=SwapMoveSelectorConfig.class), @XmlElement(name="tailChainSwapMoveSelector", type=TailChainSwapMoveSelectorConfig.class), @XmlElement(name="unionMoveSelector", type=UnionMoveSelectorConfig.class)})
    private List<MoveSelectorConfig> moveSelectorConfigList = null;
    private Class<? extends SelectionProbabilityWeightFactory> selectorProbabilityWeightFactoryClass = null;

    public UnionMoveSelectorConfig() {
    }

    public UnionMoveSelectorConfig(@NonNull List<@NonNull MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
    }

    @Deprecated
    public List<MoveSelectorConfig> getMoveSelectorConfigList() {
        return this.getMoveSelectorList();
    }

    @Deprecated
    public void setMoveSelectorConfigList(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.setMoveSelectorList(moveSelectorConfigList);
    }

    public @Nullable List<@NonNull MoveSelectorConfig> getMoveSelectorList() {
        return this.moveSelectorConfigList;
    }

    public void setMoveSelectorList(@Nullable List<@NonNull MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
    }

    public @Nullable Class<? extends SelectionProbabilityWeightFactory> getSelectorProbabilityWeightFactoryClass() {
        return this.selectorProbabilityWeightFactoryClass;
    }

    public void setSelectorProbabilityWeightFactoryClass(@Nullable Class<? extends SelectionProbabilityWeightFactory> selectorProbabilityWeightFactoryClass) {
        this.selectorProbabilityWeightFactoryClass = selectorProbabilityWeightFactoryClass;
    }

    public @NonNull UnionMoveSelectorConfig withMoveSelectorList(@NonNull List<@NonNull MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
        return this;
    }

    public @NonNull UnionMoveSelectorConfig withMoveSelectors(MoveSelectorConfig ... moveSelectorConfigs) {
        this.moveSelectorConfigList = Arrays.asList(moveSelectorConfigs);
        return this;
    }

    public @NonNull UnionMoveSelectorConfig withSelectorProbabilityWeightFactoryClass(@NonNull Class<? extends SelectionProbabilityWeightFactory> selectorProbabilityWeightFactoryClass) {
        this.selectorProbabilityWeightFactoryClass = selectorProbabilityWeightFactoryClass;
        return this;
    }

    @Override
    public void extractLeafMoveSelectorConfigsIntoList(@NonNull List<@NonNull MoveSelectorConfig> leafMoveSelectorConfigList) {
        for (MoveSelectorConfig moveSelectorConfig : this.moveSelectorConfigList) {
            moveSelectorConfig.extractLeafMoveSelectorConfigsIntoList(leafMoveSelectorConfigList);
        }
    }

    @Override
    public @NonNull UnionMoveSelectorConfig inherit(@NonNull UnionMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.moveSelectorConfigList = ConfigUtils.inheritMergeableListConfig(this.moveSelectorConfigList, inheritedConfig.getMoveSelectorList());
        this.selectorProbabilityWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.selectorProbabilityWeightFactoryClass, inheritedConfig.getSelectorProbabilityWeightFactoryClass());
        return this;
    }

    @Override
    public @NonNull UnionMoveSelectorConfig copyConfig() {
        return new UnionMoveSelectorConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
        this.visitCommonReferencedClasses(classVisitor);
        if (this.moveSelectorConfigList != null) {
            this.moveSelectorConfigList.forEach(ms -> ms.visitReferencedClasses(classVisitor));
        }
        classVisitor.accept(this.selectorProbabilityWeightFactoryClass);
    }

    @Override
    public @NonNull UnionMoveSelectorConfig enableNearbySelection(@NonNull Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter, @NonNull Random random) {
        UnionMoveSelectorConfig nearbyConfig = this.copyConfig();
        LinkedList<MoveSelectorConfig> updatedMoveSelectorList = new LinkedList<MoveSelectorConfig>();
        for (MoveSelectorConfig selectorConfig : this.moveSelectorConfigList) {
            if (selectorConfig instanceof NearbyAutoConfigurationEnabled) {
                NearbyAutoConfigurationEnabled nearbySelectorConfig = (NearbyAutoConfigurationEnabled)((Object)selectorConfig);
                if (UnionMoveSelectorConfig.class.isAssignableFrom(nearbySelectorConfig.getClass())) {
                    updatedMoveSelectorList.add((MoveSelectorConfig)nearbySelectorConfig.enableNearbySelection(distanceMeter, random));
                    continue;
                }
                updatedMoveSelectorList.add((MoveSelectorConfig)selectorConfig.copyConfig());
                updatedMoveSelectorList.add((MoveSelectorConfig)nearbySelectorConfig.enableNearbySelection(distanceMeter, random));
                continue;
            }
            updatedMoveSelectorList.add((MoveSelectorConfig)selectorConfig.copyConfig());
        }
        nearbyConfig.withMoveSelectorList(updatedMoveSelectorList);
        return nearbyConfig;
    }

    @Override
    public boolean hasNearbySelectionConfig() {
        return this.moveSelectorConfigList != null && this.moveSelectorConfigList.stream().anyMatch(SelectorConfig::hasNearbySelectionConfig);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.moveSelectorConfigList + ")";
    }
}

