/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.move.generic;

import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.NearbyAutoConfigurationEnabled;
import ai.timefold.solver.core.config.heuristic.selector.move.NearbyUtil;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"entitySelectorConfig", "secondaryEntitySelectorConfig", "variableNameIncludeList"})
public class SwapMoveSelectorConfig
extends MoveSelectorConfig<SwapMoveSelectorConfig>
implements NearbyAutoConfigurationEnabled<SwapMoveSelectorConfig> {
    public static final String XML_ELEMENT_NAME = "swapMoveSelector";
    @XmlElement(name="entitySelector")
    private EntitySelectorConfig entitySelectorConfig = null;
    @XmlElement(name="secondaryEntitySelector")
    private EntitySelectorConfig secondaryEntitySelectorConfig = null;
    @XmlElementWrapper(name="variableNameIncludes")
    @XmlElement(name="variableNameInclude")
    private List<String> variableNameIncludeList = null;

    public @Nullable EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(@Nullable EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public @Nullable EntitySelectorConfig getSecondaryEntitySelectorConfig() {
        return this.secondaryEntitySelectorConfig;
    }

    public void setSecondaryEntitySelectorConfig(@Nullable EntitySelectorConfig secondaryEntitySelectorConfig) {
        this.secondaryEntitySelectorConfig = secondaryEntitySelectorConfig;
    }

    public @Nullable List<@NonNull String> getVariableNameIncludeList() {
        return this.variableNameIncludeList;
    }

    public void setVariableNameIncludeList(@Nullable List<@NonNull String> variableNameIncludeList) {
        this.variableNameIncludeList = variableNameIncludeList;
    }

    public @NonNull SwapMoveSelectorConfig withEntitySelectorConfig(@NonNull EntitySelectorConfig entitySelectorConfig) {
        this.setEntitySelectorConfig(entitySelectorConfig);
        return this;
    }

    public @NonNull SwapMoveSelectorConfig withSecondaryEntitySelectorConfig(@NonNull EntitySelectorConfig secondaryEntitySelectorConfig) {
        this.setSecondaryEntitySelectorConfig(secondaryEntitySelectorConfig);
        return this;
    }

    public @NonNull SwapMoveSelectorConfig withVariableNameIncludes(String ... variableNameIncludes) {
        this.setVariableNameIncludeList(Arrays.asList(variableNameIncludes));
        return this;
    }

    @Override
    public @NonNull SwapMoveSelectorConfig inherit(@NonNull SwapMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.entitySelectorConfig = ConfigUtils.inheritConfig(this.entitySelectorConfig, inheritedConfig.getEntitySelectorConfig());
        this.secondaryEntitySelectorConfig = ConfigUtils.inheritConfig(this.secondaryEntitySelectorConfig, inheritedConfig.getSecondaryEntitySelectorConfig());
        this.variableNameIncludeList = ConfigUtils.inheritMergeableListProperty(this.variableNameIncludeList, inheritedConfig.getVariableNameIncludeList());
        return this;
    }

    @Override
    public @NonNull SwapMoveSelectorConfig copyConfig() {
        return new SwapMoveSelectorConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
        this.visitCommonReferencedClasses(classVisitor);
        if (this.entitySelectorConfig != null) {
            this.entitySelectorConfig.visitReferencedClasses(classVisitor);
        }
        if (this.secondaryEntitySelectorConfig != null) {
            this.secondaryEntitySelectorConfig.visitReferencedClasses(classVisitor);
        }
    }

    @Override
    public @NonNull SwapMoveSelectorConfig enableNearbySelection(@NonNull Class<? extends NearbyDistanceMeter<?, ?>> distanceMeter, @NonNull Random random) {
        return NearbyUtil.enable(this, distanceMeter, random);
    }

    @Override
    public boolean hasNearbySelectionConfig() {
        return this.entitySelectorConfig != null && this.entitySelectorConfig.hasNearbySelectionConfig() || this.secondaryEntitySelectorConfig != null && this.secondaryEntitySelectorConfig.hasNearbySelectionConfig();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + (String)(this.secondaryEntitySelectorConfig == null ? "" : ", " + this.secondaryEntitySelectorConfig) + ")";
    }
}

