/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.value;

import ai.timefold.solver.core.api.domain.variable.PlanningVariable;
import ai.timefold.solver.core.config.heuristic.selector.SelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSorterManner;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Comparator;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"id", "mimicSelectorRef", "downcastEntityClass", "variableName", "cacheType", "selectionOrder", "nearbySelectionConfig", "filterClass", "sorterManner", "sorterComparatorClass", "sorterWeightFactoryClass", "sorterOrder", "sorterClass", "probabilityWeightFactoryClass", "selectedCountLimit"})
public class ValueSelectorConfig
extends SelectorConfig<ValueSelectorConfig> {
    @XmlAttribute
    protected String id = null;
    @XmlAttribute
    protected String mimicSelectorRef = null;
    protected Class<?> downcastEntityClass = null;
    @XmlAttribute
    protected String variableName = null;
    protected SelectionCacheType cacheType = null;
    protected SelectionOrder selectionOrder = null;
    @XmlElement(name="nearbySelection")
    protected NearbySelectionConfig nearbySelectionConfig = null;
    protected Class<? extends SelectionFilter> filterClass = null;
    protected ValueSorterManner sorterManner = null;
    protected Class<? extends Comparator> sorterComparatorClass = null;
    protected Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass = null;
    protected SelectionSorterOrder sorterOrder = null;
    protected Class<? extends SelectionSorter> sorterClass = null;
    protected Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass = null;
    protected Long selectedCountLimit = null;

    public ValueSelectorConfig() {
    }

    public ValueSelectorConfig(@NonNull String variableName) {
        this.variableName = variableName;
    }

    public ValueSelectorConfig(@Nullable ValueSelectorConfig inheritedConfig) {
        if (inheritedConfig != null) {
            this.inherit(inheritedConfig);
        }
    }

    public @Nullable String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public @Nullable String getMimicSelectorRef() {
        return this.mimicSelectorRef;
    }

    public void setMimicSelectorRef(@Nullable String mimicSelectorRef) {
        this.mimicSelectorRef = mimicSelectorRef;
    }

    public @Nullable Class<?> getDowncastEntityClass() {
        return this.downcastEntityClass;
    }

    public void setDowncastEntityClass(@Nullable Class<?> downcastEntityClass) {
        this.downcastEntityClass = downcastEntityClass;
    }

    public @Nullable String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(@Nullable String variableName) {
        this.variableName = variableName;
    }

    public @Nullable SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheType(@Nullable SelectionCacheType cacheType) {
        this.cacheType = cacheType;
    }

    public @Nullable SelectionOrder getSelectionOrder() {
        return this.selectionOrder;
    }

    public void setSelectionOrder(@Nullable SelectionOrder selectionOrder) {
        this.selectionOrder = selectionOrder;
    }

    public @Nullable NearbySelectionConfig getNearbySelectionConfig() {
        return this.nearbySelectionConfig;
    }

    public void setNearbySelectionConfig(@Nullable NearbySelectionConfig nearbySelectionConfig) {
        this.nearbySelectionConfig = nearbySelectionConfig;
    }

    public @Nullable Class<? extends SelectionFilter> getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(@Nullable Class<? extends SelectionFilter> filterClass) {
        this.filterClass = filterClass;
    }

    public @Nullable ValueSorterManner getSorterManner() {
        return this.sorterManner;
    }

    public void setSorterManner(@Nullable ValueSorterManner sorterManner) {
        this.sorterManner = sorterManner;
    }

    public @Nullable Class<? extends Comparator> getSorterComparatorClass() {
        return this.sorterComparatorClass;
    }

    public void setSorterComparatorClass(@Nullable Class<? extends Comparator> sorterComparatorClass) {
        this.sorterComparatorClass = sorterComparatorClass;
    }

    public @Nullable Class<? extends SelectionSorterWeightFactory> getSorterWeightFactoryClass() {
        return this.sorterWeightFactoryClass;
    }

    public void setSorterWeightFactoryClass(@Nullable Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass) {
        this.sorterWeightFactoryClass = sorterWeightFactoryClass;
    }

    public @Nullable SelectionSorterOrder getSorterOrder() {
        return this.sorterOrder;
    }

    public void setSorterOrder(@Nullable SelectionSorterOrder sorterOrder) {
        this.sorterOrder = sorterOrder;
    }

    public @Nullable Class<? extends SelectionSorter> getSorterClass() {
        return this.sorterClass;
    }

    public void setSorterClass(@Nullable Class<? extends SelectionSorter> sorterClass) {
        this.sorterClass = sorterClass;
    }

    public @Nullable Class<? extends SelectionProbabilityWeightFactory> getProbabilityWeightFactoryClass() {
        return this.probabilityWeightFactoryClass;
    }

    public void setProbabilityWeightFactoryClass(@Nullable Class<? extends SelectionProbabilityWeightFactory> probabilityWeightFactoryClass) {
        this.probabilityWeightFactoryClass = probabilityWeightFactoryClass;
    }

    public @Nullable Long getSelectedCountLimit() {
        return this.selectedCountLimit;
    }

    public void setSelectedCountLimit(@Nullable Long selectedCountLimit) {
        this.selectedCountLimit = selectedCountLimit;
    }

    public @NonNull ValueSelectorConfig withId(@NonNull String id) {
        this.setId(id);
        return this;
    }

    public @NonNull ValueSelectorConfig withMimicSelectorRef(@NonNull String mimicSelectorRef) {
        this.setMimicSelectorRef(mimicSelectorRef);
        return this;
    }

    public @NonNull ValueSelectorConfig withDowncastEntityClass(@NonNull Class<?> entityClass) {
        this.setDowncastEntityClass(entityClass);
        return this;
    }

    public @NonNull ValueSelectorConfig withVariableName(@NonNull String variableName) {
        this.setVariableName(variableName);
        return this;
    }

    public @NonNull ValueSelectorConfig withCacheType(@NonNull SelectionCacheType cacheType) {
        this.setCacheType(cacheType);
        return this;
    }

    public @NonNull ValueSelectorConfig withSelectionOrder(@NonNull SelectionOrder selectionOrder) {
        this.setSelectionOrder(selectionOrder);
        return this;
    }

    public @NonNull ValueSelectorConfig withNearbySelectionConfig(@NonNull NearbySelectionConfig nearbySelectionConfig) {
        this.setNearbySelectionConfig(nearbySelectionConfig);
        return this;
    }

    public @NonNull ValueSelectorConfig withFilterClass(@NonNull Class<? extends SelectionFilter> filterClass) {
        this.setFilterClass(filterClass);
        return this;
    }

    public @NonNull ValueSelectorConfig withSorterManner(@NonNull ValueSorterManner sorterManner) {
        this.setSorterManner(sorterManner);
        return this;
    }

    public @NonNull ValueSelectorConfig withSorterComparatorClass(@NonNull Class<? extends Comparator> comparatorClass) {
        this.setSorterComparatorClass(comparatorClass);
        return this;
    }

    public @NonNull ValueSelectorConfig withSorterWeightFactoryClass(@NonNull Class<? extends SelectionSorterWeightFactory> weightFactoryClass) {
        this.setSorterWeightFactoryClass(weightFactoryClass);
        return this;
    }

    public @NonNull ValueSelectorConfig withSorterOrder(@NonNull SelectionSorterOrder sorterOrder) {
        this.setSorterOrder(sorterOrder);
        return this;
    }

    public @NonNull ValueSelectorConfig withSorterClass(@NonNull Class<? extends SelectionSorter> sorterClass) {
        this.setSorterClass(sorterClass);
        return this;
    }

    public @NonNull ValueSelectorConfig withProbabilityWeightFactoryClass(@NonNull Class<? extends SelectionProbabilityWeightFactory> factoryClass) {
        this.setProbabilityWeightFactoryClass(factoryClass);
        return this;
    }

    public @NonNull ValueSelectorConfig withSelectedCountLimit(long selectedCountLimit) {
        this.setSelectedCountLimit(selectedCountLimit);
        return this;
    }

    @Override
    public @NonNull ValueSelectorConfig inherit(@NonNull ValueSelectorConfig inheritedConfig) {
        this.id = ConfigUtils.inheritOverwritableProperty(this.id, inheritedConfig.getId());
        this.mimicSelectorRef = ConfigUtils.inheritOverwritableProperty(this.mimicSelectorRef, inheritedConfig.getMimicSelectorRef());
        this.downcastEntityClass = ConfigUtils.inheritOverwritableProperty(this.downcastEntityClass, inheritedConfig.getDowncastEntityClass());
        this.variableName = ConfigUtils.inheritOverwritableProperty(this.variableName, inheritedConfig.getVariableName());
        this.nearbySelectionConfig = ConfigUtils.inheritConfig(this.nearbySelectionConfig, inheritedConfig.getNearbySelectionConfig());
        this.filterClass = ConfigUtils.inheritOverwritableProperty(this.filterClass, inheritedConfig.getFilterClass());
        this.cacheType = ConfigUtils.inheritOverwritableProperty(this.cacheType, inheritedConfig.getCacheType());
        this.selectionOrder = ConfigUtils.inheritOverwritableProperty(this.selectionOrder, inheritedConfig.getSelectionOrder());
        this.sorterManner = ConfigUtils.inheritOverwritableProperty(this.sorterManner, inheritedConfig.getSorterManner());
        this.sorterComparatorClass = ConfigUtils.inheritOverwritableProperty(this.sorterComparatorClass, inheritedConfig.getSorterComparatorClass());
        this.sorterWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.sorterWeightFactoryClass, inheritedConfig.getSorterWeightFactoryClass());
        this.sorterOrder = ConfigUtils.inheritOverwritableProperty(this.sorterOrder, inheritedConfig.getSorterOrder());
        this.sorterClass = ConfigUtils.inheritOverwritableProperty(this.sorterClass, inheritedConfig.getSorterClass());
        this.probabilityWeightFactoryClass = ConfigUtils.inheritOverwritableProperty(this.probabilityWeightFactoryClass, inheritedConfig.getProbabilityWeightFactoryClass());
        this.selectedCountLimit = ConfigUtils.inheritOverwritableProperty(this.selectedCountLimit, inheritedConfig.getSelectedCountLimit());
        return this;
    }

    @Override
    public @NonNull ValueSelectorConfig copyConfig() {
        return new ValueSelectorConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
        classVisitor.accept(this.downcastEntityClass);
        if (this.nearbySelectionConfig != null) {
            this.nearbySelectionConfig.visitReferencedClasses(classVisitor);
        }
        classVisitor.accept(this.filterClass);
        classVisitor.accept(this.sorterComparatorClass);
        classVisitor.accept(this.sorterWeightFactoryClass);
        classVisitor.accept(this.sorterClass);
        classVisitor.accept(this.probabilityWeightFactoryClass);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.variableName + ")";
    }

    public static <Solution_> boolean hasSorter(@NonNull ValueSorterManner valueSorterManner, @NonNull GenuineVariableDescriptor<Solution_> variableDescriptor) {
        switch (valueSorterManner) {
            case NONE: {
                return false;
            }
            case INCREASING_STRENGTH: 
            case DECREASING_STRENGTH: {
                return true;
            }
            case INCREASING_STRENGTH_IF_AVAILABLE: {
                return variableDescriptor.getIncreasingStrengthSorter() != null;
            }
            case DECREASING_STRENGTH_IF_AVAILABLE: {
                return variableDescriptor.getDecreasingStrengthSorter() != null;
            }
        }
        throw new IllegalStateException("The sorterManner (" + valueSorterManner + ") is not implemented.");
    }

    public static <Solution_> @NonNull SelectionSorter<Solution_, Object> determineSorter(@NonNull ValueSorterManner valueSorterManner, @NonNull GenuineVariableDescriptor<Solution_> variableDescriptor) {
        SelectionSorter<Solution_, Object> sorter = switch (valueSorterManner) {
            case ValueSorterManner.NONE -> throw new IllegalStateException("Impossible state: hasSorter() should have returned null.");
            case ValueSorterManner.INCREASING_STRENGTH, ValueSorterManner.INCREASING_STRENGTH_IF_AVAILABLE -> variableDescriptor.getIncreasingStrengthSorter();
            case ValueSorterManner.DECREASING_STRENGTH, ValueSorterManner.DECREASING_STRENGTH_IF_AVAILABLE -> variableDescriptor.getDecreasingStrengthSorter();
            default -> throw new IllegalStateException("The sorterManner (" + valueSorterManner + ") is not implemented.");
        };
        if (sorter == null) {
            throw new IllegalArgumentException("The sorterManner (" + valueSorterManner + ") on entity class (" + variableDescriptor.getEntityDescriptor().getEntityClass() + ")'s variable (" + variableDescriptor.getVariableName() + ") fails because that variable getter's @" + PlanningVariable.class.getSimpleName() + " annotation does not declare any strength comparison.");
        }
        return sorter;
    }

    @Override
    public boolean hasNearbySelectionConfig() {
        return this.nearbySelectionConfig != null;
    }
}

