/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.phase.custom;

import ai.timefold.solver.core.config.phase.PhaseConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.io.jaxb.adapter.JaxbCustomPropertiesAdapter;
import ai.timefold.solver.core.impl.phase.custom.CustomPhaseCommand;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@XmlType(propOrder={"customPhaseCommandClassList", "customProperties"})
public class CustomPhaseConfig
extends PhaseConfig<CustomPhaseConfig> {
    public static final String XML_ELEMENT_NAME = "customPhase";
    @XmlElement(name="customPhaseCommandClass")
    protected List<Class<? extends CustomPhaseCommand>> customPhaseCommandClassList = null;
    @XmlJavaTypeAdapter(value=JaxbCustomPropertiesAdapter.class)
    protected Map<String, String> customProperties = null;
    @XmlTransient
    protected List<CustomPhaseCommand> customPhaseCommandList = null;

    public @Nullable List<Class<? extends CustomPhaseCommand>> getCustomPhaseCommandClassList() {
        return this.customPhaseCommandClassList;
    }

    public void setCustomPhaseCommandClassList(@Nullable List<Class<? extends CustomPhaseCommand>> customPhaseCommandClassList) {
        this.customPhaseCommandClassList = customPhaseCommandClassList;
    }

    public @Nullable Map<@NonNull String, @NonNull String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(@Nullable Map<@NonNull String, @NonNull String> customProperties) {
        this.customProperties = customProperties;
    }

    public @Nullable List<@NonNull CustomPhaseCommand> getCustomPhaseCommandList() {
        return this.customPhaseCommandList;
    }

    public void setCustomPhaseCommandList(@Nullable List<@NonNull CustomPhaseCommand> customPhaseCommandList) {
        this.customPhaseCommandList = customPhaseCommandList;
    }

    public @NonNull CustomPhaseConfig withCustomPhaseCommandClassList(@NonNull List<@NonNull Class<? extends CustomPhaseCommand>> customPhaseCommandClassList) {
        this.customPhaseCommandClassList = customPhaseCommandClassList;
        return this;
    }

    public @NonNull CustomPhaseConfig withCustomProperties(@NonNull Map<@NonNull String, @NonNull String> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public @NonNull CustomPhaseConfig withCustomPhaseCommandList(@NonNull List<@NonNull CustomPhaseCommand> customPhaseCommandList) {
        boolean hasNullCommand = Objects.requireNonNullElse(customPhaseCommandList, Collections.emptyList()).stream().anyMatch(Objects::isNull);
        if (hasNullCommand) {
            throw new IllegalArgumentException("Custom phase commands (" + customPhaseCommandList + ") must not contain a null element.");
        }
        this.customPhaseCommandList = customPhaseCommandList;
        return this;
    }

    public <Solution_> @NonNull CustomPhaseConfig withCustomPhaseCommands(CustomPhaseCommand<Solution_> ... customPhaseCommands) {
        boolean hasNullCommand = Arrays.stream(customPhaseCommands).anyMatch(Objects::isNull);
        if (hasNullCommand) {
            throw new IllegalArgumentException("Custom phase commands (" + Arrays.toString(customPhaseCommands) + ") must not contain a null element.");
        }
        this.customPhaseCommandList = Arrays.asList(customPhaseCommands);
        return this;
    }

    @Override
    public @NonNull CustomPhaseConfig inherit(@NonNull CustomPhaseConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.customPhaseCommandClassList = ConfigUtils.inheritMergeableListProperty(this.customPhaseCommandClassList, inheritedConfig.getCustomPhaseCommandClassList());
        this.customPhaseCommandList = ConfigUtils.inheritMergeableListProperty(this.customPhaseCommandList, inheritedConfig.getCustomPhaseCommandList());
        this.customProperties = ConfigUtils.inheritMergeableMapProperty(this.customProperties, inheritedConfig.getCustomProperties());
        return this;
    }

    @Override
    public @NonNull CustomPhaseConfig copyConfig() {
        return new CustomPhaseConfig().inherit(this);
    }

    @Override
    public void visitReferencedClasses(@NonNull Consumer<Class<?>> classVisitor) {
        if (this.terminationConfig != null) {
            this.terminationConfig.visitReferencedClasses(classVisitor);
        }
        if (this.customPhaseCommandClassList != null) {
            this.customPhaseCommandClassList.forEach(classVisitor);
        }
    }
}

