/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.enterprise;

import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.api.solver.SolverFactory;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.DestinationSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.SubListSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.config.partitionedsearch.PartitionedSearchPhaseConfig;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.constructionheuristic.decider.ConstructionHeuristicDecider;
import ai.timefold.solver.core.impl.constructionheuristic.decider.forager.ConstructionHeuristicForager;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.ElementDestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.RandomSubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.localsearch.decider.LocalSearchDecider;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.Acceptor;
import ai.timefold.solver.core.impl.localsearch.decider.forager.LocalSearchForager;
import ai.timefold.solver.core.impl.partitionedsearch.PartitionedSearchPhase;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import java.util.function.BiFunction;

public interface TimefoldSolverEnterpriseService {
    public static final String SOLVER_NAME = "Timefold Solver";
    public static final String COMMUNITY_NAME = "Community Edition";
    public static final String COMMUNITY_COORDINATES = "ai.timefold.solver:timefold-solver-core";
    public static final String ENTERPRISE_NAME = "Enterprise Edition";
    public static final String ENTERPRISE_COORDINATES = "ai.timefold.solver.enterprise:timefold-solver-enterprise-core";
    public static final String DEVELOPMENT_SNAPSHOT = "Development Snapshot";

    public static String identifySolverVersion() {
        String packaging = COMMUNITY_NAME;
        try {
            TimefoldSolverEnterpriseService.load();
            packaging = ENTERPRISE_NAME;
        }
        catch (Exception exception) {
            // empty catch block
        }
        String version = TimefoldSolverEnterpriseService.getVersionString(SolverFactory.class);
        return packaging + " " + version;
    }

    private static String getVersionString(Class<?> clz) {
        String version = clz.getPackage().getImplementationVersion();
        return version == null ? DEVELOPMENT_SNAPSHOT : "v" + version;
    }

    public static TimefoldSolverEnterpriseService load() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> clz = Class.forName("ai.timefold.solver.enterprise.core.DefaultTimefoldSolverEnterpriseService");
        return (TimefoldSolverEnterpriseService)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static TimefoldSolverEnterpriseService loadOrFail(Feature feature) {
        TimefoldSolverEnterpriseService service;
        try {
            service = TimefoldSolverEnterpriseService.load();
        }
        catch (Exception cause) {
            throw new IllegalStateException("%s requested but %s %s not found on classpath.\nEither add the %s dependency, or %s.\nNote: %s %s is a commercial product. Visit https://timefold.ai to find out more.".formatted(feature.getName(), SOLVER_NAME, ENTERPRISE_NAME, feature.getWorkaround(), ENTERPRISE_COORDINATES, SOLVER_NAME, ENTERPRISE_NAME), cause);
        }
        String communityVersion = TimefoldSolverEnterpriseService.getVersionString(TimefoldSolverEnterpriseService.class);
        String enterpriseVersion = TimefoldSolverEnterpriseService.getVersionString(service.getClass());
        if (Objects.equals(communityVersion, enterpriseVersion)) {
            return service;
        }
        if (enterpriseVersion.equals(DEVELOPMENT_SNAPSHOT)) {
            return service;
        }
        throw new IllegalStateException("Detected mismatch between versions of %s %s (%s) and %s (%s).\nEnsure your project uses the same version of %s and %s dependencies.".formatted(SOLVER_NAME, COMMUNITY_NAME, communityVersion, ENTERPRISE_NAME, enterpriseVersion, COMMUNITY_COORDINATES, ENTERPRISE_COORDINATES));
    }

    public Class<? extends ConstraintProvider> buildLambdaSharedConstraintProvider(Class<? extends ConstraintProvider> var1);

    public <Solution_> ConstructionHeuristicDecider<Solution_> buildConstructionHeuristic(Termination<Solution_> var1, ConstructionHeuristicForager<Solution_> var2, HeuristicConfigPolicy<Solution_> var3);

    public <Solution_> LocalSearchDecider<Solution_> buildLocalSearch(int var1, Termination<Solution_> var2, MoveSelector<Solution_> var3, Acceptor<Solution_> var4, LocalSearchForager<Solution_> var5, EnvironmentMode var6, HeuristicConfigPolicy<Solution_> var7);

    public <Solution_> PartitionedSearchPhase<Solution_> buildPartitionedSearch(int var1, PartitionedSearchPhaseConfig var2, HeuristicConfigPolicy<Solution_> var3, Termination<Solution_> var4, BiFunction<HeuristicConfigPolicy<Solution_>, Termination<Solution_>, Termination<Solution_>> var5);

    public <Solution_> EntitySelector<Solution_> applyNearbySelection(EntitySelectorConfig var1, HeuristicConfigPolicy<Solution_> var2, NearbySelectionConfig var3, SelectionCacheType var4, SelectionOrder var5, EntitySelector<Solution_> var6);

    public <Solution_> ValueSelector<Solution_> applyNearbySelection(ValueSelectorConfig var1, HeuristicConfigPolicy<Solution_> var2, EntityDescriptor<Solution_> var3, SelectionCacheType var4, SelectionOrder var5, ValueSelector<Solution_> var6);

    public <Solution_> SubListSelector<Solution_> applyNearbySelection(SubListSelectorConfig var1, HeuristicConfigPolicy<Solution_> var2, SelectionCacheType var3, SelectionOrder var4, RandomSubListSelector<Solution_> var5);

    public <Solution_> DestinationSelector<Solution_> applyNearbySelection(DestinationSelectorConfig var1, HeuristicConfigPolicy<Solution_> var2, SelectionCacheType var3, SelectionOrder var4, ElementDestinationSelector<Solution_> var5);

    public static enum Feature {
        MULTITHREADED_SOLVING("Multi-threaded solving", "remove moveThreadCount from solver configuration"),
        PARTITIONED_SEARCH("Partitioned search", "remove partitioned search phase from solver configuration"),
        NEARBY_SELECTION("Nearby selection", "remove nearby selection from solver configuration"),
        AUTOMATIC_NODE_SHARING("Automatic node sharing", "remove automatic node sharing from solver configuration");

        private final String name;
        private final String workaround;

        private Feature(String name, String workaround) {
            this.name = name;
            this.workaround = workaround;
        }

        public String getName() {
            return this.name;
        }

        public String getWorkaround() {
            return this.workaround;
        }
    }
}

