/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.common.accessor;

import ai.timefold.solver.core.impl.domain.common.accessor.AbstractMemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

public final class ReflectionFieldMemberAccessor
extends AbstractMemberAccessor {
    private final Field field;

    public ReflectionFieldMemberAccessor(Field field) {
        this.field = field;
        field.setAccessible(true);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Class<?> getType() {
        return this.field.getType();
    }

    @Override
    public Type getGenericType() {
        return this.field.getGenericType();
    }

    @Override
    public Object executeGetter(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("Requested field (%s) on a null bean.".formatted(this.field));
        }
        try {
            return this.field.get(bean);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot get the field (%s) on bean of class (%s).\n%s".formatted(this.field.getName(), bean.getClass(), MemberAccessorFactory.CLASSLOADER_NUDGE_MESSAGE), e);
        }
    }

    @Override
    public boolean supportSetter() {
        return true;
    }

    @Override
    public void executeSetter(Object bean, Object value) {
        if (bean == null) {
            throw new IllegalArgumentException("Requested field (%s) on a null bean.".formatted(this.field));
        }
        try {
            this.field.set(bean, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Cannot set the field (%s) on bean of class (%s).\n%s".formatted(this.field.getName(), bean.getClass(), MemberAccessorFactory.CLASSLOADER_NUDGE_MESSAGE), e);
        }
    }

    @Override
    public String getSpeedNote() {
        return "reflection";
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    @Override
    public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        return this.field.getDeclaredAnnotationsByType(annotationClass);
    }

    public String toString() {
        return "field " + this.field;
    }
}

