/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.valuerange.buildin.collection;

import ai.timefold.solver.core.impl.domain.valuerange.AbstractCountableValueRange;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.jspecify.annotations.NonNull;

public final class ListValueRange<T>
extends AbstractCountableValueRange<T> {
    private final List<T> list;

    public ListValueRange(List<T> list) {
        this.list = list;
    }

    @Override
    public long getSize() {
        return this.list.size();
    }

    @Override
    public T get(long index) {
        if (index > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("The index (" + index + ") must fit in an int.");
        }
        return this.list.get((int)index);
    }

    @Override
    public boolean contains(T value) {
        return this.list.contains(value);
    }

    @Override
    public @NonNull Iterator<T> createOriginalIterator() {
        return this.list.iterator();
    }

    @Override
    public @NonNull Iterator<T> createRandomIterator(@NonNull Random workingRandom) {
        return new CachedListRandomIterator<T>(this.list, workingRandom);
    }

    public String toString() {
        return this.list.isEmpty() ? "[]" : "[" + this.list.get(0) + "-" + this.list.get(this.list.size() - 1) + "]";
    }
}

