/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementLocation;
import ai.timefold.solver.core.preview.api.domain.metamodel.LocationInList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

final class ExternalizedListVariableStateSupply<Solution_>
implements ListVariableStateSupply<Solution_> {
    private final ListVariableDescriptor<Solution_> sourceVariableDescriptor;
    private Map<Object, LocationInList> elementLocationMap;
    private int unassignedCount;

    public ExternalizedListVariableStateSupply(ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(@NonNull ScoreDirector<Solution_> scoreDirector) {
        Solution_ workingSolution = scoreDirector.getWorkingSolution();
        if (this.elementLocationMap == null) {
            this.elementLocationMap = new IdentityHashMap<Object, LocationInList>((int)this.sourceVariableDescriptor.getValueRangeSize(workingSolution, null));
        } else {
            this.elementLocationMap.clear();
        }
        this.unassignedCount = (int)this.sourceVariableDescriptor.getValueRangeSize(workingSolution, null);
        this.sourceVariableDescriptor.getEntityDescriptor().visitAllEntities(workingSolution, this::insert);
    }

    private void insert(Object entity) {
        Object assignedElements = this.sourceVariableDescriptor.getValue(entity);
        int index = 0;
        Iterator iterator = assignedElements.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            LocationInList oldLocation = this.elementLocationMap.put(element, ElementLocation.of(entity, index));
            if (oldLocation != null) {
                throw new IllegalStateException("The supply (%s) is corrupted, because the element (%s) at index (%d) already exists (%s).".formatted(this, element, index, oldLocation));
            }
            ++index;
            --this.unassignedCount;
        }
    }

    @Override
    public void close() {
        this.elementLocationMap = null;
    }

    @Override
    public void beforeEntityAdded(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object o) {
    }

    @Override
    public void afterEntityAdded(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object o) {
        this.insert(o);
    }

    @Override
    public void beforeEntityRemoved(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object o) {
    }

    @Override
    public void afterEntityRemoved(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object o) {
        this.retract(o);
    }

    private void retract(Object entity) {
        Object assignedElements = this.sourceVariableDescriptor.getValue(entity);
        for (int index = 0; index < assignedElements.size(); ++index) {
            Object element = assignedElements.get(index);
            LocationInList oldElementLocation = this.elementLocationMap.remove(element);
            if (oldElementLocation == null) {
                throw new IllegalStateException("The supply (%s) is corrupted, because the element (%s) at index (%d) was already unassigned (%s).".formatted(this, element, index, oldElementLocation));
            }
            int oldIndex = oldElementLocation.index();
            if (oldIndex != index) {
                throw new IllegalStateException("The supply (%s) is corrupted, because the element (%s) at index (%d) had an old index (%d) which is not the current index (%d).".formatted(this, element, index, oldIndex, index));
            }
            ++this.unassignedCount;
        }
    }

    @Override
    public void afterListVariableElementUnassigned(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object element) {
        LocationInList oldLocation = this.elementLocationMap.remove(element);
        if (oldLocation == null) {
            throw new IllegalStateException("The supply (%s) is corrupted, because the element (%s) did not exist before unassigning.".formatted(this, element));
        }
        ++this.unassignedCount;
    }

    @Override
    public void beforeListVariableChanged(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object o, int fromIndex, int toIndex) {
    }

    @Override
    public void afterListVariableChanged(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object o, int fromIndex, int toIndex) {
        this.updateIndexes(o, fromIndex, toIndex);
    }

    private void updateIndexes(Object entity, int startIndex, int toIndex) {
        Object assignedElements = this.sourceVariableDescriptor.getValue(entity);
        for (int index = startIndex; index < assignedElements.size(); ++index) {
            LocationInList newLocation;
            Object element = assignedElements.get(index);
            LocationInList oldLocation = this.elementLocationMap.put(element, newLocation = ElementLocation.of(entity, index));
            if (oldLocation == null) {
                --this.unassignedCount;
                continue;
            }
            if (index < toIndex || !newLocation.equals(oldLocation)) continue;
            return;
        }
    }

    @Override
    public ElementLocation getLocationInList(Object planningValue) {
        return Objects.requireNonNullElse((ElementLocation)this.elementLocationMap.get(Objects.requireNonNull(planningValue)), ElementLocation.unassigned());
    }

    @Override
    public Integer getIndex(Object planningValue) {
        LocationInList elementLocation = this.elementLocationMap.get(Objects.requireNonNull(planningValue));
        if (elementLocation == null) {
            return null;
        }
        return elementLocation.index();
    }

    @Override
    public Object getInverseSingleton(Object planningValue) {
        LocationInList elementLocation = this.elementLocationMap.get(Objects.requireNonNull(planningValue));
        if (elementLocation == null) {
            return null;
        }
        return elementLocation.entity();
    }

    @Override
    public boolean isAssigned(Object element) {
        return this.getLocationInList(element) instanceof LocationInList;
    }

    @Override
    public int getUnassignedCount() {
        return this.unassignedCount;
    }

    @Override
    public ListVariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.sourceVariableDescriptor;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceVariableDescriptor.getVariableName() + ")";
    }
}

