/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.anchor;

import ai.timefold.solver.core.api.domain.variable.VariableListener;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.anchor.AnchorVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.listener.SourcedVariableListener;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;

public class ExternalizedAnchorVariableSupply<Solution_>
implements SourcedVariableListener<Solution_>,
VariableListener<Solution_, Object>,
AnchorVariableSupply {
    protected final VariableDescriptor<Solution_> previousVariableDescriptor;
    protected final SingletonInverseVariableSupply nextVariableSupply;
    protected Map<Object, Object> anchorMap = null;

    public ExternalizedAnchorVariableSupply(VariableDescriptor<Solution_> previousVariableDescriptor, SingletonInverseVariableSupply nextVariableSupply) {
        this.previousVariableDescriptor = previousVariableDescriptor;
        this.nextVariableSupply = nextVariableSupply;
    }

    @Override
    public VariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.previousVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(@NonNull ScoreDirector<Solution_> scoreDirector) {
        this.anchorMap = new IdentityHashMap<Object, Object>();
        this.previousVariableDescriptor.getEntityDescriptor().visitAllEntities(scoreDirector.getWorkingSolution(), this::insert);
    }

    @Override
    public void close() {
        this.anchorMap = null;
    }

    @Override
    public void beforeEntityAdded(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
    }

    @Override
    public void afterEntityAdded(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        this.insert(entity);
    }

    @Override
    public void beforeVariableChanged(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
    }

    @Override
    public void afterVariableChanged(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        this.insert(entity);
    }

    @Override
    public void beforeEntityRemoved(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        boolean removeSucceeded;
        boolean bl = removeSucceeded = this.anchorMap.remove(entity) != null;
        if (!removeSucceeded) {
            throw new IllegalStateException("The supply (" + this + ") is corrupted, because the entity (" + entity + ") for sourceVariable (" + this.previousVariableDescriptor.getVariableName() + ") cannot be retracted: it was never inserted.");
        }
    }

    @Override
    public void afterEntityRemoved(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
    }

    protected void insert(Object entity) {
        Object previousEntity = this.previousVariableDescriptor.getValue(entity);
        Object anchor = previousEntity == null ? null : (this.previousVariableDescriptor.isValuePotentialAnchor(previousEntity) ? previousEntity : this.anchorMap.get(previousEntity));
        Object nextEntity = entity;
        while (nextEntity != null && this.anchorMap.get(nextEntity) != anchor) {
            this.anchorMap.put(nextEntity, anchor);
            nextEntity = this.nextVariableSupply.getInverseSingleton(nextEntity);
        }
    }

    @Override
    public Object getAnchor(Object entity) {
        return this.anchorMap.get(entity);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.previousVariableDescriptor.getVariableName() + ")";
    }
}

