/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.index;

import ai.timefold.solver.core.api.domain.variable.ListVariableListener;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexVariableSupply;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.Iterator;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public class IndexVariableListener<Solution_>
implements ListVariableListener<Solution_, Object, Object>,
IndexVariableSupply {
    protected final IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor;
    protected final ListVariableDescriptor<Solution_> sourceVariableDescriptor;
    private static final int NEVER_QUIT_EARLY = Integer.MAX_VALUE;

    public IndexVariableListener(IndexShadowVariableDescriptor<Solution_> shadowVariableDescriptor, ListVariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.shadowVariableDescriptor = shadowVariableDescriptor;
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public void beforeEntityAdded(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
    }

    @Override
    public void afterEntityAdded(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        this.updateIndexes((InnerScoreDirector)scoreDirector, entity, 0, Integer.MAX_VALUE);
    }

    @Override
    public void beforeEntityRemoved(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
    }

    @Override
    public void afterEntityRemoved(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        Object listVariable = this.sourceVariableDescriptor.getValue(entity);
        Iterator iterator = listVariable.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            innerScoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
            this.shadowVariableDescriptor.setValue(element, null);
            innerScoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
        }
    }

    @Override
    public void afterListVariableElementUnassigned(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object element) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        innerScoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
        this.shadowVariableDescriptor.setValue(element, null);
        innerScoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
    }

    @Override
    public void beforeListVariableChanged(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity, int fromIndex, int toIndex) {
    }

    @Override
    public void afterListVariableChanged(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity, int fromIndex, int toIndex) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        this.updateIndexes(innerScoreDirector, entity, fromIndex, toIndex);
    }

    private void updateIndexes(InnerScoreDirector<Solution_, ?> scoreDirector, Object entity, int fromIndex, int toIndex) {
        Object listVariable = this.sourceVariableDescriptor.getValue(entity);
        for (int i = fromIndex; i < listVariable.size(); ++i) {
            Object element = listVariable.get(i);
            Integer oldIndex = this.shadowVariableDescriptor.getValue(element);
            if (!Objects.equals(oldIndex, i)) {
                scoreDirector.beforeVariableChanged(this.shadowVariableDescriptor, element);
                this.shadowVariableDescriptor.setValue(element, i);
                scoreDirector.afterVariableChanged(this.shadowVariableDescriptor, element);
                continue;
            }
            if (i < toIndex) continue;
            return;
        }
    }

    @Override
    public Integer getIndex(Object planningValue) {
        return this.shadowVariableDescriptor.getValue(planningValue);
    }
}

