/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.inverserelation;

import ai.timefold.solver.core.api.domain.variable.VariableListener;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.listener.SourcedVariableListener;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jspecify.annotations.NonNull;

public class ExternalizedSingletonInverseVariableSupply<Solution_>
implements SourcedVariableListener<Solution_>,
VariableListener<Solution_, Object>,
SingletonInverseVariableSupply {
    protected final VariableDescriptor<Solution_> sourceVariableDescriptor;
    protected Map<Object, Object> inverseEntityMap = null;

    public ExternalizedSingletonInverseVariableSupply(VariableDescriptor<Solution_> sourceVariableDescriptor) {
        this.sourceVariableDescriptor = sourceVariableDescriptor;
    }

    @Override
    public VariableDescriptor<Solution_> getSourceVariableDescriptor() {
        return this.sourceVariableDescriptor;
    }

    @Override
    public void resetWorkingSolution(@NonNull ScoreDirector<Solution_> scoreDirector) {
        this.inverseEntityMap = new IdentityHashMap<Object, Object>();
        this.sourceVariableDescriptor.getEntityDescriptor().visitAllEntities(scoreDirector.getWorkingSolution(), this::insert);
    }

    @Override
    public void close() {
        this.inverseEntityMap = null;
    }

    @Override
    public void beforeEntityAdded(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
    }

    @Override
    public void afterEntityAdded(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        this.insert(entity);
    }

    @Override
    public void beforeVariableChanged(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        this.retract(entity);
    }

    @Override
    public void afterVariableChanged(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        this.insert(entity);
    }

    @Override
    public void beforeEntityRemoved(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
        this.retract(entity);
    }

    @Override
    public void afterEntityRemoved(@NonNull ScoreDirector<Solution_> scoreDirector, @NonNull Object entity) {
    }

    protected void insert(Object entity) {
        Object value = this.sourceVariableDescriptor.getValue(entity);
        if (value == null) {
            return;
        }
        Object oldInverseEntity = this.inverseEntityMap.put(value, entity);
        if (oldInverseEntity != null) {
            throw new IllegalStateException("The supply (" + this + ") is corrupted, because the entity (" + entity + ") for sourceVariable (" + this.sourceVariableDescriptor.getVariableName() + ") cannot be inserted: another entity (" + oldInverseEntity + ") already has that value (" + value + ").");
        }
    }

    protected void retract(Object entity) {
        Object value = this.sourceVariableDescriptor.getValue(entity);
        if (value == null) {
            return;
        }
        Object oldInverseEntity = this.inverseEntityMap.remove(value);
        if (oldInverseEntity != entity) {
            throw new IllegalStateException("The supply (" + this + ") is corrupted, because the entity (" + entity + ") for sourceVariable (" + this.sourceVariableDescriptor.getVariableName() + ") cannot be retracted: the entity was never inserted for that value (" + value + ").");
        }
    }

    @Override
    public Object getInverseSingleton(Object value) {
        return this.inverseEntityMap.get(value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.sourceVariableDescriptor.getVariableName() + ")";
    }
}

