/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.listener.support;

import ai.timefold.solver.core.api.domain.variable.AbstractVariableListener;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.cascade.CascadingUpdateShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.SourcedVariableListener;
import ai.timefold.solver.core.impl.domain.variable.listener.VariableListenerWithSources;
import ai.timefold.solver.core.impl.domain.variable.listener.support.AbstractNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.BasicVariableNotification;
import ai.timefold.solver.core.impl.domain.variable.listener.support.EntityNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.EntityNotification;
import ai.timefold.solver.core.impl.domain.variable.listener.support.ListVariableEvent;
import ai.timefold.solver.core.impl.domain.variable.listener.support.ListVariableListenerNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.ListVariableNotification;
import ai.timefold.solver.core.impl.domain.variable.listener.support.Notifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.NotifiableRegistry;
import ai.timefold.solver.core.impl.domain.variable.listener.support.Notification;
import ai.timefold.solver.core.impl.domain.variable.listener.support.VariableListenerNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.ShadowVariablesAssert;
import ai.timefold.solver.core.impl.domain.variable.supply.Demand;
import ai.timefold.solver.core.impl.domain.variable.supply.Supply;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class VariableListenerSupport<Solution_>
implements SupplyManager {
    private static final int SHADOW_VARIABLE_VIOLATION_DISPLAY_LIMIT = 3;
    private final InnerScoreDirector<Solution_, ?> scoreDirector;
    private final NotifiableRegistry<Solution_> notifiableRegistry;
    private final Map<Demand<?>, SupplyWithDemandCount> supplyMap = new HashMap();
    private final List<ListVariableEvent> listVariableEventList;
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final List<CascadingUpdateShadowVariableDescriptor<Solution_>> cascadingUpdateShadowVarDescriptorList;
    private boolean notificationQueuesAreEmpty = true;
    private int nextGlobalOrder = 0;

    public static <Solution_> VariableListenerSupport<Solution_> create(InnerScoreDirector<Solution_, ?> scoreDirector) {
        return new VariableListenerSupport<Solution_>(scoreDirector, new NotifiableRegistry<Solution_>(scoreDirector.getSolutionDescriptor()));
    }

    VariableListenerSupport(InnerScoreDirector<Solution_, ?> scoreDirector, NotifiableRegistry<Solution_> notifiableRegistry) {
        this.scoreDirector = scoreDirector;
        this.notifiableRegistry = notifiableRegistry;
        this.cascadingUpdateShadowVarDescriptorList = scoreDirector.getSolutionDescriptor().getEntityDescriptors().stream().flatMap(e -> e.getDeclaredCascadingUpdateShadowVariableDescriptors().stream()).toList();
        this.listVariableDescriptor = scoreDirector.getSolutionDescriptor().getListVariableDescriptor();
        this.listVariableEventList = new ArrayList<ListVariableEvent>();
    }

    public void linkVariableListeners() {
        this.scoreDirector.getSolutionDescriptor().getEntityDescriptors().stream().map(EntityDescriptor::getDeclaredShadowVariableDescriptors).flatMap(Collection::stream).filter(ShadowVariableDescriptor::hasVariableListener).sorted(Comparator.comparingInt(ShadowVariableDescriptor::getGlobalShadowOrder)).forEach(this::processShadowVariableDescriptor);
    }

    private void processShadowVariableDescriptor(ShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        for (VariableListenerWithSources<Solution_> listenerWithSources : shadowVariableDescriptor.buildVariableListeners(this)) {
            AbstractVariableListener<Solution_, Object> variableListener = listenerWithSources.getVariableListener();
            if (variableListener instanceof Supply) {
                Supply supply = (Supply)((Object)variableListener);
                Demand<?> demand = shadowVariableDescriptor.getProvidedDemand();
                this.supplyMap.put(demand, new SupplyWithDemandCount(supply, 1L));
            }
            int globalOrder = shadowVariableDescriptor.getGlobalShadowOrder();
            this.notifiableRegistry.registerNotifiable(listenerWithSources.getSourceVariableDescriptors(), AbstractNotifiable.buildNotifiable(this.scoreDirector, variableListener, globalOrder));
            this.nextGlobalOrder = globalOrder + 1;
        }
    }

    @Override
    public <Supply_ extends Supply> Supply_ demand(Demand<Supply_> demand) {
        SupplyWithDemandCount supplyWithDemandCount = this.supplyMap.get(demand);
        if (supplyWithDemandCount == null) {
            SupplyWithDemandCount newSupplyWithDemandCount = new SupplyWithDemandCount(this.createSupply(demand), 1L);
            this.supplyMap.put(demand, newSupplyWithDemandCount);
            return (Supply_)newSupplyWithDemandCount.supply;
        }
        Supply supply = supplyWithDemandCount.supply;
        SupplyWithDemandCount newSupplyWithDemandCount = new SupplyWithDemandCount(supply, supplyWithDemandCount.demandCount + 1L);
        this.supplyMap.put(demand, newSupplyWithDemandCount);
        return (Supply_)supply;
    }

    private Supply createSupply(Demand<?> demand) {
        Object supply = demand.createExternalizedSupply(this);
        if (supply instanceof SourcedVariableListener) {
            SourcedVariableListener variableListener = (SourcedVariableListener)supply;
            if (this.scoreDirector.getWorkingSolution() != null) {
                variableListener.resetWorkingSolution(this.scoreDirector);
            }
            this.notifiableRegistry.registerNotifiable(variableListener.getSourceVariableDescriptor(), AbstractNotifiable.buildNotifiable(this.scoreDirector, variableListener, this.nextGlobalOrder++));
        }
        return supply;
    }

    @Override
    public <Supply_ extends Supply> boolean cancel(Demand<Supply_> demand) {
        SupplyWithDemandCount supplyWithDemandCount = this.supplyMap.get(demand);
        if (supplyWithDemandCount == null) {
            return false;
        }
        if (supplyWithDemandCount.demandCount == 1L) {
            this.supplyMap.remove(demand);
        } else {
            this.supplyMap.put(demand, new SupplyWithDemandCount(supplyWithDemandCount.supply, supplyWithDemandCount.demandCount - 1L));
        }
        return true;
    }

    @Override
    public <Supply_ extends Supply> long getActiveCount(Demand<Supply_> demand) {
        SupplyWithDemandCount supplyAndDemandCounter = this.supplyMap.get(demand);
        if (supplyAndDemandCounter == null) {
            return 0L;
        }
        return supplyAndDemandCounter.demandCount;
    }

    public void resetWorkingSolution() {
        for (Notifiable notifiable : this.notifiableRegistry.getAll()) {
            notifiable.resetWorkingSolution();
        }
    }

    public void close() {
        for (Notifiable notifiable : this.notifiableRegistry.getAll()) {
            notifiable.closeVariableListener();
        }
    }

    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        Collection<EntityNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(entityDescriptor);
        if (!notifiables.isEmpty()) {
            EntityNotification notification = Notification.entityAdded(entity);
            for (EntityNotifiable notifiable : notifiables) {
                notifiable.notifyBefore(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        Collection<EntityNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(entityDescriptor);
        if (!notifiables.isEmpty()) {
            EntityNotification notification = Notification.entityRemoved(entity);
            for (EntityNotifiable notifiable : notifiables) {
                notifiable.notifyBefore(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        Collection<VariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            BasicVariableNotification notification = Notification.variableChanged(entity);
            for (VariableListenerNotifiable notifiable : notifiables) {
                notifiable.notifyBefore(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void afterElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        Collection<ListVariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            ListVariableNotification notification = Notification.elementUnassigned(element);
            for (ListVariableListenerNotifiable notifiable : notifiables) {
                notifiable.notifyAfter(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void beforeListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        Collection<ListVariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            ListVariableNotification notification = Notification.listVariableChanged(entity, fromIndex, toIndex);
            for (ListVariableListenerNotifiable notifiable : notifiables) {
                notifiable.notifyBefore(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void afterListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        Collection<ListVariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            ListVariableNotification notification = Notification.listVariableChanged(entity, fromIndex, toIndex);
            for (ListVariableListenerNotifiable notifiable : notifiables) {
                notifiable.notifyAfter(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
        this.listVariableEventList.add(new ListVariableEvent(entity, fromIndex, toIndex));
    }

    public void triggerVariableListenersInNotificationQueues() {
        for (Notifiable notifiable : this.notifiableRegistry.getAll()) {
            notifiable.triggerAllNotifications();
        }
        if (this.listVariableDescriptor != null && !this.cascadingUpdateShadowVarDescriptorList.isEmpty()) {
            this.triggerCascadingUpdateShadowVariableUpdate();
        }
        this.notificationQueuesAreEmpty = true;
        this.listVariableEventList.clear();
    }

    private void triggerCascadingUpdateShadowVariableUpdate() {
        if (this.listVariableEventList.isEmpty() || this.cascadingUpdateShadowVarDescriptorList.isEmpty()) {
            return;
        }
        for (CascadingUpdateShadowVariableDescriptor<Solution_> cascadingUpdateShadowVariableDescriptor : this.cascadingUpdateShadowVarDescriptorList) {
            for (ListVariableEvent event : this.listVariableEventList) {
                Object values = this.listVariableDescriptor.getValue(event.entity());
                this.evaluateFromIndex((List<Object>)values, event.fromIndex(), event.toIndex(), true, cascadingUpdateShadowVariableDescriptor);
                this.evaluateFromIndex((List<Object>)values, event.toIndex(), values.size(), false, cascadingUpdateShadowVariableDescriptor);
            }
        }
    }

    private void evaluateFromIndex(List<Object> values, int fromIndex, int toIndex, boolean forceUpdate, CascadingUpdateShadowVariableDescriptor<Solution_> cascadingUpdateShadowVariableDescriptor) {
        for (int lastUpdated = fromIndex; lastUpdated < toIndex && (cascadingUpdateShadowVariableDescriptor.update(this.scoreDirector, values.get(lastUpdated)) || forceUpdate); ++lastUpdated) {
        }
    }

    public String createShadowVariablesViolationMessage() {
        Object workingSolution = this.scoreDirector.getWorkingSolution();
        ShadowVariablesAssert snapshot = ShadowVariablesAssert.takeSnapshot(this.scoreDirector.getSolutionDescriptor(), workingSolution);
        this.forceTriggerAllVariableListeners(workingSolution);
        return snapshot.createShadowVariablesViolationMessage(3L);
    }

    public void forceTriggerAllVariableListeners(Solution_ workingSolution) {
        this.scoreDirector.getSolutionDescriptor().visitAllEntities(workingSolution, this::simulateGenuineVariableChange);
        this.triggerVariableListenersInNotificationQueues();
    }

    private void simulateGenuineVariableChange(Object entity) {
        EntityDescriptor<Solution_> entityDescriptor = this.scoreDirector.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass());
        if (!entityDescriptor.isGenuine()) {
            return;
        }
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
            if (variableDescriptor.isListVariable()) {
                ListVariableDescriptor descriptor = (ListVariableDescriptor)variableDescriptor;
                int size = descriptor.getValue(entity).size();
                this.beforeListVariableChanged(descriptor, entity, 0, size);
                this.afterListVariableChanged(descriptor, entity, 0, size);
                continue;
            }
            this.beforeVariableChanged(variableDescriptor, entity);
        }
    }

    public void assertNotificationQueuesAreEmpty() {
        if (!this.notificationQueuesAreEmpty) {
            throw new IllegalStateException("The notificationQueues might not be empty (" + this.notificationQueuesAreEmpty + ") so any shadow variables might be stale so score calculation is unreliable.\nMaybe a " + ScoreDirector.class.getSimpleName() + ".before*() method was called without calling " + ScoreDirector.class.getSimpleName() + ".triggerVariableListeners(), before calling " + ScoreDirector.class.getSimpleName() + ".calculateScore().");
        }
    }

    private record SupplyWithDemandCount(Supply supply, long demandCount) {
    }
}

