/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.exhaustivesearch.decider;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.exhaustivesearch.event.ExhaustiveSearchPhaseLifecycleListener;
import ai.timefold.solver.core.impl.exhaustivesearch.node.ExhaustiveSearchLayer;
import ai.timefold.solver.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import ai.timefold.solver.core.impl.exhaustivesearch.node.bounder.ScoreBounder;
import ai.timefold.solver.core.impl.exhaustivesearch.scope.ExhaustiveSearchPhaseScope;
import ai.timefold.solver.core.impl.exhaustivesearch.scope.ExhaustiveSearchStepScope;
import ai.timefold.solver.core.impl.heuristic.move.LegacyMoveAdapter;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.ManualEntityMimicRecorder;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.move.director.EphemeralMoveDirector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.SolverLifecyclePoint;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.preview.api.move.Move;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExhaustiveSearchDecider<Solution_>
implements ExhaustiveSearchPhaseLifecycleListener<Solution_> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExhaustiveSearchDecider.class);
    private final String logIndentation;
    private final BestSolutionRecaller<Solution_> bestSolutionRecaller;
    private final Termination<Solution_> termination;
    private final ManualEntityMimicRecorder<Solution_> manualEntityMimicRecorder;
    private final MoveSelector<Solution_> moveSelector;
    private final boolean scoreBounderEnabled;
    private final ScoreBounder scoreBounder;
    private boolean assertMoveScoreFromScratch = false;
    private boolean assertExpectedUndoMoveScore = false;

    public ExhaustiveSearchDecider(String logIndentation, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination<Solution_> termination, ManualEntityMimicRecorder<Solution_> manualEntityMimicRecorder, MoveSelector<Solution_> moveSelector, boolean scoreBounderEnabled, ScoreBounder scoreBounder) {
        this.logIndentation = logIndentation;
        this.bestSolutionRecaller = bestSolutionRecaller;
        this.termination = termination;
        this.manualEntityMimicRecorder = manualEntityMimicRecorder;
        this.moveSelector = moveSelector;
        this.scoreBounderEnabled = scoreBounderEnabled;
        this.scoreBounder = scoreBounder;
    }

    public MoveSelector<Solution_> getMoveSelector() {
        return this.moveSelector;
    }

    public boolean isScoreBounderEnabled() {
        return this.scoreBounderEnabled;
    }

    public ScoreBounder getScoreBounder() {
        return this.scoreBounder;
    }

    public void setAssertMoveScoreFromScratch(boolean assertMoveScoreFromScratch) {
        this.assertMoveScoreFromScratch = assertMoveScoreFromScratch;
    }

    public void setAssertExpectedUndoMoveScore(boolean assertExpectedUndoMoveScore) {
        this.assertExpectedUndoMoveScore = assertExpectedUndoMoveScore;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        this.moveSelector.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        this.moveSelector.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(ExhaustiveSearchStepScope<Solution_> stepScope) {
        this.moveSelector.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(ExhaustiveSearchStepScope<Solution_> stepScope) {
        this.moveSelector.stepEnded(stepScope);
    }

    @Override
    public void phaseEnded(ExhaustiveSearchPhaseScope<Solution_> phaseScope) {
        this.moveSelector.phaseEnded(phaseScope);
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        this.moveSelector.solvingEnded(solverScope);
    }

    public void expandNode(ExhaustiveSearchStepScope<Solution_> stepScope) {
        ExhaustiveSearchNode expandingNode = stepScope.getExpandingNode();
        this.manualEntityMimicRecorder.setRecordedEntity(expandingNode.getEntity());
        int moveIndex = 0;
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        ExhaustiveSearchLayer moveLayer = ((ExhaustiveSearchPhaseScope)phaseScope).getLayerList().get(expandingNode.getDepth() + 1);
        for (ai.timefold.solver.core.impl.heuristic.move.Move move : this.moveSelector) {
            ExhaustiveSearchNode moveNode = new ExhaustiveSearchNode(moveLayer, expandingNode);
            ++moveIndex;
            LegacyMoveAdapter adaptedMove = new LegacyMoveAdapter(move);
            moveNode.setMove(adaptedMove);
            this.doMove(stepScope, moveNode);
            phaseScope.addMoveEvaluationCount(adaptedMove, 1L);
            phaseScope.getSolverScope().checkYielding();
            if (!this.termination.isPhaseTerminated(stepScope.getPhaseScope())) continue;
            break;
        }
        stepScope.setSelectedMoveCount(Long.valueOf(moveIndex));
    }

    private <Score_ extends Score<Score_>> void doMove(ExhaustiveSearchStepScope<Solution_> stepScope, ExhaustiveSearchNode moveNode) {
        InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
        Move move = moveNode.getMove();
        try (EphemeralMoveDirector ephemeralMoveDirector = scoreDirector.getMoveDirector().ephemeral();){
            move.execute(ephemeralMoveDirector);
            this.processMove(stepScope, moveNode);
            moveNode.setUndoMove(ephemeralMoveDirector.createUndoMove());
        }
        SolverLifecyclePoint executionPoint = SolverLifecyclePoint.of(stepScope, moveNode.getTreeId());
        if (this.assertExpectedUndoMoveScore && stepScope.getStartingStepScore() != null) {
            scoreDirector.assertExpectedUndoMoveScore(move, stepScope.getStartingStepScore(), executionPoint);
        }
        LOGGER.trace("{}        Move treeId ({}), score ({}), expandable ({}), move ({}).", new Object[]{this.logIndentation, executionPoint.treeId(), moveNode.getScore(), moveNode.isExpandable(), moveNode.getMove()});
    }

    private <Score_ extends Score<Score_>> void processMove(ExhaustiveSearchStepScope<Solution_> stepScope, ExhaustiveSearchNode moveNode) {
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        boolean lastLayer = moveNode.isLastLayer();
        if (!this.scoreBounderEnabled) {
            if (lastLayer) {
                Object score = phaseScope.calculateScore();
                moveNode.setScore((Score)score);
                if (this.assertMoveScoreFromScratch) {
                    phaseScope.assertWorkingScoreFromScratch(score, moveNode.getMove());
                }
                this.bestSolutionRecaller.processWorkingSolutionDuringMove((Score)score, stepScope);
            } else {
                ((ExhaustiveSearchPhaseScope)phaseScope).addExpandableNode(moveNode);
            }
        } else {
            Object score = phaseScope.calculateScore();
            moveNode.setScore((Score)score);
            if (this.assertMoveScoreFromScratch) {
                phaseScope.assertWorkingScoreFromScratch(score, moveNode.getMove());
            }
            if (lastLayer) {
                ((ExhaustiveSearchPhaseScope)phaseScope).registerPessimisticBound((Score)score);
                this.bestSolutionRecaller.processWorkingSolutionDuringMove((Score)score, stepScope);
            } else {
                InnerScoreDirector scoreDirector = phaseScope.getScoreDirector();
                Score optimisticBound = this.scoreBounder.calculateOptimisticBound(scoreDirector, (Score)score);
                moveNode.setOptimisticBound(optimisticBound);
                Score bestPessimisticBound = ((ExhaustiveSearchPhaseScope)phaseScope).getBestPessimisticBound();
                if (optimisticBound.compareTo(bestPessimisticBound) > 0) {
                    ((ExhaustiveSearchPhaseScope)phaseScope).addExpandableNode(moveNode);
                    Score pessimisticBound = this.scoreBounder.calculatePessimisticBound(scoreDirector, (Score)score);
                    ((ExhaustiveSearchPhaseScope)phaseScope).registerPessimisticBound(pessimisticBound);
                }
            }
        }
    }
}

