/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.common.decorator;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;

public final class WeightFactorySelectionSorter<Solution_, T>
implements SelectionSorter<Solution_, T> {
    private final SelectionSorterWeightFactory<Solution_, T> selectionSorterWeightFactory;
    private final Comparator<Comparable> appliedWeightComparator;

    public WeightFactorySelectionSorter(SelectionSorterWeightFactory<Solution_, T> selectionSorterWeightFactory, SelectionSorterOrder selectionSorterOrder) {
        this.selectionSorterWeightFactory = selectionSorterWeightFactory;
        switch (selectionSorterOrder) {
            case ASCENDING: {
                this.appliedWeightComparator = Comparator.naturalOrder();
                break;
            }
            case DESCENDING: {
                this.appliedWeightComparator = Collections.reverseOrder();
                break;
            }
            default: {
                throw new IllegalStateException("The selectionSorterOrder (" + selectionSorterOrder + ") is not implemented.");
            }
        }
    }

    @Override
    public void sort(ScoreDirector<Solution_> scoreDirector, List<T> selectionList) {
        this.sort(scoreDirector.getWorkingSolution(), selectionList);
    }

    public void sort(Solution_ solution, List<T> selectionList) {
        TreeMap<Comparable, T> selectionMap = new TreeMap<Comparable, T>(this.appliedWeightComparator);
        for (T selection : selectionList) {
            Comparable difficultyWeight = this.selectionSorterWeightFactory.createSorterWeight(solution, selection);
            T previous = selectionMap.put(difficultyWeight, selection);
            if (previous == null) continue;
            throw new IllegalStateException("The selectionList contains 2 times the same selection (" + previous + ") and (" + selection + ").");
        }
        selectionList.clear();
        selectionList.addAll(selectionMap.values());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        WeightFactorySelectionSorter that = (WeightFactorySelectionSorter)other;
        return Objects.equals(this.selectionSorterWeightFactory, that.selectionSorterWeightFactory) && Objects.equals(this.appliedWeightComparator, that.appliedWeightComparator);
    }

    public int hashCode() {
        return Objects.hash(this.selectionSorterWeightFactory, this.appliedWeightComparator);
    }
}

