/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity;

import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySorterManner;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.FromSolutionEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.CachingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.FilteringEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.ProbabilityEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.SelectedCountLimitEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.ShufflingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.SortingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.EntityMimicRecorder;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.MimicRecordingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import ai.timefold.solver.core.impl.solver.ClassInstanceCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class EntitySelectorFactory<Solution_>
extends AbstractSelectorFactory<Solution_, EntitySelectorConfig> {
    public static <Solution_> EntitySelectorFactory<Solution_> create(EntitySelectorConfig entitySelectorConfig) {
        return new EntitySelectorFactory<Solution_>(entitySelectorConfig);
    }

    public EntitySelectorFactory(EntitySelectorConfig entitySelectorConfig) {
        super(entitySelectorConfig);
    }

    public EntityDescriptor<Solution_> extractEntityDescriptor(HeuristicConfigPolicy<Solution_> configPolicy) {
        Class<?> entityClass = ((EntitySelectorConfig)this.config).getEntityClass();
        String mimicSelectorRef = ((EntitySelectorConfig)this.config).getMimicSelectorRef();
        if (entityClass != null) {
            SolutionDescriptor<Solution_> solutionDescriptor = configPolicy.getSolutionDescriptor();
            EntityDescriptor<Solution_> entityDescriptor = solutionDescriptor.getEntityDescriptorStrict(entityClass);
            if (entityDescriptor == null) {
                throw new IllegalArgumentException("The selectorConfig (%s) has an entityClass (%s) that is not a known planning entity.\nCheck your solver configuration. If that class (%s) is not in the entityClassSet (%s), check your @%s implementation's annotated methods too.".formatted(this.config, entityClass, entityClass.getSimpleName(), solutionDescriptor.getEntityClassSet(), PlanningSolution.class.getSimpleName()));
            }
            return entityDescriptor;
        }
        if (mimicSelectorRef != null) {
            return configPolicy.getEntityMimicRecorder(mimicSelectorRef).getEntityDescriptor();
        }
        return null;
    }

    public EntitySelector<Solution_> buildEntitySelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        if (((EntitySelectorConfig)this.config).getMimicSelectorRef() != null) {
            return this.buildMimicReplaying(configPolicy);
        }
        EntityDescriptor<Solution_> entityDescriptor = this.deduceEntityDescriptor(configPolicy, ((EntitySelectorConfig)this.config).getEntityClass());
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(((EntitySelectorConfig)this.config).getCacheType(), minimumCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(((EntitySelectorConfig)this.config).getSelectionOrder(), inheritedSelectionOrder);
        NearbySelectionConfig nearbySelectionConfig = ((EntitySelectorConfig)this.config).getNearbySelectionConfig();
        if (nearbySelectionConfig != null) {
            nearbySelectionConfig.validateNearby(resolvedCacheType, resolvedSelectionOrder);
        }
        this.validateCacheTypeVersusSelectionOrder(resolvedCacheType, resolvedSelectionOrder);
        this.validateSorting(resolvedSelectionOrder);
        this.validateProbability(resolvedSelectionOrder);
        this.validateSelectedLimit(minimumCacheType);
        boolean baseRandomSelection = this.determineBaseRandomSelection(entityDescriptor, resolvedCacheType, resolvedSelectionOrder);
        SelectionCacheType baseSelectionCacheType = SelectionCacheType.max(minimumCacheType, resolvedCacheType);
        EntitySelector<Solution_> entitySelector = this.buildBaseEntitySelector(entityDescriptor, baseSelectionCacheType, baseRandomSelection);
        if (nearbySelectionConfig != null) {
            entitySelector = this.applyNearbySelection(configPolicy, nearbySelectionConfig, minimumCacheType, resolvedSelectionOrder, entitySelector);
        }
        ClassInstanceCache instanceCache = configPolicy.getClassInstanceCache();
        entitySelector = this.applyFiltering(entitySelector, instanceCache);
        entitySelector = this.applySorting(resolvedCacheType, resolvedSelectionOrder, entitySelector, instanceCache);
        entitySelector = this.applyProbability(resolvedCacheType, resolvedSelectionOrder, entitySelector, instanceCache);
        entitySelector = this.applyShuffling(resolvedCacheType, resolvedSelectionOrder, entitySelector);
        entitySelector = this.applyCaching(resolvedCacheType, resolvedSelectionOrder, entitySelector);
        entitySelector = this.applySelectedLimit(resolvedSelectionOrder, entitySelector);
        entitySelector = this.applyMimicRecording(configPolicy, entitySelector);
        return entitySelector;
    }

    protected EntitySelector<Solution_> buildMimicReplaying(HeuristicConfigPolicy<Solution_> configPolicy) {
        boolean anyConfigurationParameterDefined = Stream.of(new Object[]{((EntitySelectorConfig)this.config).getId(), ((EntitySelectorConfig)this.config).getEntityClass(), ((EntitySelectorConfig)this.config).getCacheType(), ((EntitySelectorConfig)this.config).getSelectionOrder(), ((EntitySelectorConfig)this.config).getNearbySelectionConfig(), ((EntitySelectorConfig)this.config).getFilterClass(), ((EntitySelectorConfig)this.config).getSorterManner(), ((EntitySelectorConfig)this.config).getSorterComparatorClass(), ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass(), ((EntitySelectorConfig)this.config).getSorterOrder(), ((EntitySelectorConfig)this.config).getSorterClass(), ((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass(), ((EntitySelectorConfig)this.config).getSelectedCountLimit()}).anyMatch(Objects::nonNull);
        if (anyConfigurationParameterDefined) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) with mimicSelectorRef (%s) has another property that is not null.".formatted(this.config, ((EntitySelectorConfig)this.config).getMimicSelectorRef()));
        }
        EntityMimicRecorder<Solution_> entityMimicRecorder = configPolicy.getEntityMimicRecorder(((EntitySelectorConfig)this.config).getMimicSelectorRef());
        if (entityMimicRecorder == null) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) has a mimicSelectorRef (%s) for which no entitySelector with that id exists (in its solver phase).".formatted(this.config, ((EntitySelectorConfig)this.config).getMimicSelectorRef()));
        }
        return new MimicReplayingEntitySelector<Solution_>(entityMimicRecorder);
    }

    protected boolean determineBaseRandomSelection(EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        return switch (resolvedSelectionOrder) {
            case SelectionOrder.ORIGINAL, SelectionOrder.SORTED, SelectionOrder.SHUFFLED, SelectionOrder.PROBABILISTIC -> false;
            case SelectionOrder.RANDOM -> {
                if (resolvedCacheType.isNotCached() || this.isBaseInherentlyCached() && !this.hasFiltering(entityDescriptor)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalStateException("The selectionOrder (%s) is not implemented.".formatted(new Object[]{resolvedSelectionOrder}));
        };
    }

    protected boolean isBaseInherentlyCached() {
        return true;
    }

    private EntitySelector<Solution_> buildBaseEntitySelector(EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        if (minimumCacheType == SelectionCacheType.SOLVER) {
            throw new IllegalArgumentException("The minimumCacheType (%s) is not supported here. Please use %s instead.".formatted(new Object[]{minimumCacheType, SelectionCacheType.PHASE}));
        }
        return new FromSolutionEntitySelector<Solution_>(entityDescriptor, minimumCacheType, randomSelection);
    }

    private boolean hasFiltering(EntityDescriptor<Solution_> entityDescriptor) {
        return ((EntitySelectorConfig)this.config).getFilterClass() != null || entityDescriptor.hasEffectiveMovableEntityFilter();
    }

    private EntitySelector<Solution_> applyNearbySelection(HeuristicConfigPolicy<Solution_> configPolicy, NearbySelectionConfig nearbySelectionConfig, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector) {
        return TimefoldSolverEnterpriseService.loadOrFail(TimefoldSolverEnterpriseService.Feature.NEARBY_SELECTION).applyNearbySelection((EntitySelectorConfig)this.config, configPolicy, nearbySelectionConfig, minimumCacheType, resolvedSelectionOrder, entitySelector);
    }

    private EntitySelector<Solution_> applyFiltering(EntitySelector<Solution_> entitySelector, ClassInstanceCache instanceCache) {
        EntityDescriptor entityDescriptor = entitySelector.getEntityDescriptor();
        if (this.hasFiltering(entityDescriptor)) {
            Class<? extends SelectionFilter> filterClass = ((EntitySelectorConfig)this.config).getFilterClass();
            ArrayList filterList = new ArrayList(filterClass == null ? 1 : 2);
            if (filterClass != null) {
                SelectionFilter selectionFilter = instanceCache.newInstance(this.config, "filterClass", filterClass);
                filterList.add(selectionFilter);
            }
            if (entityDescriptor.hasEffectiveMovableEntityFilter()) {
                filterList.add((scoreDirector, selection) -> entityDescriptor.getEffectiveMovableEntityFilter().test(scoreDirector.getWorkingSolution(), selection));
            }
            entitySelector = FilteringEntitySelector.of(entitySelector, SelectionFilter.compose(filterList));
        }
        return entitySelector;
    }

    protected void validateSorting(SelectionOrder resolvedSelectionOrder) {
        EntitySorterManner sorterManner = ((EntitySelectorConfig)this.config).getSorterManner();
        Class<? extends Comparator> sorterComparatorClass = ((EntitySelectorConfig)this.config).getSorterComparatorClass();
        Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass = ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass();
        SelectionSorterOrder sorterOrder = ((EntitySelectorConfig)this.config).getSorterOrder();
        Class<? extends SelectionSorter> sorterClass = ((EntitySelectorConfig)this.config).getSorterClass();
        if ((sorterManner != null || sorterComparatorClass != null || sorterWeightFactoryClass != null || sorterOrder != null || sorterClass != null) && resolvedSelectionOrder != SelectionOrder.SORTED) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) with sorterManner (%s) and sorterComparatorClass (%s) and sorterWeightFactoryClass (%s) and sorterOrder (%s) and sorterClass (%s) has a resolvedSelectionOrder (%s) that is not %s.".formatted(new Object[]{this.config, sorterManner, sorterComparatorClass, sorterWeightFactoryClass, sorterOrder, sorterClass, resolvedSelectionOrder, SelectionOrder.SORTED}));
        }
        EntitySelectorFactory.assertNotSorterMannerAnd((EntitySelectorConfig)this.config, "sorterComparatorClass", EntitySelectorConfig::getSorterComparatorClass);
        EntitySelectorFactory.assertNotSorterMannerAnd((EntitySelectorConfig)this.config, "sorterWeightFactoryClass", EntitySelectorConfig::getSorterWeightFactoryClass);
        EntitySelectorFactory.assertNotSorterMannerAnd((EntitySelectorConfig)this.config, "sorterClass", EntitySelectorConfig::getSorterClass);
        EntitySelectorFactory.assertNotSorterMannerAnd((EntitySelectorConfig)this.config, "sorterOrder", EntitySelectorConfig::getSorterOrder);
        EntitySelectorFactory.assertNotSorterClassAnd((EntitySelectorConfig)this.config, "sorterComparatorClass", EntitySelectorConfig::getSorterComparatorClass);
        EntitySelectorFactory.assertNotSorterClassAnd((EntitySelectorConfig)this.config, "sorterWeightFactoryClass", EntitySelectorConfig::getSorterWeightFactoryClass);
        EntitySelectorFactory.assertNotSorterClassAnd((EntitySelectorConfig)this.config, "sorterOrder", EntitySelectorConfig::getSorterOrder);
        if (sorterComparatorClass != null && sorterWeightFactoryClass != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) has both a sorterComparatorClass (%s) and a sorterWeightFactoryClass (%s).".formatted(this.config, sorterComparatorClass, sorterWeightFactoryClass));
        }
    }

    private static void assertNotSorterMannerAnd(EntitySelectorConfig config, String propertyName, Function<EntitySelectorConfig, Object> propertyAccessor) {
        EntitySorterManner sorterManner = config.getSorterManner();
        Object property = propertyAccessor.apply(config);
        if (sorterManner != null && property != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) has both a sorterManner (%s) and a %s (%s).".formatted(new Object[]{config, sorterManner, propertyName, property}));
        }
    }

    private static void assertNotSorterClassAnd(EntitySelectorConfig config, String propertyName, Function<EntitySelectorConfig, Object> propertyAccessor) {
        Class<? extends SelectionSorter> sorterClass = config.getSorterClass();
        Object property = propertyAccessor.apply(config);
        if (sorterClass != null && property != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) with sorterClass (%s) has a non-null %s (%s).".formatted(config, sorterClass, propertyName, property));
        }
    }

    protected EntitySelector<Solution_> applySorting(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector, ClassInstanceCache instanceCache) {
        if (resolvedSelectionOrder == SelectionOrder.SORTED) {
            WeightFactorySelectionSorter sorter;
            EntitySorterManner sorterManner = ((EntitySelectorConfig)this.config).getSorterManner();
            if (sorterManner != null) {
                EntityDescriptor<Solution_> entityDescriptor = entitySelector.getEntityDescriptor();
                if (!EntitySelectorConfig.hasSorter(sorterManner, entityDescriptor)) {
                    return entitySelector;
                }
                sorter = EntitySelectorConfig.determineSorter(sorterManner, entityDescriptor);
            } else if (((EntitySelectorConfig)this.config).getSorterComparatorClass() != null) {
                Comparator sorterComparator = instanceCache.newInstance(this.config, "sorterComparatorClass", ((EntitySelectorConfig)this.config).getSorterComparatorClass());
                sorter = new ComparatorSelectionSorter(sorterComparator, SelectionSorterOrder.resolve(((EntitySelectorConfig)this.config).getSorterOrder()));
            } else if (((EntitySelectorConfig)this.config).getSorterWeightFactoryClass() != null) {
                SelectionSorterWeightFactory sorterWeightFactory = instanceCache.newInstance(this.config, "sorterWeightFactoryClass", ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass());
                sorter = new WeightFactorySelectionSorter(sorterWeightFactory, SelectionSorterOrder.resolve(((EntitySelectorConfig)this.config).getSorterOrder()));
            } else if (((EntitySelectorConfig)this.config).getSorterClass() != null) {
                sorter = instanceCache.newInstance(this.config, "sorterClass", ((EntitySelectorConfig)this.config).getSorterClass());
            } else {
                throw new IllegalArgumentException("The entitySelectorConfig (%s) with resolvedSelectionOrder (%s) needs a sorterManner (%s) or a sorterComparatorClass (%s) or a sorterWeightFactoryClass (%s) or a sorterClass (%s).".formatted(new Object[]{this.config, resolvedSelectionOrder, sorterManner, ((EntitySelectorConfig)this.config).getSorterComparatorClass(), ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass(), ((EntitySelectorConfig)this.config).getSorterClass()}));
            }
            entitySelector = new SortingEntitySelector<Solution_>(entitySelector, resolvedCacheType, sorter);
        }
        return entitySelector;
    }

    protected void validateProbability(SelectionOrder resolvedSelectionOrder) {
        if (((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass() != null && resolvedSelectionOrder != SelectionOrder.PROBABILISTIC) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") with probabilityWeightFactoryClass (" + ((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass() + ") has a resolvedSelectionOrder (" + resolvedSelectionOrder + ") that is not " + SelectionOrder.PROBABILISTIC + ".");
        }
    }

    protected EntitySelector<Solution_> applyProbability(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector, ClassInstanceCache instanceCache) {
        if (resolvedSelectionOrder == SelectionOrder.PROBABILISTIC) {
            if (((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass() == null) {
                throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") with resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs a probabilityWeightFactoryClass (" + ((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass() + ").");
            }
            SelectionProbabilityWeightFactory probabilityWeightFactory = instanceCache.newInstance(this.config, "probabilityWeightFactoryClass", ((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass());
            entitySelector = new ProbabilityEntitySelector<Solution_>(entitySelector, resolvedCacheType, probabilityWeightFactory);
        }
        return entitySelector;
    }

    private EntitySelector<Solution_> applyShuffling(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector) {
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            entitySelector = new ShufflingEntitySelector<Solution_>(entitySelector, resolvedCacheType);
        }
        return entitySelector;
    }

    private EntitySelector<Solution_> applyCaching(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector) {
        if (resolvedCacheType.isCached() && resolvedCacheType.compareTo(entitySelector.getCacheType()) > 0) {
            entitySelector = new CachingEntitySelector<Solution_>(entitySelector, resolvedCacheType, resolvedSelectionOrder.toRandomSelectionBoolean());
        }
        return entitySelector;
    }

    private void validateSelectedLimit(SelectionCacheType minimumCacheType) {
        if (((EntitySelectorConfig)this.config).getSelectedCountLimit() != null && minimumCacheType.compareTo(SelectionCacheType.JUST_IN_TIME) > 0) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") with selectedCountLimit (" + ((EntitySelectorConfig)this.config).getSelectedCountLimit() + ") has a minimumCacheType (" + minimumCacheType + ") that is higher than " + SelectionCacheType.JUST_IN_TIME + ".");
        }
    }

    private EntitySelector<Solution_> applySelectedLimit(SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector) {
        if (((EntitySelectorConfig)this.config).getSelectedCountLimit() != null) {
            entitySelector = new SelectedCountLimitEntitySelector<Solution_>(entitySelector, resolvedSelectionOrder.toRandomSelectionBoolean(), ((EntitySelectorConfig)this.config).getSelectedCountLimit());
        }
        return entitySelector;
    }

    private EntitySelector<Solution_> applyMimicRecording(HeuristicConfigPolicy<Solution_> configPolicy, EntitySelector<Solution_> entitySelector) {
        String id = ((EntitySelectorConfig)this.config).getId();
        if (id != null) {
            if (id.isEmpty()) {
                throw new IllegalArgumentException("The entitySelectorConfig (%s) has an empty id (%s).".formatted(this.config, id));
            }
            MimicRecordingEntitySelector<Solution_> mimicRecordingEntitySelector = new MimicRecordingEntitySelector<Solution_>(entitySelector);
            configPolicy.addEntityMimicRecorder(id, mimicRecordingEntitySelector);
            entitySelector = mimicRecordingEntitySelector;
        }
        return entitySelector;
    }
}

