/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.IterableSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.AbstractOriginalChangeIterator;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.AbstractRandomChangeIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.ChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained.ChainedChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;

public class ChangeMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    protected final EntitySelector<Solution_> entitySelector;
    protected final ValueSelector<Solution_> valueSelector;
    protected final boolean randomSelection;
    protected final boolean chained;
    protected SingletonInverseVariableSupply inverseVariableSupply = null;

    public ChangeMoveSelector(EntitySelector<Solution_> entitySelector, ValueSelector<Solution_> valueSelector, boolean randomSelection) {
        BasicVariableDescriptor basicVariableDescriptor;
        this.entitySelector = entitySelector;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        GenuineVariableDescriptor<Solution_> variableDescriptor = valueSelector.getVariableDescriptor();
        this.chained = variableDescriptor instanceof BasicVariableDescriptor && (basicVariableDescriptor = (BasicVariableDescriptor)variableDescriptor).isChained();
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(valueSelector);
    }

    @Override
    public boolean supportsPhaseAndSolverCaching() {
        return !this.chained;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        if (this.chained) {
            SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
            this.inverseVariableSupply = supplyManager.demand(new SingletonInverseVariableDemand<Solution_>(this.valueSelector.getVariableDescriptor()));
        }
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        if (this.chained) {
            this.inverseVariableSupply = null;
        }
    }

    @Override
    public boolean isCountable() {
        return this.entitySelector.isCountable() && this.valueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.entitySelector.isNeverEnding() || this.valueSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        if (this.valueSelector instanceof IterableSelector) {
            return this.entitySelector.getSize() * ((IterableSelector)((Object)this.valueSelector)).getSize();
        }
        long size = 0L;
        Iterator<Object> it = this.entitySelector.endingIterator();
        while (it.hasNext()) {
            Object entity = it.next();
            size += this.valueSelector.getSize(entity);
        }
        return size;
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        final GenuineVariableDescriptor<Solution_> variableDescriptor = this.valueSelector.getVariableDescriptor();
        if (!this.randomSelection) {
            if (this.chained) {
                return new AbstractOriginalChangeIterator<Solution_, Move<Solution_>>(this.entitySelector, this.valueSelector){

                    @Override
                    protected Move<Solution_> newChangeSelection(Object entity, Object toValue) {
                        return new ChainedChangeMove(variableDescriptor, entity, toValue, ChangeMoveSelector.this.inverseVariableSupply);
                    }
                };
            }
            return new AbstractOriginalChangeIterator<Solution_, Move<Solution_>>(this.entitySelector, this.valueSelector){

                @Override
                protected Move<Solution_> newChangeSelection(Object entity, Object toValue) {
                    return new ChangeMove(variableDescriptor, entity, toValue);
                }
            };
        }
        if (this.chained) {
            return new AbstractRandomChangeIterator<Solution_, Move<Solution_>>(this.entitySelector, this.valueSelector){

                @Override
                protected Move<Solution_> newChangeSelection(Object entity, Object toValue) {
                    return new ChainedChangeMove(variableDescriptor, entity, toValue, ChangeMoveSelector.this.inverseVariableSupply);
                }
            };
        }
        return new AbstractRandomChangeIterator<Solution_, Move<Solution_>>(this.entitySelector, this.valueSelector){

            @Override
            protected Move<Solution_> newChangeSelection(Object entity, Object toValue) {
                return new ChangeMove(variableDescriptor, entity, toValue);
            }
        };
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ", " + this.valueSelector + ")";
    }
}

