/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained.SubChainReversingChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained.SubChainSwapMove;
import ai.timefold.solver.core.impl.heuristic.selector.value.chained.SubChain;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class SubChainReversingSwapMove<Solution_>
extends AbstractMove<Solution_> {
    private final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final SubChain leftSubChain;
    protected final Object leftTrailingLastEntity;
    protected final SubChain rightSubChain;
    protected final Object rightTrailingLastEntity;

    public SubChainReversingSwapMove(GenuineVariableDescriptor<Solution_> variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, SubChain leftSubChain, SubChain rightSubChain) {
        this.variableDescriptor = variableDescriptor;
        this.leftSubChain = leftSubChain;
        this.leftTrailingLastEntity = inverseVariableSupply.getInverseSingleton(leftSubChain.getLastEntity());
        this.rightSubChain = rightSubChain;
        this.rightTrailingLastEntity = inverseVariableSupply.getInverseSingleton(rightSubChain.getLastEntity());
    }

    public SubChainReversingSwapMove(GenuineVariableDescriptor<Solution_> variableDescriptor, SubChain leftSubChain, Object leftTrailingLastEntity, SubChain rightSubChain, Object rightTrailingLastEntity) {
        this.variableDescriptor = variableDescriptor;
        this.leftSubChain = leftSubChain;
        this.rightSubChain = rightSubChain;
        this.leftTrailingLastEntity = leftTrailingLastEntity;
        this.rightTrailingLastEntity = rightTrailingLastEntity;
    }

    public SubChain getLeftSubChain() {
        return this.leftSubChain;
    }

    public SubChain getRightSubChain() {
        return this.rightSubChain;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return !SubChainSwapMove.containsAnyOf(this.rightSubChain, this.leftSubChain);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        Object leftFirstEntity = this.leftSubChain.getFirstEntity();
        Object leftFirstValue = this.variableDescriptor.getValue(leftFirstEntity);
        Object leftLastEntity = this.leftSubChain.getLastEntity();
        Object rightFirstEntity = this.rightSubChain.getFirstEntity();
        Object rightFirstValue = this.variableDescriptor.getValue(rightFirstEntity);
        Object rightLastEntity = this.rightSubChain.getLastEntity();
        Object leftLastEntityValue = this.variableDescriptor.getValue(leftLastEntity);
        Object rightLastEntityValue = this.variableDescriptor.getValue(rightLastEntity);
        VariableDescriptorAwareScoreDirector castScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        if (leftLastEntity != rightFirstValue) {
            castScoreDirector.changeVariableFacade(this.variableDescriptor, leftLastEntity, rightFirstValue);
        }
        if (rightLastEntity != leftFirstValue) {
            castScoreDirector.changeVariableFacade(this.variableDescriptor, rightLastEntity, leftFirstValue);
        }
        SubChainReversingChangeMove.reverseChain(castScoreDirector, this.variableDescriptor, leftLastEntity, leftLastEntityValue, leftFirstEntity);
        SubChainReversingChangeMove.reverseChain(castScoreDirector, this.variableDescriptor, rightLastEntity, rightLastEntityValue, rightFirstEntity);
        if (this.leftTrailingLastEntity != null) {
            if (this.leftTrailingLastEntity != rightFirstEntity) {
                castScoreDirector.changeVariableFacade(this.variableDescriptor, this.leftTrailingLastEntity, rightFirstEntity);
            } else {
                castScoreDirector.changeVariableFacade(this.variableDescriptor, leftLastEntity, rightFirstEntity);
            }
        }
        if (this.rightTrailingLastEntity != null) {
            if (this.rightTrailingLastEntity != leftFirstEntity) {
                castScoreDirector.changeVariableFacade(this.variableDescriptor, this.rightTrailingLastEntity, leftFirstEntity);
            } else {
                castScoreDirector.changeVariableFacade(this.variableDescriptor, rightLastEntity, leftFirstEntity);
            }
        }
    }

    @Override
    public SubChainReversingSwapMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new SubChainReversingSwapMove<Solution_>(this.variableDescriptor, this.leftSubChain.rebase(destinationScoreDirector), destinationScoreDirector.lookUpWorkingObject(this.leftTrailingLastEntity), this.rightSubChain.rebase(destinationScoreDirector), destinationScoreDirector.lookUpWorkingObject(this.rightTrailingLastEntity));
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return CollectionUtils.concat(this.leftSubChain.getEntityList(), this.rightSubChain.getEntityList());
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(2);
        values.add(this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity()));
        values.add(this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity()));
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubChainReversingSwapMove other = (SubChainReversingSwapMove)o;
        return Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.leftSubChain, other.leftSubChain) && Objects.equals(this.rightSubChain, other.rightSubChain);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.leftSubChain, this.rightSubChain);
    }

    public String toString() {
        Object oldLeftValue = this.variableDescriptor.getValue(this.leftSubChain.getFirstEntity());
        Object oldRightValue = this.variableDescriptor.getValue(this.rightSubChain.getFirstEntity());
        return this.leftSubChain.toDottedString() + " {" + oldLeftValue + "} <-reversing-> " + this.rightSubChain.toDottedString() + " {" + oldRightValue + "}";
    }
}

