/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.chained;

import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.anchor.AnchorVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class TailChainSwapMove<Solution_>
extends AbstractMove<Solution_> {
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final Object leftEntity;
    protected final Object leftValue;
    protected final Object leftAnchor;
    protected final Object rightEntity;
    protected final Object rightValue;
    protected final Object rightAnchor;
    protected final boolean sameAnchor;
    protected final Object leftNextEntity;
    protected final Object rightNextEntity;
    protected final boolean reverseAnchorSide;
    protected final Object lastEntityInChain;
    protected final Object entityAfterAnchor;

    public TailChainSwapMove(GenuineVariableDescriptor<Solution_> variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, AnchorVariableSupply anchorVariableSupply, Object leftEntity, Object rightValue) {
        this.variableDescriptor = variableDescriptor;
        this.leftEntity = leftEntity;
        this.leftValue = variableDescriptor.getValue(leftEntity);
        this.leftAnchor = anchorVariableSupply.getAnchor(leftEntity);
        this.rightEntity = inverseVariableSupply.getInverseSingleton(rightValue);
        this.rightValue = rightValue;
        this.rightAnchor = variableDescriptor.isValuePotentialAnchor(rightValue) ? rightValue : anchorVariableSupply.getAnchor(rightValue);
        boolean bl = this.sameAnchor = this.leftAnchor == this.rightAnchor;
        if (!this.sameAnchor) {
            this.leftNextEntity = null;
            this.rightNextEntity = null;
            this.reverseAnchorSide = false;
            this.lastEntityInChain = null;
            this.entityAfterAnchor = null;
        } else {
            this.leftNextEntity = inverseVariableSupply.getInverseSingleton(leftEntity);
            this.rightNextEntity = this.rightEntity == null ? null : inverseVariableSupply.getInverseSingleton(this.rightEntity);
            Object lastEntityInChainOrLeftEntity = this.findLastEntityInChainOrLeftEntity(inverseVariableSupply);
            boolean bl2 = this.reverseAnchorSide = lastEntityInChainOrLeftEntity != leftEntity;
            if (this.reverseAnchorSide) {
                this.lastEntityInChain = lastEntityInChainOrLeftEntity;
                this.entityAfterAnchor = inverseVariableSupply.getInverseSingleton(this.leftAnchor);
            } else {
                this.lastEntityInChain = null;
                this.entityAfterAnchor = null;
            }
        }
    }

    protected TailChainSwapMove(GenuineVariableDescriptor<Solution_> variableDescriptor, Object leftEntity, Object leftValue, Object leftAnchor, Object rightEntity, Object rightValue, Object rightAnchor) {
        this.variableDescriptor = variableDescriptor;
        this.leftEntity = leftEntity;
        this.leftValue = leftValue;
        this.leftAnchor = leftAnchor;
        this.rightEntity = rightEntity;
        this.rightValue = rightValue;
        this.rightAnchor = rightAnchor;
        this.sameAnchor = false;
        this.leftNextEntity = null;
        this.rightNextEntity = null;
        this.reverseAnchorSide = false;
        this.lastEntityInChain = null;
        this.entityAfterAnchor = null;
    }

    protected TailChainSwapMove(GenuineVariableDescriptor<Solution_> variableDescriptor, Object leftEntity, Object leftValue, Object leftAnchor, Object rightEntity, Object rightValue, Object rightAnchor, Object leftNextEntity, Object rightNextEntity) {
        this.variableDescriptor = variableDescriptor;
        this.leftEntity = leftEntity;
        this.leftValue = leftValue;
        this.leftAnchor = leftAnchor;
        this.rightEntity = rightEntity;
        this.rightValue = rightValue;
        this.rightAnchor = rightAnchor;
        this.sameAnchor = true;
        this.leftNextEntity = leftNextEntity;
        this.rightNextEntity = rightNextEntity;
        this.reverseAnchorSide = false;
        this.lastEntityInChain = null;
        this.entityAfterAnchor = null;
    }

    protected TailChainSwapMove(GenuineVariableDescriptor<Solution_> variableDescriptor, Object leftEntity, Object leftValue, Object leftAnchor, Object rightEntity, Object rightValue, Object rightAnchor, Object leftNextEntity, Object rightNextEntity, Object lastEntityInChain, Object entityAfterAnchor) {
        this.variableDescriptor = variableDescriptor;
        this.leftEntity = leftEntity;
        this.leftValue = leftValue;
        this.leftAnchor = leftAnchor;
        this.rightEntity = rightEntity;
        this.rightValue = rightValue;
        this.rightAnchor = rightAnchor;
        this.sameAnchor = true;
        this.leftNextEntity = leftNextEntity;
        this.rightNextEntity = rightNextEntity;
        this.reverseAnchorSide = true;
        this.lastEntityInChain = lastEntityInChain;
        this.entityAfterAnchor = entityAfterAnchor;
    }

    private Object findLastEntityInChainOrLeftEntity(SingletonInverseVariableSupply inverseVariableSupply) {
        Object entity = this.rightValue;
        while (entity != this.leftEntity) {
            Object nextEntity = inverseVariableSupply.getInverseSingleton(entity);
            if (nextEntity == null) {
                return entity;
            }
            entity = nextEntity;
        }
        return this.leftEntity;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public Object getLeftEntity() {
        return this.leftEntity;
    }

    public Object getRightValue() {
        return this.rightValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        if (Objects.equals(this.leftValue, this.rightValue) || Objects.equals(this.leftEntity, this.rightValue) || Objects.equals(this.rightEntity, this.leftValue)) {
            return false;
        }
        if (this.rightEntity == null && this.leftAnchor == this.rightAnchor) {
            return false;
        }
        if (!this.variableDescriptor.isValueRangeEntityIndependent()) {
            ValueRange<?> rightValueRange;
            ValueRangeDescriptor<Solution_> valueRangeDescriptor = this.variableDescriptor.getValueRangeDescriptor();
            Solution_ workingSolution = scoreDirector.getWorkingSolution();
            if (this.rightEntity != null && !(rightValueRange = valueRangeDescriptor.extractValueRange(workingSolution, this.rightEntity)).contains(this.leftValue)) {
                return false;
            }
            ValueRange<?> leftValueRange = valueRangeDescriptor.extractValueRange(workingSolution, this.leftEntity);
            if (!leftValueRange.contains(this.rightValue)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        VariableDescriptorAwareScoreDirector castScoreDirector = (VariableDescriptorAwareScoreDirector)scoreDirector;
        if (!this.sameAnchor) {
            castScoreDirector.changeVariableFacade(this.variableDescriptor, this.leftEntity, this.rightValue);
            if (this.rightEntity != null) {
                castScoreDirector.changeVariableFacade(this.variableDescriptor, this.rightEntity, this.leftValue);
            }
        } else if (!this.reverseAnchorSide) {
            castScoreDirector.changeVariableFacade(this.variableDescriptor, this.leftEntity, this.rightValue);
            this.reverseChain(castScoreDirector, this.leftValue, this.leftEntity, this.rightEntity);
            if (this.leftNextEntity != null) {
                castScoreDirector.changeVariableFacade(this.variableDescriptor, this.leftNextEntity, this.rightEntity);
            }
        } else {
            this.reverseChain(castScoreDirector, this.leftValue, this.leftEntity, this.entityAfterAnchor);
            castScoreDirector.changeVariableFacade(this.variableDescriptor, this.leftEntity, this.rightValue);
            this.reverseChain(castScoreDirector, this.lastEntityInChain, this.leftAnchor, this.rightEntity);
            castScoreDirector.changeVariableFacade(this.variableDescriptor, this.leftNextEntity, this.rightEntity);
        }
    }

    protected void reverseChain(VariableDescriptorAwareScoreDirector<Solution_> scoreDirector, Object fromValue, Object fromEntity, Object toEntity) {
        Object entity = fromValue;
        Object newValue = fromEntity;
        while (newValue != toEntity) {
            Object oldValue = this.variableDescriptor.getValue(entity);
            scoreDirector.changeVariableFacade(this.variableDescriptor, entity, newValue);
            newValue = entity;
            entity = oldValue;
        }
    }

    @Override
    public TailChainSwapMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        if (!this.sameAnchor) {
            return new TailChainSwapMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.leftEntity), destinationScoreDirector.lookUpWorkingObject(this.leftValue), destinationScoreDirector.lookUpWorkingObject(this.leftAnchor), destinationScoreDirector.lookUpWorkingObject(this.rightEntity), destinationScoreDirector.lookUpWorkingObject(this.rightValue), destinationScoreDirector.lookUpWorkingObject(this.rightAnchor));
        }
        if (!this.reverseAnchorSide) {
            return new TailChainSwapMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.leftEntity), destinationScoreDirector.lookUpWorkingObject(this.leftValue), destinationScoreDirector.lookUpWorkingObject(this.leftAnchor), destinationScoreDirector.lookUpWorkingObject(this.rightEntity), destinationScoreDirector.lookUpWorkingObject(this.rightValue), destinationScoreDirector.lookUpWorkingObject(this.rightAnchor), destinationScoreDirector.lookUpWorkingObject(this.leftNextEntity), destinationScoreDirector.lookUpWorkingObject(this.rightNextEntity));
        }
        return new TailChainSwapMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.leftEntity), destinationScoreDirector.lookUpWorkingObject(this.leftValue), destinationScoreDirector.lookUpWorkingObject(this.leftAnchor), destinationScoreDirector.lookUpWorkingObject(this.rightEntity), destinationScoreDirector.lookUpWorkingObject(this.rightValue), destinationScoreDirector.lookUpWorkingObject(this.rightAnchor), destinationScoreDirector.lookUpWorkingObject(this.leftNextEntity), destinationScoreDirector.lookUpWorkingObject(this.rightNextEntity), destinationScoreDirector.lookUpWorkingObject(this.lastEntityInChain), destinationScoreDirector.lookUpWorkingObject(this.entityAfterAnchor));
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        if (this.rightEntity == null) {
            return Collections.singleton(this.leftEntity);
        }
        return Arrays.asList(this.leftEntity, this.rightEntity);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        Object leftValue = this.variableDescriptor.getValue(this.leftEntity);
        return Arrays.asList(leftValue, this.rightValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TailChainSwapMove other = (TailChainSwapMove)o;
        return Objects.equals(this.leftEntity, other.leftEntity) && Objects.equals(this.rightValue, other.rightValue);
    }

    public int hashCode() {
        return Objects.hash(this.leftEntity, this.rightValue);
    }

    public String toString() {
        return this.leftEntity + " {" + this.leftValue + "} <-tailChainSwap-> " + this.rightEntity + " {" + this.rightValue + "}";
    }
}

