/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListChangeMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.OriginalListSwapIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.RandomListSwapIterator;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import java.util.Objects;

public class ListSwapMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final EntityIndependentValueSelector<Solution_> leftValueSelector;
    private final EntityIndependentValueSelector<Solution_> rightValueSelector;
    private final boolean randomSelection;
    private ListVariableStateSupply<Solution_> listVariableStateSupply;

    public ListSwapMoveSelector(EntityIndependentValueSelector<Solution_> leftValueSelector, EntityIndependentValueSelector<Solution_> rightValueSelector, boolean randomSelection) {
        this.leftValueSelector = ListChangeMoveSelector.filterPinnedListPlanningVariableValuesWithIndex(leftValueSelector, this::getListVariableStateSupply);
        this.rightValueSelector = ListChangeMoveSelector.filterPinnedListPlanningVariableValuesWithIndex(rightValueSelector, this::getListVariableStateSupply);
        this.randomSelection = randomSelection;
        this.phaseLifecycleSupport.addEventListener(this.leftValueSelector);
        this.phaseLifecycleSupport.addEventListener(this.rightValueSelector);
    }

    private ListVariableStateSupply<Solution_> getListVariableStateSupply() {
        return Objects.requireNonNull(this.listVariableStateSupply, "Impossible state: The listVariableStateSupply is not initialized yet.");
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)this.leftValueSelector.getVariableDescriptor();
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.listVariableStateSupply = (ListVariableStateSupply)supplyManager.demand(listVariableDescriptor.getStateDemand());
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.listVariableStateSupply = null;
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (this.randomSelection) {
            return new RandomListSwapIterator<Solution_>(this.listVariableStateSupply, this.leftValueSelector, this.rightValueSelector);
        }
        return new OriginalListSwapIterator<Solution_>(this.listVariableStateSupply, this.leftValueSelector, this.rightValueSelector);
    }

    @Override
    public boolean isCountable() {
        return this.leftValueSelector.isCountable() && this.rightValueSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.leftValueSelector.isNeverEnding() || this.rightValueSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.leftValueSelector.getSize() * this.rightValueSelector.getSize();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftValueSelector + ", " + this.rightValueSelector + ")";
    }
}

