/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.DestinationSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.SubListSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.SubListChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.RandomSubListChangeMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.SubListConfigUtil;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelectorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public class SubListChangeMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, SubListChangeMoveSelectorConfig> {
    public SubListChangeMoveSelectorFactory(SubListChangeMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        SubListSelectorConfig subListSelectorConfig = SubListChangeMoveSelectorFactory.checkUnfolded("subListSelectorConfig", ((SubListChangeMoveSelectorConfig)this.config).getSubListSelectorConfig());
        DestinationSelectorConfig destinationSelectorConfig = SubListChangeMoveSelectorFactory.checkUnfolded("destinationSelectorConfig", ((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig());
        if (!randomSelection) {
            throw new IllegalArgumentException("The subListChangeMoveSelector (%s) only supports random selection order.".formatted(this.config));
        }
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntitySelector entitySelector = EntitySelectorFactory.create(destinationSelectorConfig.getEntitySelectorConfig()).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder);
        SubListSelector subListSelector = SubListSelectorFactory.create(subListSelectorConfig).buildSubListSelector(configPolicy, entitySelector, minimumCacheType, selectionOrder);
        DestinationSelector destinationSelector = DestinationSelectorFactory.create(destinationSelectorConfig).buildDestinationSelector(configPolicy, minimumCacheType, randomSelection);
        Boolean selectReversingMoveToo = Objects.requireNonNullElse(((SubListChangeMoveSelectorConfig)this.config).getSelectReversingMoveToo(), true);
        return new RandomSubListChangeMoveSelector(subListSelector, destinationSelector, selectReversingMoveToo);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        GenuineVariableDescriptor onlyDestinationVariableDescriptor;
        DestinationSelectorConfig destinationSelectorConfig = ((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig();
        EntitySelectorConfig destinationEntitySelectorConfig = destinationSelectorConfig == null ? null : destinationSelectorConfig.getEntitySelectorConfig();
        EntityDescriptor onlyEntityDescriptor = destinationEntitySelectorConfig == null ? null : EntitySelectorFactory.create(destinationEntitySelectorConfig).extractEntityDescriptor(configPolicy);
        Collection entityDescriptors = onlyEntityDescriptor != null ? Collections.singletonList(onlyEntityDescriptor) : configPolicy.getSolutionDescriptor().getGenuineEntityDescriptors();
        if (entityDescriptors.size() > 1) {
            throw new IllegalArgumentException("The subListChangeMoveSelector (%s) cannot unfold when there are multiple entities (%s).\nPlease use one subListChangeMoveSelector per each planning list variable.".formatted(this.config, entityDescriptors));
        }
        EntityDescriptor entityDescriptor = entityDescriptors.iterator().next();
        SubListSelectorConfig subListSelectorConfig = ((SubListChangeMoveSelectorConfig)this.config).getSubListSelectorConfig();
        ValueSelectorConfig subListValueSelectorConfig = subListSelectorConfig == null ? null : subListSelectorConfig.getValueSelectorConfig();
        ArrayList<ListVariableDescriptor> variableDescriptorList = new ArrayList<ListVariableDescriptor>();
        GenuineVariableDescriptor onlySubListVariableDescriptor = subListValueSelectorConfig == null ? null : ValueSelectorFactory.create(subListValueSelectorConfig).extractVariableDescriptor(configPolicy, entityDescriptor);
        ValueSelectorConfig destinationValueSelectorConfig = destinationSelectorConfig == null ? null : destinationSelectorConfig.getValueSelectorConfig();
        GenuineVariableDescriptor genuineVariableDescriptor = onlyDestinationVariableDescriptor = destinationValueSelectorConfig == null ? null : ValueSelectorFactory.create(destinationValueSelectorConfig).extractVariableDescriptor(configPolicy, entityDescriptor);
        if (onlySubListVariableDescriptor != null && onlyDestinationVariableDescriptor != null) {
            if (!onlySubListVariableDescriptor.isListVariable()) {
                throw new IllegalArgumentException("The subListChangeMoveSelector (%s) is configured to use a planning variable (%s), which is not a planning list variable.".formatted(this.config, onlySubListVariableDescriptor));
            }
            if (!onlyDestinationVariableDescriptor.isListVariable()) {
                throw new IllegalArgumentException("The subListChangeMoveSelector (%s) is configured to use a planning variable (%s), which is not a planning list variable.".formatted(this.config, onlyDestinationVariableDescriptor));
            }
            if (onlySubListVariableDescriptor != onlyDestinationVariableDescriptor) {
                throw new IllegalArgumentException("The subListSelector's valueSelector (%s) and destinationSelector's valueSelector (%s) must be configured for the same planning variable.".formatted(subListValueSelectorConfig, destinationEntitySelectorConfig));
            }
            if (onlyEntityDescriptor != null) {
                return null;
            }
            variableDescriptorList.add((ListVariableDescriptor)onlySubListVariableDescriptor);
        } else {
            variableDescriptorList.addAll(entityDescriptor.getGenuineVariableDescriptorList().stream().filter(VariableDescriptor::isListVariable).map(variableDescriptor -> (ListVariableDescriptor)variableDescriptor).toList());
        }
        if (variableDescriptorList.isEmpty()) {
            throw new IllegalArgumentException("The subListChangeMoveSelector (%s) cannot unfold because there are no planning list variables.".formatted(this.config));
        }
        if (variableDescriptorList.size() > 1) {
            throw new IllegalArgumentException("The subListChangeMoveSelector (%s) cannot unfold because there are multiple planning list variables.".formatted(this.config));
        }
        return this.buildChildMoveSelectorConfig((ListVariableDescriptor)variableDescriptorList.get(0));
    }

    private SubListChangeMoveSelectorConfig buildChildMoveSelectorConfig(ListVariableDescriptor<?> variableDescriptor) {
        SubListSelectorConfig subListSelectorConfig = ((SubListChangeMoveSelectorConfig)this.config).getSubListSelectorConfig();
        DestinationSelectorConfig destinationSelectorConfig = ((SubListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig();
        SubListChangeMoveSelectorConfig subListChangeMoveSelectorConfig = ((SubListChangeMoveSelectorConfig)this.config).copyConfig().withSubListSelectorConfig(new SubListSelectorConfig(subListSelectorConfig).withValueSelectorConfig(Optional.ofNullable(subListSelectorConfig).map(SubListSelectorConfig::getValueSelectorConfig).map(ValueSelectorConfig::new).orElseGet(ValueSelectorConfig::new))).withDestinationSelectorConfig(new DestinationSelectorConfig(destinationSelectorConfig).withEntitySelectorConfig(Optional.ofNullable(destinationSelectorConfig).map(DestinationSelectorConfig::getEntitySelectorConfig).map(EntitySelectorConfig::new).orElseGet(EntitySelectorConfig::new).withEntityClass(variableDescriptor.getEntityDescriptor().getEntityClass())).withValueSelectorConfig(Optional.ofNullable(destinationSelectorConfig).map(DestinationSelectorConfig::getValueSelectorConfig).map(ValueSelectorConfig::new).orElseGet(ValueSelectorConfig::new).withVariableName(variableDescriptor.getVariableName())));
        subListSelectorConfig = Objects.requireNonNull(subListChangeMoveSelectorConfig.getSubListSelectorConfig());
        SubListConfigUtil.transferDeprecatedMinimumSubListSize(subListChangeMoveSelectorConfig, SubListChangeMoveSelectorConfig::getMinimumSubListSize, "subListSelector", subListSelectorConfig);
        SubListConfigUtil.transferDeprecatedMaximumSubListSize(subListChangeMoveSelectorConfig, SubListChangeMoveSelectorConfig::getMaximumSubListSize, "subListSelector", subListSelectorConfig);
        if (subListSelectorConfig.getMimicSelectorRef() == null) {
            Objects.requireNonNull(subListSelectorConfig.getValueSelectorConfig()).setVariableName(variableDescriptor.getVariableName());
        }
        return subListChangeMoveSelectorConfig;
    }
}

