/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.move.NoChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.EntityOrderInfo;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptCycle;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptUtils;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.TwoOptListMove;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.preview.api.domain.metamodel.LocationInList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

final class KOptListMoveIterator<Solution_, Node_>
extends UpcomingSelectionIterator<Move<Solution_>> {
    private final Random workingRandom;
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final ListVariableStateSupply<Solution_> listVariableStateSupply;
    private final EntityIndependentValueSelector<Node_> originSelector;
    private final EntityIndependentValueSelector<Node_> valueSelector;
    private final int minK;
    private final int[] pickedKDistribution;
    private final int pickedKDistributionSum;
    private final int maxCyclesPatchedInInfeasibleMove;

    public KOptListMoveIterator(Random workingRandom, ListVariableDescriptor<Solution_> listVariableDescriptor, ListVariableStateSupply<Solution_> listVariableStateSupply, EntityIndependentValueSelector<Node_> originSelector, EntityIndependentValueSelector<Node_> valueSelector, int minK, int maxK, int[] pickedKDistribution) {
        this.workingRandom = workingRandom;
        this.listVariableDescriptor = listVariableDescriptor;
        this.listVariableStateSupply = listVariableStateSupply;
        this.originSelector = originSelector;
        this.valueSelector = valueSelector;
        this.minK = minK;
        this.pickedKDistribution = pickedKDistribution;
        int tmpPickedKDistributionSum = 0;
        for (int relativeDistributionAmount : pickedKDistribution) {
            tmpPickedKDistributionSum += relativeDistributionAmount;
        }
        this.pickedKDistributionSum = tmpPickedKDistributionSum;
        this.maxCyclesPatchedInInfeasibleMove = maxK;
    }

    @Override
    protected Move<Solution_> createUpcomingSelection() {
        int locationInDistribution = this.workingRandom.nextInt(this.pickedKDistributionSum);
        int indexInDistribution = 0;
        while (locationInDistribution >= this.pickedKDistribution[indexInDistribution]) {
            locationInDistribution -= this.pickedKDistribution[indexInDistribution];
            ++indexInDistribution;
        }
        int k = this.minK + indexInDistribution;
        if (k == 2) {
            return this.pickTwoOptMove();
        }
        KOptDescriptor<Node_> descriptor = this.pickKOptMove(k);
        if (descriptor == null) {
            return NoChangeMove.getInstance();
        }
        return descriptor.getKOptListMove(this.listVariableStateSupply);
    }

    private Move<Solution_> pickTwoOptMove() {
        Iterator originIterator = this.originSelector.iterator();
        if (!originIterator.hasNext()) {
            return NoChangeMove.getInstance();
        }
        Iterator valueIterator = this.valueSelector.iterator();
        if (!valueIterator.hasNext()) {
            return NoChangeMove.getInstance();
        }
        Object firstValue = originIterator.next();
        Object secondValue = valueIterator.next();
        LocationInList firstElementLocation = this.listVariableStateSupply.getLocationInList(firstValue).ensureAssigned();
        LocationInList secondElementLocation = this.listVariableStateSupply.getLocationInList(secondValue).ensureAssigned();
        return new TwoOptListMove<Solution_>(this.listVariableDescriptor, firstElementLocation.entity(), secondElementLocation.entity(), firstElementLocation.index(), secondElementLocation.index());
    }

    private Iterator<Node_> getValuesOnSelectedEntitiesIterator(Node_[] pickedValues) {
        EntityOrderInfo entityOrderInfo = EntityOrderInfo.of(pickedValues, this.listVariableStateSupply);
        return this.workingRandom.ints(0, entityOrderInfo.entities().length).mapToObj(index -> {
            Object entity = entityOrderInfo.entities()[index];
            return this.listVariableDescriptor.getRandomUnpinnedElement(entity, this.workingRandom);
        }).iterator();
    }

    private KOptDescriptor<Node_> pickKOptMove(int k) {
        int remainingAttempts;
        Object[] pickedValues = new Object[2 * k + 1];
        Iterator originIterator = this.originSelector.iterator();
        pickedValues[1] = originIterator.next();
        if (pickedValues[1] == null) {
            return null;
        }
        for (remainingAttempts = 20; remainingAttempts > 0 && this.listVariableDescriptor.getUnpinnedSubListSize(this.listVariableStateSupply.getInverseSingleton(pickedValues[1])) < 2; --remainingAttempts) {
            do {
                if (!originIterator.hasNext()) {
                    return null;
                }
                pickedValues[1] = originIterator.next();
            } while (pickedValues[1] == null);
        }
        if (remainingAttempts == 0) {
            return null;
        }
        EntityOrderInfo entityOrderInfo = EntityOrderInfo.of(pickedValues, this.listVariableStateSupply);
        Object object = pickedValues[2] = this.workingRandom.nextBoolean() ? this.getNodeSuccessor(entityOrderInfo, pickedValues[1]) : this.getNodePredecessor(entityOrderInfo, pickedValues[1]);
        if (this.isNodeEndpointOfList(pickedValues[1]) || this.isNodeEndpointOfList(pickedValues[2])) {
            return this.pickKOptMoveRec(this.getValuesOnSelectedEntitiesIterator(pickedValues), entityOrderInfo, pickedValues, 2, k, false);
        }
        return this.pickKOptMoveRec(this.valueSelector.iterator(), entityOrderInfo, pickedValues, 2, k, true);
    }

    private KOptDescriptor<Node_> pickKOptMoveRec(Iterator<Node_> valueIterator, EntityOrderInfo entityOrderInfo, Node_[] pickedValues, int pickedSoFar, int k, boolean canSelectNewEntities) {
        Node_ previousRemovedEdgeEndpoint = pickedValues[2 * pickedSoFar - 2];
        int remainingAttempts = (k - pickedSoFar + 3) * 2;
        while (remainingAttempts > 0) {
            KOptDescriptor<Node_> descriptor;
            Node_ nextRemovedEdgePoint = valueIterator.next();
            EntityOrderInfo newEntityOrderInfo = entityOrderInfo.withNewNode(nextRemovedEdgePoint, this.listVariableStateSupply);
            while (nextRemovedEdgePoint == this.getNodePredecessor(newEntityOrderInfo, previousRemovedEdgeEndpoint) || nextRemovedEdgePoint == this.getNodeSuccessor(newEntityOrderInfo, previousRemovedEdgeEndpoint) || this.isEdgeAlreadyAdded(pickedValues, previousRemovedEdgeEndpoint, nextRemovedEdgePoint, pickedSoFar - 2) || this.isEdgeAlreadyDeleted(pickedValues, nextRemovedEdgePoint, this.getNodePredecessor(newEntityOrderInfo, nextRemovedEdgePoint), pickedSoFar - 2) && this.isEdgeAlreadyDeleted(pickedValues, nextRemovedEdgePoint, this.getNodeSuccessor(newEntityOrderInfo, nextRemovedEdgePoint), pickedSoFar - 2)) {
                if (remainingAttempts == 0) {
                    return null;
                }
                nextRemovedEdgePoint = valueIterator.next();
                newEntityOrderInfo = entityOrderInfo.withNewNode(nextRemovedEdgePoint, this.listVariableStateSupply);
                --remainingAttempts;
            }
            --remainingAttempts;
            pickedValues[2 * pickedSoFar - 1] = nextRemovedEdgePoint;
            Node_ nextRemovedEdgeOppositePoint = this.isEdgeAlreadyDeleted(pickedValues, nextRemovedEdgePoint, this.getNodePredecessor(newEntityOrderInfo, nextRemovedEdgePoint), pickedSoFar - 2) ? this.getNodeSuccessor(newEntityOrderInfo, nextRemovedEdgePoint) : (this.isEdgeAlreadyDeleted(pickedValues, nextRemovedEdgePoint, this.getNodeSuccessor(newEntityOrderInfo, nextRemovedEdgePoint), pickedSoFar - 2) ? this.getNodePredecessor(newEntityOrderInfo, nextRemovedEdgePoint) : (this.workingRandom.nextBoolean() ? this.getNodeSuccessor(newEntityOrderInfo, nextRemovedEdgePoint) : this.getNodePredecessor(newEntityOrderInfo, nextRemovedEdgePoint)));
            pickedValues[2 * pickedSoFar] = nextRemovedEdgeOppositePoint;
            if (canSelectNewEntities && this.isNodeEndpointOfList(nextRemovedEdgePoint) || this.isNodeEndpointOfList(nextRemovedEdgeOppositePoint)) {
                valueIterator = this.getValuesOnSelectedEntitiesIterator(pickedValues);
                canSelectNewEntities = false;
            }
            if (pickedSoFar < k) {
                descriptor = this.pickKOptMoveRec(valueIterator, newEntityOrderInfo, pickedValues, pickedSoFar + 1, k, canSelectNewEntities);
                if (descriptor == null || !descriptor.isFeasible(this.minK, this.maxCyclesPatchedInInfeasibleMove)) continue;
                return descriptor;
            }
            descriptor = new KOptDescriptor<Node_>(pickedValues, KOptUtils.getMultiEntitySuccessorFunction(pickedValues, this.listVariableStateSupply), KOptUtils.getMultiEntityBetweenPredicate(pickedValues, this.listVariableStateSupply));
            if (descriptor.isFeasible(this.minK, this.maxCyclesPatchedInInfeasibleMove)) {
                return descriptor;
            }
            if (!(descriptor = this.patchCycles(descriptor, newEntityOrderInfo, pickedValues, pickedSoFar)).isFeasible(this.minK, this.maxCyclesPatchedInInfeasibleMove)) continue;
            return descriptor;
        }
        return null;
    }

    KOptDescriptor<Node_> patchCycles(KOptDescriptor<Node_> descriptor, EntityOrderInfo entityOrderInfo, Node_[] oldRemovedEdges, int k) {
        int[] removedEdgeIndexToTourOrder = descriptor.removedEdgeIndexToTourOrder();
        Iterator<Node_> valueIterator = this.getValuesOnSelectedEntitiesIterator(oldRemovedEdges);
        KOptCycle cycleInfo = KOptUtils.getCyclesForPermutation(descriptor);
        int cycleCount = cycleInfo.cycleCount();
        int[] cycle = cycleInfo.indexToCycleIdentifier();
        if (cycleCount == 1 || k + cycleCount > this.maxCyclesPatchedInInfeasibleMove) {
            return descriptor;
        }
        int currentCycle = this.getShortestCycleIdentifier(entityOrderInfo, oldRemovedEdges, cycle, removedEdgeIndexToTourOrder, cycleCount, k);
        for (int i = 0; i < k; ++i) {
            if (cycle[removedEdgeIndexToTourOrder[2 * i]] != currentCycle) continue;
            Node_ sStart = oldRemovedEdges[removedEdgeIndexToTourOrder[2 * i]];
            Node_ sStop = oldRemovedEdges[removedEdgeIndexToTourOrder[2 * i + 1]];
            int attemptRemaining = k;
            Node_ s1 = sStart;
            while (s1 != sStop && --attemptRemaining != 0) {
                Node_ s2;
                Node_[] removedEdges = Arrays.copyOf(oldRemovedEdges, oldRemovedEdges.length + 2);
                removedEdges[2 * k + 1] = s1;
                removedEdges[2 * k + 2] = s2 = this.getNodeSuccessor(entityOrderInfo, s1);
                int[] addedEdgeToOtherEndpoint = Arrays.copyOf(KOptDescriptor.computeInEdgesForSequentialMove(oldRemovedEdges), removedEdges.length + 2 + 2 * cycleCount);
                for (int newEdge = removedEdges.length; newEdge < addedEdgeToOtherEndpoint.length - 2; ++newEdge) {
                    addedEdgeToOtherEndpoint[newEdge] = newEdge + 2;
                }
                addedEdgeToOtherEndpoint[addedEdgeToOtherEndpoint.length - 1] = addedEdgeToOtherEndpoint.length - 3;
                addedEdgeToOtherEndpoint[addedEdgeToOtherEndpoint.length - 2] = addedEdgeToOtherEndpoint.length - 4;
                KOptDescriptor<Node_> newMove = this.patchCyclesRec(valueIterator, descriptor, entityOrderInfo, removedEdges, addedEdgeToOtherEndpoint, cycle, currentCycle, k, 2, cycleCount);
                if (newMove.isFeasible(this.minK, this.maxCyclesPatchedInInfeasibleMove)) {
                    return newMove;
                }
                s1 = s2;
            }
        }
        return descriptor;
    }

    KOptDescriptor<Node_> patchCyclesRec(Iterator<Node_> valueIterator, KOptDescriptor<Node_> originalMove, EntityOrderInfo entityOrderInfo, Node_[] oldRemovedEdges, int[] addedEdgeToOtherEndpoint, int[] cycle, int currentCycle, int k, int patchedCycleCount, int cycleCount) {
        int NewCycle;
        Integer[] cycleSaved = new Integer[1 + 2 * k];
        Object[] removedEdges = Arrays.copyOf(oldRemovedEdges, oldRemovedEdges.length + 2);
        Node_ s1 = removedEdges[2 * k + 1];
        int i = 2 * (k + patchedCycleCount) - 2;
        Node_ s2 = removedEdges[i];
        addedEdgeToOtherEndpoint[i] = i + 1;
        addedEdgeToOtherEndpoint[addedEdgeToOtherEndpoint[i]] = i;
        for (i = 1; i <= 2 * k; ++i) {
            cycleSaved[i] = cycle[i];
        }
        Node_ s3 = valueIterator.next();
        int remainingAttempts = cycleCount * 2;
        while (s3 == this.getNodePredecessor(entityOrderInfo, s2) || s3 == this.getNodeSuccessor(entityOrderInfo, s2) || (NewCycle = this.findCycleIdentifierForNode(entityOrderInfo, s3, removedEdges, originalMove.removedEdgeIndexToTourOrder(), cycle)) == currentCycle || this.isEdgeAlreadyDeleted(removedEdges, s3, this.getNodePredecessor(entityOrderInfo, s3), k) && this.isEdgeAlreadyDeleted(removedEdges, s3, this.getNodeSuccessor(entityOrderInfo, s3), k)) {
            if (remainingAttempts == 0) {
                return originalMove;
            }
            s3 = valueIterator.next();
            --remainingAttempts;
        }
        removedEdges[2 * (k + patchedCycleCount) - 1] = s3;
        Node_ s4 = this.isEdgeAlreadyDeleted(removedEdges, s3, this.getNodePredecessor(entityOrderInfo, s3), k) ? this.getNodeSuccessor(entityOrderInfo, s3) : (this.isEdgeAlreadyDeleted(removedEdges, s3, this.getNodeSuccessor(entityOrderInfo, s3), k) ? this.getNodePredecessor(entityOrderInfo, s3) : (this.workingRandom.nextBoolean() ? this.getNodeSuccessor(entityOrderInfo, s3) : this.getNodePredecessor(entityOrderInfo, s3)));
        removedEdges[2 * (k + patchedCycleCount)] = s4;
        if (cycleCount > 2) {
            for (i = 1; i <= 2 * k; ++i) {
                if (cycle[i] != NewCycle) continue;
                cycle[i] = currentCycle;
            }
            KOptDescriptor<Object> recursiveCall = this.patchCyclesRec(valueIterator, originalMove, entityOrderInfo, removedEdges, addedEdgeToOtherEndpoint, cycle, currentCycle, k, patchedCycleCount + 1, cycleCount - 1);
            if (recursiveCall.isFeasible(this.minK, this.maxCyclesPatchedInInfeasibleMove)) {
                return recursiveCall;
            }
            for (i = 1; i <= 2 * k; ++i) {
                cycle[i] = cycleSaved[i];
            }
        } else if (s4 != s1) {
            int n = 2 * (k + patchedCycleCount);
            addedEdgeToOtherEndpoint[2 * k + 1] = n;
            addedEdgeToOtherEndpoint[n] = 2 * k + 1;
            return new KOptDescriptor<Object>(removedEdges, addedEdgeToOtherEndpoint, KOptUtils.getMultiEntitySuccessorFunction(removedEdges, this.listVariableStateSupply), KOptUtils.getMultiEntityBetweenPredicate(removedEdges, this.listVariableStateSupply));
        }
        return originalMove;
    }

    int findCycleIdentifierForNode(EntityOrderInfo entityOrderInfo, Node_ value, Node_[] pickedValues, int[] permutation, int[] indexToCycle) {
        for (int i = 1; i < pickedValues.length; ++i) {
            if (!this.isMiddleNodeBetween(entityOrderInfo, pickedValues[permutation[i - 1]], value, pickedValues[permutation[i]])) continue;
            return indexToCycle[permutation[i]];
        }
        throw new IllegalStateException("Cannot find cycle the " + value + " belongs to");
    }

    int getShortestCycleIdentifier(EntityOrderInfo entityOrderInfo, Object[] removeEdgeEndpoints, int[] endpointIndexToCycle, int[] removeEdgeEndpointIndexToTourOrder, int cycleCount, int k) {
        int i;
        int minCycleIdentifier = 0;
        int minSize = Integer.MAX_VALUE;
        int[] size = new int[cycleCount + 1];
        for (i = 1; i <= cycleCount; ++i) {
            size[i] = 0;
        }
        removeEdgeEndpointIndexToTourOrder[0] = removeEdgeEndpointIndexToTourOrder[2 * k];
        for (i = 0; i < 2 * k; i += 2) {
            int n = endpointIndexToCycle[removeEdgeEndpointIndexToTourOrder[i]];
            size[n] = size[n] + this.getSegmentSize(entityOrderInfo, removeEdgeEndpoints[removeEdgeEndpointIndexToTourOrder[i]], removeEdgeEndpoints[removeEdgeEndpointIndexToTourOrder[i + 1]]);
        }
        for (i = 1; i <= cycleCount; ++i) {
            if (size[i] >= minSize) continue;
            minSize = size[i];
            minCycleIdentifier = i - 1;
        }
        return minCycleIdentifier;
    }

    private int getSegmentSize(EntityOrderInfo entityOrderInfo, Object from, Object to) {
        int endIndex;
        Map<Object, Integer> entityToEntityIndex = entityOrderInfo.entityToEntityIndex();
        LocationInList startElementLocation = this.listVariableStateSupply.getLocationInList(from).ensureAssigned();
        LocationInList endElementLocation = this.listVariableStateSupply.getLocationInList(to).ensureAssigned();
        Integer startEntityIndex = entityToEntityIndex.get(startElementLocation.entity());
        Integer endEntityIndex = entityToEntityIndex.get(endElementLocation.entity());
        int[] offsets = entityOrderInfo.offsets();
        int startIndex = offsets[startEntityIndex] + startElementLocation.index();
        if (startIndex <= (endIndex = offsets[endEntityIndex] + endElementLocation.index())) {
            return endIndex - startIndex;
        }
        Object[] entities = entityOrderInfo.entities();
        int totalRouteSize = offsets[offsets.length - 1] + this.listVariableDescriptor.getListSize(entities[entities.length - 1]);
        return totalRouteSize - startIndex + endIndex;
    }

    private boolean isEdgeAlreadyAdded(Object[] pickedValues, Object ta, Object tb, int k) {
        int i = 2 * k;
        while ((i -= 2) > 0) {
            if ((ta != pickedValues[i] || tb != pickedValues[i + 1]) && (ta != pickedValues[i + 1] || tb != pickedValues[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isEdgeAlreadyDeleted(Object[] pickedValues, Object ta, Object tb, int k) {
        int i = 2 * k + 2;
        while ((i -= 2) > 0) {
            if ((ta != pickedValues[i - 1] || tb != pickedValues[i]) && (ta != pickedValues[i] || tb != pickedValues[i - 1])) continue;
            return true;
        }
        return false;
    }

    private boolean isNodeEndpointOfList(Object node) {
        int firstUnpinnedIndex;
        LocationInList elementLocation = this.listVariableStateSupply.getLocationInList(node).ensureAssigned();
        int index = elementLocation.index();
        if (index == (firstUnpinnedIndex = this.listVariableDescriptor.getFirstUnpinnedIndex(elementLocation.entity()))) {
            return true;
        }
        int size = this.listVariableDescriptor.getListSize(elementLocation.entity());
        return index == size - 1;
    }

    private Node_ getNodeSuccessor(EntityOrderInfo entityOrderInfo, Node_ node) {
        return entityOrderInfo.successor(node, this.listVariableStateSupply);
    }

    private Node_ getNodePredecessor(EntityOrderInfo entityOrderInfo, Node_ node) {
        return entityOrderInfo.predecessor(node, this.listVariableStateSupply);
    }

    private boolean isMiddleNodeBetween(EntityOrderInfo entityOrderInfo, Node_ start, Node_ middle, Node_ end) {
        return entityOrderInfo.between(start, middle, end, this.listVariableStateSupply);
    }
}

