/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt;

import ai.timefold.solver.core.api.function.TriConsumer;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.preview.api.domain.metamodel.LocationInList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.stream.Stream;

final class MultipleDelegateList<T>
implements List<T>,
RandomAccess {
    final Object[] delegateEntities;
    final List<T>[] delegates;
    final int[] delegateSizes;
    final int[] offsets;
    final int totalSize;

    @SafeVarargs
    public MultipleDelegateList(Object[] delegateEntities, List<T> ... delegates) {
        this.delegates = delegates;
        this.delegateEntities = delegateEntities;
        this.delegateSizes = new int[delegates.length];
        this.offsets = new int[delegates.length];
        int sizeSoFar = 0;
        for (int i = 0; i < delegates.length; ++i) {
            this.delegateSizes[i] = delegates[i].size();
            this.offsets[i] = sizeSoFar;
            sizeSoFar += this.delegateSizes[i];
        }
        this.totalSize = sizeSoFar;
    }

    @SafeVarargs
    MultipleDelegateList(List<T> ... delegates) {
        this(new Object[delegates.length], delegates);
    }

    public MultipleDelegateList<T> copy() {
        List[] delegateClones = new List[this.delegates.length];
        for (int i = 0; i < this.delegates.length; ++i) {
            delegateClones[i] = new ArrayList<T>(this.delegates[i]);
        }
        return new MultipleDelegateList<T>(this.delegateEntities, delegateClones);
    }

    public void applyChangesFromCopy(MultipleDelegateList<?> copy) {
        for (int i = 0; i < this.delegates.length; ++i) {
            this.delegates[i].clear();
            this.delegates[i].addAll(copy.delegates[i]);
        }
    }

    public int getIndexOfValue(ListVariableStateSupply<?> listVariableStateSupply, Object value) {
        LocationInList elementLocationInList = listVariableStateSupply.getLocationInList(value).ensureAssigned(() -> "Value (" + value + ") is not contained in any entity list");
        Object entity = elementLocationInList.entity();
        VariableDescriptor listVariableDescriptor = listVariableStateSupply.getSourceVariableDescriptor();
        for (int i = 0; i < this.delegateEntities.length; ++i) {
            if (this.delegateEntities[i] != entity) continue;
            int firstUnpinnedIndex = ((ListVariableDescriptor)listVariableDescriptor).getFirstUnpinnedIndex(this.delegateEntities[i]);
            return this.offsets[i] + (elementLocationInList.index() - firstUnpinnedIndex);
        }
        throw new IllegalArgumentException("Impossible state: value (%s) not found".formatted(value));
    }

    public void actOnAffectedElements(ListVariableDescriptor<?> listVariableDescriptor, Object[] originalEntities, TriConsumer<Object, Integer, Integer> action) {
        for (Object originalEntity : originalEntities) {
            action.accept(originalEntity, listVariableDescriptor.getFirstUnpinnedIndex(originalEntity), listVariableDescriptor.getListSize(originalEntity));
        }
    }

    public void moveElementsOfDelegates(int[] newDelegateEndIndices) {
        int i;
        List[] newDelegateData = new List[this.delegates.length];
        int start = 0;
        for (i = 0; i < newDelegateData.length; ++i) {
            newDelegateData[i] = List.copyOf(this.subList(start, newDelegateEndIndices[i] + 1));
            start = newDelegateEndIndices[i] + 1;
        }
        for (i = 0; i < this.delegates.length; ++i) {
            this.delegates[i].clear();
            this.delegates[i].addAll(newDelegateData[i]);
        }
        int sizeSoFar = 0;
        for (int i2 = 0; i2 < this.delegates.length; ++i2) {
            this.delegateSizes[i2] = this.delegates[i2].size();
            this.offsets[i2] = sizeSoFar;
            sizeSoFar += this.delegateSizes[i2];
        }
    }

    @Override
    public int size() {
        return this.totalSize;
    }

    @Override
    public boolean isEmpty() {
        return this.totalSize == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (List<T> delegate : this.delegates) {
            if (!delegate.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return Stream.of(this.delegates).flatMap(Collection::stream).iterator();
    }

    @Override
    public Object[] toArray() {
        return Stream.of(this.delegates).flatMap(Collection::stream).toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] t1s) {
        A[] out = Stream.of(this.delegates).flatMap(Collection::stream).toArray((int size) -> {
            if (size <= t1s.length) {
                return t1s;
            }
            return (Object[])Array.newInstance(t1s.getClass().getComponentType(), size);
        });
        if (out.length > this.totalSize) {
            out[this.totalSize] = null;
        }
        return out;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return collection.stream().allMatch(this::contains);
    }

    private int getDelegateIndex(int actualIndex) {
        int delegateIndex = 0;
        while (this.delegateSizes[delegateIndex] <= actualIndex) {
            actualIndex -= this.delegateSizes[delegateIndex];
            ++delegateIndex;
        }
        return delegateIndex;
    }

    @Override
    public T get(int i) {
        if (i < 0 || i >= this.totalSize) {
            throw new IndexOutOfBoundsException("Index (" + i + ") out of bounds for a list of size (" + this.totalSize + ")");
        }
        int delegateIndex = this.getDelegateIndex(i);
        return this.delegates[delegateIndex].get(i - this.offsets[delegateIndex]);
    }

    @Override
    public T set(int i, T t) {
        if (i < 0 || i >= this.totalSize) {
            throw new IndexOutOfBoundsException("Index (" + i + ") out of bounds for a list of size (" + this.totalSize + ")");
        }
        int delegateIndex = this.getDelegateIndex(i);
        return this.delegates[delegateIndex].set(i - this.offsets[delegateIndex], t);
    }

    @Override
    public int indexOf(Object o) {
        if (this.delegates.length == 0) {
            return -1;
        }
        int objectIndex = -1;
        int offset = 0;
        for (int delegateIndex = 0; delegateIndex < this.delegates.length && (objectIndex = this.delegates[delegateIndex].indexOf(o)) == -1; ++delegateIndex) {
            offset += this.delegateSizes[delegateIndex];
        }
        if (objectIndex == -1) {
            return -1;
        }
        return offset + objectIndex;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (this.delegates.length == 0) {
            return -1;
        }
        int objectIndex = -1;
        int offset = 0;
        for (int delegateIndex = this.delegates.length - 1; delegateIndex >= 0 && objectIndex == -1; --delegateIndex) {
            objectIndex = this.delegates[delegateIndex].lastIndexOf(o);
            offset += this.delegateSizes[delegateIndex];
        }
        if (objectIndex == -1) {
            return -1;
        }
        return this.totalSize - offset + objectIndex;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new MultipleDelegateListIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator(int i) {
        return new MultipleDelegateListIterator(this, i);
    }

    @Override
    public MultipleDelegateList<T> subList(int startInclusive, int endExclusive) {
        if (startInclusive < 0) {
            throw new IndexOutOfBoundsException("Sublist start index (" + startInclusive + ") out of range");
        }
        if (endExclusive > this.totalSize) {
            throw new IndexOutOfBoundsException("Sublist end index (" + endExclusive + ") out of range");
        }
        int startDelegateIndex = 0;
        int endDelegateIndex = 0;
        while (startInclusive >= this.delegateSizes[startDelegateIndex]) {
            startInclusive -= this.delegateSizes[startDelegateIndex];
            ++startDelegateIndex;
        }
        while (endExclusive > this.delegateSizes[endDelegateIndex]) {
            endExclusive -= this.delegateSizes[endDelegateIndex];
            ++endDelegateIndex;
        }
        List[] out = new List[endDelegateIndex - startDelegateIndex + 1];
        if (out.length == 0) {
            return new MultipleDelegateList<T>(this.delegateEntities, new List[0]);
        }
        if (startDelegateIndex == endDelegateIndex) {
            out[0] = this.delegates[startDelegateIndex].subList(startInclusive, endExclusive);
        } else {
            out[0] = this.delegates[startDelegateIndex].subList(startInclusive, this.delegateSizes[startDelegateIndex]);
            out[out.length - 1] = this.delegates[endDelegateIndex].subList(0, endExclusive);
            System.arraycopy(this.delegates, startDelegateIndex + 1, out, 1, out.length - 2);
        }
        return new MultipleDelegateList<T>(this.delegateEntities, out);
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException("Cannot add new elements to a multiple delegate list");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot remove elements from a multiple delegate list");
    }

    @Override
    public void add(int i, T t) {
        throw new UnsupportedOperationException("Cannot add new elements to a multiple delegate list");
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException("Cannot remove elements from a multiple delegate list");
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Cannot add new elements to a multiple delegate list");
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> collection) {
        throw new UnsupportedOperationException("Cannot add new elements to a multiple delegate list");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot remove elements from a multiple delegate list");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("Cannot remove elements from a multiple delegate list");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot remove elements from a multiple delegate list");
    }

    public String toString() {
        return Arrays.toString(this.delegates);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof List) {
            List other = (List)o;
            if (other.size() != this.totalSize) {
                return false;
            }
            for (int i = 0; i < this.totalSize; ++i) {
                if (Objects.equals(other.get(i), this.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.delegates);
    }

    private static final class MultipleDelegateListIterator<T>
    implements ListIterator<T> {
        final MultipleDelegateList<T> parent;
        int currentIndex;

        public MultipleDelegateListIterator(MultipleDelegateList<T> parent, int currentIndex) {
            this.parent = parent;
            this.currentIndex = currentIndex;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex < this.parent.totalSize;
        }

        @Override
        public T next() {
            T out = this.parent.get(this.currentIndex);
            ++this.currentIndex;
            return out;
        }

        @Override
        public boolean hasPrevious() {
            return this.currentIndex > 0;
        }

        @Override
        public T previous() {
            --this.currentIndex;
            return this.parent.get(this.currentIndex);
        }

        @Override
        public int nextIndex() {
            return this.currentIndex + 1;
        }

        @Override
        public int previousIndex() {
            return this.currentIndex - 1;
        }

        @Override
        public void set(T t) {
            this.parent.set(this.currentIndex, t);
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException("Cannot add new elements to a multiple delegate list");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove elements to a multiple delegate list");
        }
    }
}

