/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ruin;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.constructionheuristic.DefaultConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhaseBuilder;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ruin.RuinedLocation;
import ai.timefold.solver.core.impl.move.director.VariableChangeRecordingScoreDirector;
import ai.timefold.solver.core.impl.phase.AbstractPhase;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.preview.api.domain.metamodel.LocationInList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public final class ListRuinRecreateMove<Solution_>
extends AbstractMove<Solution_> {
    private final ListVariableStateSupply<Solution_> listVariableStateSupply;
    private final List<Object> ruinedValueList;
    private final Set<Object> affectedEntitySet;
    private final RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder;
    private final SolverScope<Solution_> solverScope;
    private final Map<Object, NavigableSet<RuinedLocation>> entityToNewPositionMap;

    public ListRuinRecreateMove(ListVariableStateSupply<Solution_> listVariableStateSupply, RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder, SolverScope<Solution_> solverScope, List<Object> ruinedValueList, Set<Object> affectedEntitySet) {
        this.listVariableStateSupply = listVariableStateSupply;
        this.constructionHeuristicPhaseBuilder = constructionHeuristicPhaseBuilder;
        this.solverScope = solverScope;
        this.ruinedValueList = ruinedValueList;
        this.affectedEntitySet = affectedEntitySet;
        this.entityToNewPositionMap = CollectionUtils.newIdentityHashMap(affectedEntitySet.size());
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        this.entityToNewPositionMap.clear();
        Map<Object, NavigableSet> entityToOriginalPositionMap = CollectionUtils.newIdentityHashMap(this.affectedEntitySet.size());
        for (Object valueToRuin : this.ruinedValueList) {
            LocationInList location = this.listVariableStateSupply.getLocationInList(valueToRuin).ensureAssigned();
            entityToOriginalPositionMap.computeIfAbsent(location.entity(), ignored -> new TreeSet()).add(new RuinedLocation(valueToRuin, location.index()));
        }
        VariableDescriptor listVariableDescriptor = this.listVariableStateSupply.getSourceVariableDescriptor();
        VariableChangeRecordingScoreDirector recordingScoreDirector = (VariableChangeRecordingScoreDirector)scoreDirector;
        InnerScoreDirector nonRecordingScoreDirector = recordingScoreDirector.getDelegate();
        for (Map.Entry entry : entityToOriginalPositionMap.entrySet()) {
            Object entity = entry.getKey();
            NavigableSet navigableSet = (NavigableSet)entry.getValue();
            recordingScoreDirector.beforeListVariableChanged(listVariableDescriptor, entity, ((ListVariableDescriptor)listVariableDescriptor).getFirstUnpinnedIndex(entity), ((ListVariableDescriptor)listVariableDescriptor).getListSize(entity));
            for (RuinedLocation position : navigableSet.descendingSet()) {
                recordingScoreDirector.beforeListVariableElementUnassigned(listVariableDescriptor, position.ruinedValue());
                ((ListVariableDescriptor)listVariableDescriptor).removeElement(entity, position.index());
                recordingScoreDirector.afterListVariableElementUnassigned(listVariableDescriptor, position.ruinedValue());
            }
            nonRecordingScoreDirector.afterListVariableChanged(listVariableDescriptor, entity, ((ListVariableDescriptor)listVariableDescriptor).getFirstUnpinnedIndex(entity), ((ListVariableDescriptor)listVariableDescriptor).getListSize(entity));
        }
        scoreDirector.triggerVariableListeners();
        AbstractPhase constructionHeuristicPhase = this.constructionHeuristicPhaseBuilder.withElementsToRecreate(this.ruinedValueList).build();
        constructionHeuristicPhase.setSolver(this.solverScope.getSolver());
        ((DefaultConstructionHeuristicPhase)constructionHeuristicPhase).solvingStarted(this.solverScope);
        ((DefaultConstructionHeuristicPhase)constructionHeuristicPhase).solve(this.solverScope);
        ((DefaultConstructionHeuristicPhase)constructionHeuristicPhase).solvingEnded(this.solverScope);
        scoreDirector.triggerVariableListeners();
        Map<Object, List> entityToInsertedValuesMap = CollectionUtils.newIdentityHashMap(0);
        for (Object k : entityToOriginalPositionMap.keySet()) {
            entityToInsertedValuesMap.put(k, new ArrayList());
        }
        for (Object object : this.ruinedValueList) {
            LocationInList location = this.listVariableStateSupply.getLocationInList(object).ensureAssigned();
            this.entityToNewPositionMap.computeIfAbsent(location.entity(), ignored -> new TreeSet()).add(new RuinedLocation(object, location.index()));
            entityToInsertedValuesMap.computeIfAbsent(location.entity(), ignored -> new ArrayList()).add(object);
        }
        for (Map.Entry entry : entityToInsertedValuesMap.entrySet()) {
            recordingScoreDirector.recordListAssignment(listVariableDescriptor, entry.getKey(), (List)entry.getValue());
        }
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return this.affectedEntitySet;
    }

    @Override
    public Collection<?> getPlanningValues() {
        return this.ruinedValueList;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return true;
    }

    @Override
    public Move<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        List<Object> rebasedRuinedValueList = AbstractMove.rebaseList(this.ruinedValueList, destinationScoreDirector);
        Set<Object> rebasedAffectedEntitySet = AbstractMove.rebaseSet(this.affectedEntitySet, destinationScoreDirector);
        return new ListRuinRecreateMove<Solution_>(this.listVariableStateSupply, this.constructionHeuristicPhaseBuilder, this.solverScope, rebasedRuinedValueList, rebasedAffectedEntitySet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRuinRecreateMove)) {
            return false;
        }
        ListRuinRecreateMove that = (ListRuinRecreateMove)o;
        return Objects.equals(this.listVariableStateSupply, that.listVariableStateSupply) && Objects.equals(this.ruinedValueList, that.ruinedValueList) && Objects.equals(this.affectedEntitySet, that.affectedEntitySet);
    }

    public int hashCode() {
        return Objects.hash(this.listVariableStateSupply, this.ruinedValueList, this.affectedEntitySet);
    }

    public String toString() {
        return "ListRuinMove{values=" + this.ruinedValueList + ", newLocationsByEntity=" + (!this.entityToNewPositionMap.isEmpty() ? this.entityToNewPositionMap : "?") + "}";
    }
}

