/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractDemandEnabledSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import java.util.Iterator;
import java.util.Objects;

public final class FromEntityPropertyValueSelector<Solution_>
extends AbstractDemandEnabledSelector<Solution_>
implements ValueSelector<Solution_> {
    private final ValueRangeDescriptor<Solution_> valueRangeDescriptor;
    private final boolean randomSelection;
    private Solution_ workingSolution;

    public FromEntityPropertyValueSelector(ValueRangeDescriptor<Solution_> valueRangeDescriptor, boolean randomSelection) {
        this.valueRangeDescriptor = valueRangeDescriptor;
        this.randomSelection = randomSelection;
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.valueRangeDescriptor.getVariableDescriptor();
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.workingSolution = phaseScope.getWorkingSolution();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.workingSolution = null;
    }

    @Override
    public boolean isCountable() {
        return this.valueRangeDescriptor.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || !this.isCountable();
    }

    @Override
    public long getSize(Object entity) {
        return this.valueRangeDescriptor.extractValueRangeSize(this.workingSolution, entity);
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        ValueRange<?> valueRange = this.valueRangeDescriptor.extractValueRange(this.workingSolution, entity);
        if (!this.randomSelection) {
            return ((CountableValueRange)valueRange).createOriginalIterator();
        }
        return valueRange.createRandomIterator(this.workingRandom);
    }

    @Override
    public Iterator<Object> endingIterator(Object entity) {
        ValueRange<?> valueRange = this.valueRangeDescriptor.extractValueRange(this.workingSolution, entity);
        return ((CountableValueRange)valueRange).createOriginalIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FromEntityPropertyValueSelector that = (FromEntityPropertyValueSelector)o;
        return this.randomSelection == that.randomSelection && Objects.equals(this.valueRangeDescriptor, that.valueRangeDescriptor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.valueRangeDescriptor, this.randomSelection);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getVariableDescriptor().getVariableName() + ")";
    }
}

