/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value;

import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSorterManner;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.EntityIndependentValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.FromEntityPropertyValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.FromSolutionPropertyValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.AssignedListValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.CachingValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.DowncastingValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.EntityDependentSortingValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.FilteringValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.InitializedValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.ProbabilityValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.ReinitializeVariableValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.SelectedCountLimitValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.ShufflingValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.SortingValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.UnassignedListValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.mimic.MimicRecordingValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.mimic.MimicReplayingValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.mimic.ValueMimicRecorder;
import ai.timefold.solver.core.impl.solver.ClassInstanceCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Function;

public class ValueSelectorFactory<Solution_>
extends AbstractSelectorFactory<Solution_, ValueSelectorConfig> {
    public static <Solution_> ValueSelectorFactory<Solution_> create(ValueSelectorConfig valueSelectorConfig) {
        return new ValueSelectorFactory<Solution_>(valueSelectorConfig);
    }

    public ValueSelectorFactory(ValueSelectorConfig valueSelectorConfig) {
        super(valueSelectorConfig);
    }

    public GenuineVariableDescriptor<Solution_> extractVariableDescriptor(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor) {
        String variableName = ((ValueSelectorConfig)this.config).getVariableName();
        String mimicSelectorRef = ((ValueSelectorConfig)this.config).getMimicSelectorRef();
        if (variableName != null) {
            return this.getVariableDescriptorForName(this.downcastEntityDescriptor(configPolicy, entityDescriptor), variableName);
        }
        if (mimicSelectorRef != null) {
            return configPolicy.getValueMimicRecorder(mimicSelectorRef).getVariableDescriptor();
        }
        return null;
    }

    public ValueSelector<Solution_> buildValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        return this.buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, inheritedSelectionOrder, configPolicy.isReinitializeVariableFilterEnabled(), ListValueFilteringType.NONE);
    }

    public ValueSelector<Solution_> buildValueSelector(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder, boolean applyReinitializeVariableFiltering, ListValueFilteringType listValueFilteringType) {
        GenuineVariableDescriptor<Solution_> variableDescriptor = this.deduceGenuineVariableDescriptor(this.downcastEntityDescriptor(configPolicy, entityDescriptor), ((ValueSelectorConfig)this.config).getVariableName());
        if (((ValueSelectorConfig)this.config).getMimicSelectorRef() != null) {
            ValueSelector<Solution_> valueSelector = this.buildMimicReplaying(configPolicy);
            valueSelector = this.applyReinitializeVariableFiltering(applyReinitializeVariableFiltering, variableDescriptor, valueSelector);
            valueSelector = this.applyDowncasting(valueSelector);
            return valueSelector;
        }
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(((ValueSelectorConfig)this.config).getCacheType(), minimumCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(((ValueSelectorConfig)this.config).getSelectionOrder(), inheritedSelectionOrder);
        NearbySelectionConfig nearbySelectionConfig = ((ValueSelectorConfig)this.config).getNearbySelectionConfig();
        if (nearbySelectionConfig != null) {
            nearbySelectionConfig.validateNearby(resolvedCacheType, resolvedSelectionOrder);
        }
        this.validateCacheTypeVersusSelectionOrder(resolvedCacheType, resolvedSelectionOrder);
        this.validateSorting(resolvedSelectionOrder);
        this.validateProbability(resolvedSelectionOrder);
        this.validateSelectedLimit(minimumCacheType);
        ValueSelector<Solution_> valueSelector = this.buildBaseValueSelector(variableDescriptor, SelectionCacheType.max(minimumCacheType, resolvedCacheType), this.determineBaseRandomSelection(variableDescriptor, resolvedCacheType, resolvedSelectionOrder));
        if (nearbySelectionConfig != null) {
            valueSelector = this.applyNearbySelection(configPolicy, entityDescriptor, minimumCacheType, resolvedSelectionOrder, valueSelector);
        }
        ClassInstanceCache instanceCache = configPolicy.getClassInstanceCache();
        valueSelector = this.applyFiltering(valueSelector, instanceCache);
        valueSelector = this.applyInitializedChainedValueFilter(configPolicy, variableDescriptor, valueSelector);
        valueSelector = this.applySorting(resolvedCacheType, resolvedSelectionOrder, valueSelector, instanceCache);
        valueSelector = this.applyProbability(resolvedCacheType, resolvedSelectionOrder, valueSelector, instanceCache);
        valueSelector = this.applyShuffling(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applyCaching(resolvedCacheType, resolvedSelectionOrder, valueSelector);
        valueSelector = this.applySelectedLimit(valueSelector);
        valueSelector = this.applyListValueFiltering(configPolicy, listValueFilteringType, variableDescriptor, valueSelector);
        valueSelector = this.applyMimicRecording(configPolicy, valueSelector);
        valueSelector = this.applyReinitializeVariableFiltering(applyReinitializeVariableFiltering, variableDescriptor, valueSelector);
        valueSelector = this.applyDowncasting(valueSelector);
        return valueSelector;
    }

    protected ValueSelector<Solution_> buildMimicReplaying(HeuristicConfigPolicy<Solution_> configPolicy) {
        if (((ValueSelectorConfig)this.config).getId() != null || ((ValueSelectorConfig)this.config).getVariableName() != null || ((ValueSelectorConfig)this.config).getCacheType() != null || ((ValueSelectorConfig)this.config).getSelectionOrder() != null || ((ValueSelectorConfig)this.config).getNearbySelectionConfig() != null || ((ValueSelectorConfig)this.config).getFilterClass() != null || ((ValueSelectorConfig)this.config).getSorterManner() != null || ((ValueSelectorConfig)this.config).getSorterComparatorClass() != null || ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() != null || ((ValueSelectorConfig)this.config).getSorterOrder() != null || ((ValueSelectorConfig)this.config).getSorterClass() != null || ((ValueSelectorConfig)this.config).getProbabilityWeightFactoryClass() != null || ((ValueSelectorConfig)this.config).getSelectedCountLimit() != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (%s) with mimicSelectorRef (%s) has another property that is not null.".formatted(this.config, ((ValueSelectorConfig)this.config).getMimicSelectorRef()));
        }
        ValueMimicRecorder<Solution_> valueMimicRecorder = configPolicy.getValueMimicRecorder(((ValueSelectorConfig)this.config).getMimicSelectorRef());
        if (valueMimicRecorder == null) {
            throw new IllegalArgumentException("The valueSelectorConfig (%s) has a mimicSelectorRef (%s) for which no valueSelector with that id exists (in its solver phase).".formatted(this.config, ((ValueSelectorConfig)this.config).getMimicSelectorRef()));
        }
        return new MimicReplayingValueSelector<Solution_>(valueMimicRecorder);
    }

    protected EntityDescriptor<Solution_> downcastEntityDescriptor(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor) {
        Class<?> downcastEntityClass = ((ValueSelectorConfig)this.config).getDowncastEntityClass();
        if (downcastEntityClass != null) {
            Class<?> parentEntityClass = entityDescriptor.getEntityClass();
            if (!parentEntityClass.isAssignableFrom(downcastEntityClass)) {
                throw new IllegalStateException("The downcastEntityClass (%s) is not a subclass of the parentEntityClass (%s) configured by the %s.".formatted(downcastEntityClass, parentEntityClass, EntitySelector.class.getSimpleName()));
            }
            SolutionDescriptor<Solution_> solutionDescriptor = configPolicy.getSolutionDescriptor();
            entityDescriptor = solutionDescriptor.getEntityDescriptorStrict(downcastEntityClass);
            if (entityDescriptor == null) {
                throw new IllegalArgumentException("The selectorConfig (%s) has an downcastEntityClass (%s) that is not a known planning entity.\nCheck your solver configuration. If that class (%s) is not in the entityClassSet (%s), check your @%s implementation's annotated methods too.".formatted(this.config, downcastEntityClass, downcastEntityClass.getSimpleName(), solutionDescriptor.getEntityClassSet(), PlanningSolution.class.getSimpleName()));
            }
        }
        return entityDescriptor;
    }

    protected boolean determineBaseRandomSelection(GenuineVariableDescriptor<Solution_> variableDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        return switch (resolvedSelectionOrder) {
            case SelectionOrder.ORIGINAL, SelectionOrder.SORTED, SelectionOrder.SHUFFLED, SelectionOrder.PROBABILISTIC -> false;
            case SelectionOrder.RANDOM -> {
                if (resolvedCacheType.isNotCached() || this.isBaseInherentlyCached(variableDescriptor) && !this.hasFiltering(variableDescriptor)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalStateException("The selectionOrder (" + resolvedSelectionOrder + ") is not implemented.");
        };
    }

    protected boolean isBaseInherentlyCached(GenuineVariableDescriptor<Solution_> variableDescriptor) {
        return variableDescriptor.isValueRangeEntityIndependent();
    }

    private ValueSelector<Solution_> buildBaseValueSelector(GenuineVariableDescriptor<Solution_> variableDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        ValueRangeDescriptor<Solution_> valueRangeDescriptor = variableDescriptor.getValueRangeDescriptor();
        if (minimumCacheType == SelectionCacheType.SOLVER) {
            throw new IllegalArgumentException("The minimumCacheType (" + minimumCacheType + ") is not yet supported. Please use " + SelectionCacheType.PHASE + " instead.");
        }
        if (valueRangeDescriptor.isEntityIndependent()) {
            return new FromSolutionPropertyValueSelector((EntityIndependentValueRangeDescriptor)valueRangeDescriptor, minimumCacheType, randomSelection);
        }
        return new FromEntityPropertyValueSelector<Solution_>(valueRangeDescriptor, randomSelection);
    }

    private boolean hasFiltering(GenuineVariableDescriptor<Solution_> variableDescriptor) {
        BasicVariableDescriptor basicVariableDescriptor;
        return ((ValueSelectorConfig)this.config).getFilterClass() != null || variableDescriptor instanceof BasicVariableDescriptor && (basicVariableDescriptor = (BasicVariableDescriptor)variableDescriptor).hasMovableChainedTrailingValueFilter();
    }

    protected ValueSelector<Solution_> applyFiltering(ValueSelector<Solution_> valueSelector, ClassInstanceCache instanceCache) {
        GenuineVariableDescriptor<Solution_> variableDescriptor = valueSelector.getVariableDescriptor();
        if (this.hasFiltering(variableDescriptor)) {
            BasicVariableDescriptor basicVariableDescriptor;
            ArrayList filterList = new ArrayList(((ValueSelectorConfig)this.config).getFilterClass() == null ? 1 : 2);
            if (((ValueSelectorConfig)this.config).getFilterClass() != null) {
                filterList.add(instanceCache.newInstance(this.config, "filterClass", ((ValueSelectorConfig)this.config).getFilterClass()));
            }
            if (variableDescriptor instanceof BasicVariableDescriptor && (basicVariableDescriptor = (BasicVariableDescriptor)variableDescriptor).hasMovableChainedTrailingValueFilter()) {
                filterList.add(basicVariableDescriptor.getMovableChainedTrailingValueFilter());
            }
            valueSelector = FilteringValueSelector.of(valueSelector, SelectionFilter.compose(filterList));
        }
        return valueSelector;
    }

    protected ValueSelector<Solution_> applyInitializedChainedValueFilter(HeuristicConfigPolicy<Solution_> configPolicy, GenuineVariableDescriptor<Solution_> variableDescriptor, ValueSelector<Solution_> valueSelector) {
        BasicVariableDescriptor basicVariableDescriptor;
        boolean isChained;
        boolean bl = isChained = variableDescriptor instanceof BasicVariableDescriptor && (basicVariableDescriptor = (BasicVariableDescriptor)variableDescriptor).isChained();
        if (configPolicy.isInitializedChainedValueFilterEnabled() && isChained) {
            valueSelector = InitializedValueSelector.create(valueSelector);
        }
        return valueSelector;
    }

    protected void validateSorting(SelectionOrder resolvedSelectionOrder) {
        ValueSorterManner sorterManner = ((ValueSelectorConfig)this.config).getSorterManner();
        Class<? extends Comparator> sorterComparatorClass = ((ValueSelectorConfig)this.config).getSorterComparatorClass();
        Class<? extends SelectionSorterWeightFactory> sorterWeightFactoryClass = ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass();
        SelectionSorterOrder sorterOrder = ((ValueSelectorConfig)this.config).getSorterOrder();
        Class<? extends SelectionSorter> sorterClass = ((ValueSelectorConfig)this.config).getSorterClass();
        if ((sorterManner != null || sorterComparatorClass != null || sorterWeightFactoryClass != null || sorterOrder != null || sorterClass != null) && resolvedSelectionOrder != SelectionOrder.SORTED) {
            throw new IllegalArgumentException("The valueSelectorConfig (%s) with sorterManner (%s) and sorterComparatorClass (%s) and sorterWeightFactoryClass (%s) and sorterOrder (%s) and sorterClass (%s) has a resolvedSelectionOrder (%s) that is not %s.".formatted(new Object[]{this.config, sorterManner, sorterComparatorClass, sorterWeightFactoryClass, sorterOrder, sorterClass, resolvedSelectionOrder, SelectionOrder.SORTED}));
        }
        ValueSelectorFactory.assertNotSorterMannerAnd((ValueSelectorConfig)this.config, "sorterComparatorClass", ValueSelectorConfig::getSorterComparatorClass);
        ValueSelectorFactory.assertNotSorterMannerAnd((ValueSelectorConfig)this.config, "sorterWeightFactoryClass", ValueSelectorConfig::getSorterWeightFactoryClass);
        ValueSelectorFactory.assertNotSorterMannerAnd((ValueSelectorConfig)this.config, "sorterClass", ValueSelectorConfig::getSorterClass);
        ValueSelectorFactory.assertNotSorterMannerAnd((ValueSelectorConfig)this.config, "sorterOrder", ValueSelectorConfig::getSorterOrder);
        ValueSelectorFactory.assertNotSorterClassAnd((ValueSelectorConfig)this.config, "sorterComparatorClass", ValueSelectorConfig::getSorterComparatorClass);
        ValueSelectorFactory.assertNotSorterClassAnd((ValueSelectorConfig)this.config, "sorterWeightFactoryClass", ValueSelectorConfig::getSorterWeightFactoryClass);
        ValueSelectorFactory.assertNotSorterClassAnd((ValueSelectorConfig)this.config, "sorterOrder", ValueSelectorConfig::getSorterOrder);
        if (sorterComparatorClass != null && sorterWeightFactoryClass != null) {
            throw new IllegalArgumentException("The valueSelectorConfig (%s) has both a sorterComparatorClass (%s) and a sorterWeightFactoryClass (%s).".formatted(this.config, sorterComparatorClass, sorterWeightFactoryClass));
        }
    }

    private static void assertNotSorterMannerAnd(ValueSelectorConfig config, String propertyName, Function<ValueSelectorConfig, Object> propertyAccessor) {
        ValueSorterManner sorterManner = config.getSorterManner();
        Object property = propertyAccessor.apply(config);
        if (sorterManner != null && property != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) has both a sorterManner (%s) and a %s (%s).".formatted(new Object[]{config, sorterManner, propertyName, property}));
        }
    }

    private static void assertNotSorterClassAnd(ValueSelectorConfig config, String propertyName, Function<ValueSelectorConfig, Object> propertyAccessor) {
        Class<? extends SelectionSorter> sorterClass = config.getSorterClass();
        Object property = propertyAccessor.apply(config);
        if (sorterClass != null && property != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (%s) with sorterClass (%s) has a non-null %s (%s).".formatted(config, sorterClass, propertyName, property));
        }
    }

    protected ValueSelector<Solution_> applySorting(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector<Solution_> valueSelector, ClassInstanceCache instanceCache) {
        if (resolvedSelectionOrder == SelectionOrder.SORTED) {
            WeightFactorySelectionSorter sorter;
            ValueSorterManner sorterManner = ((ValueSelectorConfig)this.config).getSorterManner();
            if (sorterManner != null) {
                GenuineVariableDescriptor<Solution_> variableDescriptor = valueSelector.getVariableDescriptor();
                if (!ValueSelectorConfig.hasSorter(sorterManner, variableDescriptor)) {
                    return valueSelector;
                }
                sorter = ValueSelectorConfig.determineSorter(sorterManner, variableDescriptor);
            } else if (((ValueSelectorConfig)this.config).getSorterComparatorClass() != null) {
                Comparator sorterComparator = instanceCache.newInstance(this.config, "sorterComparatorClass", ((ValueSelectorConfig)this.config).getSorterComparatorClass());
                sorter = new ComparatorSelectionSorter<Solution_, Object>(sorterComparator, SelectionSorterOrder.resolve(((ValueSelectorConfig)this.config).getSorterOrder()));
            } else if (((ValueSelectorConfig)this.config).getSorterWeightFactoryClass() != null) {
                SelectionSorterWeightFactory sorterWeightFactory = instanceCache.newInstance(this.config, "sorterWeightFactoryClass", ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass());
                sorter = new WeightFactorySelectionSorter(sorterWeightFactory, SelectionSorterOrder.resolve(((ValueSelectorConfig)this.config).getSorterOrder()));
            } else if (((ValueSelectorConfig)this.config).getSorterClass() != null) {
                sorter = instanceCache.newInstance(this.config, "sorterClass", ((ValueSelectorConfig)this.config).getSorterClass());
            } else {
                throw new IllegalArgumentException("The valueSelectorConfig (%s) with resolvedSelectionOrder (%s) needs a sorterManner (%s) or a sorterComparatorClass (%s) or a sorterWeightFactoryClass (%s) or a sorterClass (%s).".formatted(new Object[]{this.config, resolvedSelectionOrder, sorterManner, ((ValueSelectorConfig)this.config).getSorterComparatorClass(), ((ValueSelectorConfig)this.config).getSorterWeightFactoryClass(), ((ValueSelectorConfig)this.config).getSorterClass()}));
            }
            if (!valueSelector.getVariableDescriptor().isValueRangeEntityIndependent() && resolvedCacheType == SelectionCacheType.STEP) {
                valueSelector = new EntityDependentSortingValueSelector<Solution_>(valueSelector, resolvedCacheType, sorter);
            } else {
                if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                    throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with resolvedCacheType (" + resolvedCacheType + ") and resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
                }
                valueSelector = new SortingValueSelector<Solution_>((EntityIndependentValueSelector)valueSelector, resolvedCacheType, sorter);
            }
        }
        return valueSelector;
    }

    protected void validateProbability(SelectionOrder resolvedSelectionOrder) {
        if (((ValueSelectorConfig)this.config).getProbabilityWeightFactoryClass() != null && resolvedSelectionOrder != SelectionOrder.PROBABILISTIC) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with probabilityWeightFactoryClass (" + ((ValueSelectorConfig)this.config).getProbabilityWeightFactoryClass() + ") has a resolvedSelectionOrder (" + resolvedSelectionOrder + ") that is not " + SelectionOrder.PROBABILISTIC + ".");
        }
    }

    protected ValueSelector<Solution_> applyProbability(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector<Solution_> valueSelector, ClassInstanceCache instanceCache) {
        if (resolvedSelectionOrder == SelectionOrder.PROBABILISTIC) {
            if (((ValueSelectorConfig)this.config).getProbabilityWeightFactoryClass() == null) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs a probabilityWeightFactoryClass (" + ((ValueSelectorConfig)this.config).getProbabilityWeightFactoryClass() + ").");
            }
            SelectionProbabilityWeightFactory probabilityWeightFactory = instanceCache.newInstance(this.config, "probabilityWeightFactoryClass", ((ValueSelectorConfig)this.config).getProbabilityWeightFactoryClass());
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with resolvedCacheType (" + resolvedCacheType + ") and resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new ProbabilityValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, probabilityWeightFactory);
        }
        return valueSelector;
    }

    private ValueSelector<Solution_> applyShuffling(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector<Solution_> valueSelector) {
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with resolvedCacheType (" + resolvedCacheType + ") and resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new ShufflingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType);
        }
        return valueSelector;
    }

    private ValueSelector<Solution_> applyCaching(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector<Solution_> valueSelector) {
        if (resolvedCacheType.isCached() && resolvedCacheType.compareTo(valueSelector.getCacheType()) > 0) {
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with resolvedCacheType (" + resolvedCacheType + ") and resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = new CachingValueSelector((EntityIndependentValueSelector)valueSelector, resolvedCacheType, resolvedSelectionOrder.toRandomSelectionBoolean());
        }
        return valueSelector;
    }

    private void validateSelectedLimit(SelectionCacheType minimumCacheType) {
        if (((ValueSelectorConfig)this.config).getSelectedCountLimit() != null && minimumCacheType.compareTo(SelectionCacheType.JUST_IN_TIME) > 0) {
            throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with selectedCountLimit (" + ((ValueSelectorConfig)this.config).getSelectedCountLimit() + ") has a minimumCacheType (" + minimumCacheType + ") that is higher than " + SelectionCacheType.JUST_IN_TIME + ".");
        }
    }

    private ValueSelector<Solution_> applySelectedLimit(ValueSelector<Solution_> valueSelector) {
        if (((ValueSelectorConfig)this.config).getSelectedCountLimit() != null) {
            valueSelector = new SelectedCountLimitValueSelector<Solution_>(valueSelector, ((ValueSelectorConfig)this.config).getSelectedCountLimit());
        }
        return valueSelector;
    }

    private ValueSelector<Solution_> applyNearbySelection(HeuristicConfigPolicy<Solution_> configPolicy, EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector<Solution_> valueSelector) {
        return TimefoldSolverEnterpriseService.loadOrFail(TimefoldSolverEnterpriseService.Feature.NEARBY_SELECTION).applyNearbySelection((ValueSelectorConfig)this.config, configPolicy, entityDescriptor, minimumCacheType, resolvedSelectionOrder, valueSelector);
    }

    private ValueSelector<Solution_> applyMimicRecording(HeuristicConfigPolicy<Solution_> configPolicy, ValueSelector<Solution_> valueSelector) {
        String id = ((ValueSelectorConfig)this.config).getId();
        if (id != null) {
            if (id.isEmpty()) {
                throw new IllegalArgumentException("The valueSelectorConfig (%s) has an empty id (%s).".formatted(this.config, id));
            }
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (%s) with id (%s) needs to be based on an %s (%s).\nCheck your @%s annotations.".formatted(this.config, id, EntityIndependentValueSelector.class.getSimpleName(), valueSelector, ValueRangeProvider.class.getSimpleName()));
            }
            MimicRecordingValueSelector mimicRecordingValueSelector = new MimicRecordingValueSelector((EntityIndependentValueSelector)valueSelector);
            configPolicy.addValueMimicRecorder(id, mimicRecordingValueSelector);
            valueSelector = mimicRecordingValueSelector;
        }
        return valueSelector;
    }

    ValueSelector<Solution_> applyListValueFiltering(HeuristicConfigPolicy<?> configPolicy, ListValueFilteringType listValueFilteringType, GenuineVariableDescriptor<Solution_> variableDescriptor, ValueSelector<Solution_> valueSelector) {
        if (variableDescriptor.isListVariable() && configPolicy.isUnassignedValuesAllowed() && listValueFilteringType != ListValueFilteringType.NONE) {
            if (!(valueSelector instanceof EntityIndependentValueSelector)) {
                throw new IllegalArgumentException("The valueSelectorConfig (" + this.config + ") with id (" + ((ValueSelectorConfig)this.config).getId() + ") needs to be based on an " + EntityIndependentValueSelector.class.getSimpleName() + " (" + valueSelector + "). Check your @" + ValueRangeProvider.class.getSimpleName() + " annotations.");
            }
            valueSelector = listValueFilteringType == ListValueFilteringType.ACCEPT_ASSIGNED ? new AssignedListValueSelector((EntityIndependentValueSelector)valueSelector) : new UnassignedListValueSelector((EntityIndependentValueSelector)valueSelector);
        }
        return valueSelector;
    }

    private ValueSelector<Solution_> applyReinitializeVariableFiltering(boolean applyReinitializeVariableFiltering, GenuineVariableDescriptor<Solution_> variableDescriptor, ValueSelector<Solution_> valueSelector) {
        if (applyReinitializeVariableFiltering && !variableDescriptor.isListVariable()) {
            valueSelector = new ReinitializeVariableValueSelector<Solution_>(valueSelector);
        }
        return valueSelector;
    }

    private ValueSelector<Solution_> applyDowncasting(ValueSelector<Solution_> valueSelector) {
        if (((ValueSelectorConfig)this.config).getDowncastEntityClass() != null) {
            valueSelector = new DowncastingValueSelector<Solution_>(valueSelector, ((ValueSelectorConfig)this.config).getDowncastEntityClass());
        }
        return valueSelector;
    }

    public static enum ListValueFilteringType {
        NONE,
        ACCEPT_ASSIGNED,
        ACCEPT_UNASSIGNED;

    }
}

