/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.chained;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableDemand;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.chained.SubChain;
import ai.timefold.solver.core.impl.heuristic.selector.value.chained.SubChainSelector;
import ai.timefold.solver.core.impl.solver.random.RandomUtils;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DefaultSubChainSelector<Solution_>
extends AbstractSelector<Solution_>
implements SubChainSelector<Solution_>,
SelectionCacheLifecycleListener<Solution_> {
    protected static final SelectionCacheType CACHE_TYPE = SelectionCacheType.STEP;
    protected final EntityIndependentValueSelector<Solution_> valueSelector;
    protected final boolean randomSelection;
    protected SingletonInverseVariableSupply inverseVariableSupply;
    protected final int minimumSubChainSize;
    protected final int maximumSubChainSize;
    protected List<SubChain> anchorTrailingChainList = null;

    public DefaultSubChainSelector(EntityIndependentValueSelector<Solution_> valueSelector, boolean randomSelection, int minimumSubChainSize, int maximumSubChainSize) {
        BasicVariableDescriptor basicVariableDescriptor;
        boolean isChained;
        this.valueSelector = valueSelector;
        this.randomSelection = randomSelection;
        GenuineVariableDescriptor genuineVariableDescriptor = valueSelector.getVariableDescriptor();
        boolean bl = isChained = genuineVariableDescriptor instanceof BasicVariableDescriptor && (basicVariableDescriptor = (BasicVariableDescriptor)genuineVariableDescriptor).isChained();
        if (!isChained) {
            throw new IllegalArgumentException("The selector (%s)'s valueSelector (%s) must have a chained variableDescriptor chained (%s).".formatted(this, valueSelector, isChained));
        }
        if (valueSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (%s) has a valueSelector (%s) with neverEnding (%s).".formatted(this, valueSelector, valueSelector.isNeverEnding()));
        }
        this.phaseLifecycleSupport.addEventListener(valueSelector);
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(CACHE_TYPE, this));
        this.minimumSubChainSize = minimumSubChainSize;
        this.maximumSubChainSize = maximumSubChainSize;
        if (minimumSubChainSize < 1) {
            throw new IllegalStateException("The selector (%s)'s minimumSubChainSize (%d) must be at least 1.".formatted(this, minimumSubChainSize));
        }
        if (minimumSubChainSize > maximumSubChainSize) {
            throw new IllegalStateException("The minimumSubChainSize (%d) must be less than maximumSubChainSize (%d).".formatted(minimumSubChainSize, maximumSubChainSize));
        }
    }

    @Override
    public GenuineVariableDescriptor<Solution_> getVariableDescriptor() {
        return this.valueSelector.getVariableDescriptor();
    }

    @Override
    public SelectionCacheType getCacheType() {
        return CACHE_TYPE;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        GenuineVariableDescriptor variableDescriptor = this.valueSelector.getVariableDescriptor();
        this.inverseVariableSupply = supplyManager.demand(new SingletonInverseVariableDemand(variableDescriptor));
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.inverseVariableSupply = null;
    }

    @Override
    public void constructCache(SolverScope<Solution_> solverScope) {
        GenuineVariableDescriptor variableDescriptor = this.valueSelector.getVariableDescriptor();
        long valueSize = this.valueSelector.getSize();
        if (valueSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The selector (%s) has a valueSelector (%s) with valueSize (%d) which is higher than Integer.MAX_VALUE.".formatted(this, this.valueSelector, valueSize));
        }
        ArrayList anchorList = new ArrayList();
        for (Object t : this.valueSelector) {
            if (!variableDescriptor.isValuePotentialAnchor(t)) continue;
            anchorList.add(t);
        }
        int anchorListSize = Math.max(anchorList.size(), 1);
        this.anchorTrailingChainList = new ArrayList<SubChain>(anchorListSize);
        int n = (int)valueSize / anchorListSize + 1;
        for (Object anchor : anchorList) {
            ArrayList<Object> anchorChain = new ArrayList<Object>(n);
            Object trailingEntity = this.inverseVariableSupply.getInverseSingleton(anchor);
            while (trailingEntity != null) {
                anchorChain.add(trailingEntity);
                trailingEntity = this.inverseVariableSupply.getInverseSingleton(trailingEntity);
            }
            if (anchorChain.size() < this.minimumSubChainSize) continue;
            this.anchorTrailingChainList.add(new SubChain(anchorChain));
        }
    }

    @Override
    public void disposeCache(SolverScope<Solution_> solverScope) {
        this.anchorTrailingChainList = null;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        long selectionSize = 0L;
        for (SubChain anchorTrailingChain : this.anchorTrailingChainList) {
            selectionSize += this.calculateSubChainSelectionSize(anchorTrailingChain);
        }
        return selectionSize;
    }

    protected long calculateSubChainSelectionSize(SubChain anchorTrailingChain) {
        long anchorTrailingChainSize = anchorTrailingChain.getSize();
        long n = anchorTrailingChainSize - (long)this.minimumSubChainSize + 1L;
        long m = (long)this.maximumSubChainSize >= anchorTrailingChainSize ? 0L : anchorTrailingChainSize - (long)this.maximumSubChainSize;
        return n * (n + 1L) / 2L - m * (m + 1L) / 2L;
    }

    @Override
    public Iterator<SubChain> iterator() {
        if (!this.randomSelection) {
            return new OriginalSubChainIterator(this.anchorTrailingChainList.listIterator());
        }
        return new RandomSubChainIterator();
    }

    @Override
    public ListIterator<SubChain> listIterator() {
        if (!this.randomSelection) {
            return new OriginalSubChainIterator(this.anchorTrailingChainList.listIterator());
        }
        throw new IllegalStateException("The selector (%s) does not support a ListIterator with randomSelection (%s).".formatted(this, this.randomSelection));
    }

    @Override
    public ListIterator<SubChain> listIterator(int index) {
        if (!this.randomSelection) {
            OriginalSubChainIterator it = new OriginalSubChainIterator(this.anchorTrailingChainList.listIterator());
            for (int i = 0; i < index; ++i) {
                it.next();
            }
            return it;
        }
        throw new IllegalStateException("The selector (%s) does not support a ListIterator with randomSelection (%s).".formatted(this, this.randomSelection));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.valueSelector + ")";
    }

    private class OriginalSubChainIterator
    extends UpcomingSelectionIterator<SubChain>
    implements ListIterator<SubChain> {
        private final ListIterator<SubChain> anchorTrailingChainIterator;
        private List<Object> anchorTrailingChain;
        private int fromIndex;
        private int toIndex;
        private int nextListIteratorIndex;

        public OriginalSubChainIterator(ListIterator<SubChain> anchorTrailingChainIterator) {
            this.anchorTrailingChainIterator = anchorTrailingChainIterator;
            this.fromIndex = 0;
            this.toIndex = 1;
            this.anchorTrailingChain = Collections.emptyList();
            this.nextListIteratorIndex = 0;
        }

        @Override
        protected SubChain createUpcomingSelection() {
            ++this.toIndex;
            if (this.toIndex - this.fromIndex > DefaultSubChainSelector.this.maximumSubChainSize || this.toIndex > this.anchorTrailingChain.size()) {
                ++this.fromIndex;
                this.toIndex = this.fromIndex + DefaultSubChainSelector.this.minimumSubChainSize;
                while (this.toIndex > this.anchorTrailingChain.size()) {
                    if (!this.anchorTrailingChainIterator.hasNext()) {
                        return (SubChain)this.noUpcomingSelection();
                    }
                    this.anchorTrailingChain = this.anchorTrailingChainIterator.next().getEntityList();
                    this.fromIndex = 0;
                    this.toIndex = this.fromIndex + DefaultSubChainSelector.this.minimumSubChainSize;
                }
            }
            return new SubChain(this.anchorTrailingChain.subList(this.fromIndex, this.toIndex));
        }

        @Override
        public SubChain next() {
            ++this.nextListIteratorIndex;
            return (SubChain)super.next();
        }

        @Override
        public int nextIndex() {
            return this.nextListIteratorIndex;
        }

        @Override
        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SubChain previous() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(SubChain subChain) {
            throw new UnsupportedOperationException("The optional operation set() is not supported.");
        }

        @Override
        public void add(SubChain subChain) {
            throw new UnsupportedOperationException("The optional operation add() is not supported.");
        }
    }

    private class RandomSubChainIterator
    extends UpcomingSelectionIterator<SubChain> {
        private RandomSubChainIterator() {
            if (DefaultSubChainSelector.this.anchorTrailingChainList.isEmpty()) {
                this.upcomingSelection = this.noUpcomingSelection();
                this.upcomingCreated = true;
            }
        }

        @Override
        protected SubChain createUpcomingSelection() {
            SubChain anchorTrailingChain = this.selectAnchorTrailingChain();
            long selectionSize = DefaultSubChainSelector.this.calculateSubChainSelectionSize(anchorTrailingChain);
            long fromIndex = RandomUtils.nextLong(DefaultSubChainSelector.this.workingRandom, selectionSize);
            long subChainSize = DefaultSubChainSelector.this.minimumSubChainSize;
            long countInThatSize = (long)anchorTrailingChain.getSize() - subChainSize + 1L;
            while (fromIndex >= countInThatSize) {
                fromIndex -= countInThatSize;
                ++subChainSize;
                if (--countInThatSize > 0L) continue;
                throw new IllegalStateException("Impossible if calculateSubChainSelectionSize() works correctly.");
            }
            return anchorTrailingChain.subChain((int)fromIndex, (int)(fromIndex + subChainSize));
        }

        private SubChain selectAnchorTrailingChain() {
            int anchorTrailingChainListIndex = DefaultSubChainSelector.this.workingRandom.nextInt(DefaultSubChainSelector.this.anchorTrailingChainList.size());
            return DefaultSubChainSelector.this.anchorTrailingChainList.get(anchorTrailingChainListIndex);
        }
    }
}

