/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch;

import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.config.solver.monitoring.SolverMetric;
import ai.timefold.solver.core.impl.localsearch.LocalSearchPhase;
import ai.timefold.solver.core.impl.localsearch.decider.LocalSearchDecider;
import ai.timefold.solver.core.impl.localsearch.event.LocalSearchPhaseLifecycleListener;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;
import ai.timefold.solver.core.impl.phase.AbstractPhase;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.preview.api.move.Move;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultLocalSearchPhase<Solution_>
extends AbstractPhase<Solution_>
implements LocalSearchPhase<Solution_>,
LocalSearchPhaseLifecycleListener<Solution_> {
    protected final LocalSearchDecider<Solution_> decider;
    protected final AtomicLong acceptedMoveCountPerStep = new AtomicLong(0L);
    protected final AtomicLong selectedMoveCountPerStep = new AtomicLong(0L);
    protected final Map<Tags, AtomicLong> constraintMatchTotalTagsToStepCount = new ConcurrentHashMap<Tags, AtomicLong>();
    protected final Map<Tags, AtomicLong> constraintMatchTotalTagsToBestCount = new ConcurrentHashMap<Tags, AtomicLong>();
    protected final Map<Tags, List<AtomicReference<Number>>> constraintMatchTotalStepScoreMap = new ConcurrentHashMap<Tags, List<AtomicReference<Number>>>();
    protected final Map<Tags, List<AtomicReference<Number>>> constraintMatchTotalBestScoreMap = new ConcurrentHashMap<Tags, List<AtomicReference<Number>>>();

    private DefaultLocalSearchPhase(Builder<Solution_> builder) {
        super(builder);
        this.decider = builder.decider;
    }

    @Override
    public String getPhaseTypeString() {
        return "Local Search";
    }

    @Override
    public void solve(SolverScope<Solution_> solverScope) {
        LocalSearchPhaseScope<Solution_> phaseScope = new LocalSearchPhaseScope<Solution_>(solverScope, this.phaseIndex);
        this.phaseStarted(phaseScope);
        if (solverScope.isMetricEnabled(SolverMetric.MOVE_COUNT_PER_STEP)) {
            Metrics.gauge((String)(SolverMetric.MOVE_COUNT_PER_STEP.getMeterId() + ".accepted"), (Iterable)solverScope.getMonitoringTags(), (Number)this.acceptedMoveCountPerStep);
            Metrics.gauge((String)(SolverMetric.MOVE_COUNT_PER_STEP.getMeterId() + ".selected"), (Iterable)solverScope.getMonitoringTags(), (Number)this.selectedMoveCountPerStep);
        }
        while (!this.phaseTermination.isPhaseTerminated(phaseScope)) {
            LocalSearchStepScope<Solution_> stepScope = new LocalSearchStepScope<Solution_>(phaseScope);
            stepScope.setTimeGradient(this.phaseTermination.calculatePhaseTimeGradient(phaseScope));
            this.stepStarted(stepScope);
            this.decider.decideNextStep(stepScope);
            if (stepScope.getStep() == null) {
                if (this.phaseTermination.isPhaseTerminated(phaseScope)) {
                    this.logger.trace("{}    Step index ({}), time spent ({}) terminated without picking a nextStep.", new Object[]{this.logIndentation, stepScope.getStepIndex(), stepScope.getPhaseScope().calculateSolverTimeMillisSpentUpToNow()});
                    break;
                }
                if (stepScope.getSelectedMoveCount() == 0L) {
                    this.logger.warn("{}    No doable selected move at step index ({}), time spent ({}). Terminating phase early.", new Object[]{this.logIndentation, stepScope.getStepIndex(), stepScope.getPhaseScope().calculateSolverTimeMillisSpentUpToNow()});
                    break;
                }
                throw new IllegalStateException("The step index (" + stepScope.getStepIndex() + ") has accepted/selected move count (" + stepScope.getAcceptedMoveCount() + "/" + stepScope.getSelectedMoveCount() + ") but failed to pick a nextStep (" + stepScope.getStep() + ").");
            }
            this.doStep(stepScope);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
        }
        this.phaseEnded(phaseScope);
    }

    protected void doStep(LocalSearchStepScope<Solution_> stepScope) {
        Move step = stepScope.getStep();
        step.execute(stepScope.getMoveDirector());
        this.predictWorkingStepScore(stepScope, step);
        this.solver.getBestSolutionRecaller().processWorkingSolutionDuringStep(stepScope);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.decider.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.decider.phaseStarted(phaseScope);
        this.assertWorkingSolutionInitialized(phaseScope);
    }

    @Override
    public void stepStarted(LocalSearchStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        this.decider.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(LocalSearchStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        this.decider.stepEnded(stepScope);
        this.collectMetrics(stepScope);
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}    LS step ({}), time spent ({}), score ({}), {} best score ({}), accepted/selected move count ({}/{}), picked move ({}).", new Object[]{this.logIndentation, stepScope.getStepIndex(), phaseScope.calculateSolverTimeMillisSpentUpToNow(), stepScope.getScore(), stepScope.getBestScoreImproved() ? "new" : "   ", phaseScope.getBestScore(), stepScope.getAcceptedMoveCount(), stepScope.getSelectedMoveCount(), stepScope.getStepString()});
        }
    }

    private void collectMetrics(LocalSearchStepScope<Solution_> stepScope) {
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        SolverScope solverScope = phaseScope.getSolverScope();
        if (solverScope.isMetricEnabled(SolverMetric.MOVE_COUNT_PER_STEP)) {
            this.acceptedMoveCountPerStep.set(stepScope.getAcceptedMoveCount());
            this.selectedMoveCountPerStep.set(stepScope.getSelectedMoveCount());
        }
        if (solverScope.isMetricEnabled(SolverMetric.CONSTRAINT_MATCH_TOTAL_STEP_SCORE) || solverScope.isMetricEnabled(SolverMetric.CONSTRAINT_MATCH_TOTAL_BEST_SCORE)) {
            InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
            ScoreDefinition scoreDefinition = solverScope.getScoreDefinition();
            if (scoreDirector.getConstraintMatchPolicy().isEnabled()) {
                for (ConstraintMatchTotal constraintMatchTotal : scoreDirector.getConstraintMatchTotalMap().values()) {
                    Tags tags = solverScope.getMonitoringTags().and(new String[]{"constraint.package", constraintMatchTotal.getConstraintRef().packageName(), "constraint.name", constraintMatchTotal.getConstraintRef().constraintName()});
                    this.collectConstraintMatchTotalMetrics(SolverMetric.CONSTRAINT_MATCH_TOTAL_BEST_SCORE, tags, this.constraintMatchTotalTagsToBestCount, this.constraintMatchTotalBestScoreMap, constraintMatchTotal, scoreDefinition, solverScope);
                    this.collectConstraintMatchTotalMetrics(SolverMetric.CONSTRAINT_MATCH_TOTAL_STEP_SCORE, tags, this.constraintMatchTotalTagsToStepCount, this.constraintMatchTotalStepScoreMap, constraintMatchTotal, scoreDefinition, solverScope);
                }
            }
        }
    }

    private void collectConstraintMatchTotalMetrics(SolverMetric metric, Tags tags, Map<Tags, AtomicLong> countMap, Map<Tags, List<AtomicReference<Number>>> scoreMap, ConstraintMatchTotal<?> constraintMatchTotal, ScoreDefinition<?> scoreDefinition, SolverScope<Solution_> solverScope) {
        if (solverScope.isMetricEnabled(metric)) {
            if (countMap.containsKey(tags)) {
                countMap.get(tags).set(constraintMatchTotal.getConstraintMatchCount());
            } else {
                AtomicLong count = new AtomicLong(constraintMatchTotal.getConstraintMatchCount());
                countMap.put(tags, count);
                Metrics.gauge((String)(metric.getMeterId() + ".count"), (Iterable)tags, (Number)count);
            }
            SolverMetric.registerScoreMetrics(metric, tags, scoreDefinition, scoreMap, constraintMatchTotal.getScore());
        }
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.decider.phaseEnded(phaseScope);
        phaseScope.endingNow();
        this.logger.info("{}Local Search phase ({}) ended: time spent ({}), best score ({}), move evaluation speed ({}/sec), step total ({}).", new Object[]{this.logIndentation, this.phaseIndex, phaseScope.calculateSolverTimeMillisSpentUpToNow(), phaseScope.getBestScore(), phaseScope.getPhaseMoveEvaluationSpeed(), phaseScope.getNextStepIndex()});
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.decider.solvingEnded(solverScope);
    }

    @Override
    public void solvingError(SolverScope<Solution_> solverScope, Exception exception) {
        super.solvingError(solverScope, exception);
        this.decider.solvingError(solverScope, exception);
    }

    public static class Builder<Solution_>
    extends AbstractPhase.Builder<Solution_> {
        private final LocalSearchDecider<Solution_> decider;

        public Builder(int phaseIndex, String logIndentation, Termination<Solution_> phaseTermination, LocalSearchDecider<Solution_> decider) {
            super(phaseIndex, logIndentation, phaseTermination);
            this.decider = decider;
        }

        @Override
        public DefaultLocalSearchPhase<Solution_> build() {
            return new DefaultLocalSearchPhase(this);
        }
    }
}

