/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.NearbyAutoConfigurationEnabled;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.SwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.chained.TailChainSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListSwapMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.kopt.KOptListMoveSelectorConfig;
import ai.timefold.solver.core.config.localsearch.LocalSearchPhaseConfig;
import ai.timefold.solver.core.config.localsearch.LocalSearchType;
import ai.timefold.solver.core.config.localsearch.decider.acceptor.AcceptorType;
import ai.timefold.solver.core.config.localsearch.decider.acceptor.LocalSearchAcceptorConfig;
import ai.timefold.solver.core.config.localsearch.decider.forager.LocalSearchForagerConfig;
import ai.timefold.solver.core.config.localsearch.decider.forager.LocalSearchPickEarlyType;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.composite.UnionMoveSelectorFactory;
import ai.timefold.solver.core.impl.localsearch.DefaultLocalSearchPhase;
import ai.timefold.solver.core.impl.localsearch.LocalSearchPhase;
import ai.timefold.solver.core.impl.localsearch.decider.LocalSearchDecider;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.Acceptor;
import ai.timefold.solver.core.impl.localsearch.decider.acceptor.AcceptorFactory;
import ai.timefold.solver.core.impl.localsearch.decider.forager.LocalSearchForager;
import ai.timefold.solver.core.impl.localsearch.decider.forager.LocalSearchForagerFactory;
import ai.timefold.solver.core.impl.phase.AbstractPhaseFactory;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DefaultLocalSearchPhaseFactory<Solution_>
extends AbstractPhaseFactory<Solution_, LocalSearchPhaseConfig> {
    public DefaultLocalSearchPhaseFactory(LocalSearchPhaseConfig phaseConfig) {
        super(phaseConfig);
    }

    @Override
    public LocalSearchPhase<Solution_> buildPhase(int phaseIndex, boolean triggerFirstInitializedSolutionEvent, HeuristicConfigPolicy<Solution_> solverConfigPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination<Solution_> solverTermination) {
        HeuristicConfigPolicy<Solution_> phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        Termination<Solution_> phaseTermination = this.buildPhaseTermination(phaseConfigPolicy, solverTermination);
        DefaultLocalSearchPhase.Builder<Solution_> builder = new DefaultLocalSearchPhase.Builder<Solution_>(phaseIndex, solverConfigPolicy.getLogIndentation(), phaseTermination, this.buildDecider(phaseConfigPolicy, phaseTermination));
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            builder.setAssertStepScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            builder.setAssertExpectedStepScore(true);
            builder.setAssertShadowVariablesAreNotStaleAfterStep(true);
        }
        return builder.build();
    }

    private LocalSearchDecider<Solution_> buildDecider(HeuristicConfigPolicy<Solution_> configPolicy, Termination<Solution_> termination) {
        MoveSelector<Solution_> moveSelector = this.buildMoveSelector(configPolicy);
        Acceptor<Solution_> acceptor = this.buildAcceptor(configPolicy);
        LocalSearchForager<Solution_> forager = this.buildForager(configPolicy);
        if (moveSelector.isNeverEnding() && !forager.supportsNeverEndingMoveSelector()) {
            throw new IllegalStateException("The moveSelector (" + moveSelector + ") has neverEnding (" + moveSelector.isNeverEnding() + "), but the forager (" + forager + ") does not support it.\nMaybe configure the <forager> with an <acceptedCountLimit>.");
        }
        Integer moveThreadCount = configPolicy.getMoveThreadCount();
        EnvironmentMode environmentMode = configPolicy.getEnvironmentMode();
        LocalSearchDecider<Solution_> decider = moveThreadCount == null ? new LocalSearchDecider<Solution_>(configPolicy.getLogIndentation(), termination, moveSelector, acceptor, forager) : TimefoldSolverEnterpriseService.loadOrFail(TimefoldSolverEnterpriseService.Feature.MULTITHREADED_SOLVING).buildLocalSearch(moveThreadCount, termination, moveSelector, acceptor, forager, environmentMode, configPolicy);
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            decider.setAssertMoveScoreFromScratch(true);
        }
        if (environmentMode.isIntrusiveFastAsserted()) {
            decider.setAssertExpectedUndoMoveScore(true);
        }
        return decider;
    }

    protected Acceptor<Solution_> buildAcceptor(HeuristicConfigPolicy<Solution_> configPolicy) {
        LocalSearchAcceptorConfig acceptorConfig = ((LocalSearchPhaseConfig)this.phaseConfig).getAcceptorConfig();
        LocalSearchType localSearchType = ((LocalSearchPhaseConfig)this.phaseConfig).getLocalSearchType();
        if (acceptorConfig != null) {
            if (localSearchType != null) {
                throw new IllegalArgumentException("The localSearchType (%s) must not be configured if the acceptorConfig (%s) is explicitly configured.".formatted(new Object[]{localSearchType, acceptorConfig}));
            }
            return this.buildAcceptor(acceptorConfig, configPolicy);
        }
        LocalSearchType localSearchType_ = Objects.requireNonNullElse(localSearchType, LocalSearchType.LATE_ACCEPTANCE);
        LocalSearchAcceptorConfig acceptorConfig_ = new LocalSearchAcceptorConfig();
        switch (localSearchType_) {
            case HILL_CLIMBING: 
            case VARIABLE_NEIGHBORHOOD_DESCENT: {
                acceptorConfig_.setAcceptorTypeList(Collections.singletonList(AcceptorType.HILL_CLIMBING));
                break;
            }
            case TABU_SEARCH: {
                acceptorConfig_.setAcceptorTypeList(Collections.singletonList(AcceptorType.ENTITY_TABU));
                break;
            }
            case SIMULATED_ANNEALING: {
                acceptorConfig_.setAcceptorTypeList(Collections.singletonList(AcceptorType.SIMULATED_ANNEALING));
                break;
            }
            case LATE_ACCEPTANCE: {
                acceptorConfig_.setAcceptorTypeList(Collections.singletonList(AcceptorType.LATE_ACCEPTANCE));
                break;
            }
            case GREAT_DELUGE: {
                acceptorConfig_.setAcceptorTypeList(Collections.singletonList(AcceptorType.GREAT_DELUGE));
                break;
            }
            default: {
                throw new IllegalStateException("The localSearchType (" + localSearchType_ + ") is not implemented.");
            }
        }
        return this.buildAcceptor(acceptorConfig_, configPolicy);
    }

    private Acceptor<Solution_> buildAcceptor(LocalSearchAcceptorConfig acceptorConfig, HeuristicConfigPolicy<Solution_> configPolicy) {
        return AcceptorFactory.create(acceptorConfig).buildAcceptor(configPolicy);
    }

    protected LocalSearchForager<Solution_> buildForager(HeuristicConfigPolicy<Solution_> configPolicy) {
        LocalSearchForagerConfig foragerConfig_;
        if (((LocalSearchPhaseConfig)this.phaseConfig).getForagerConfig() != null) {
            if (((LocalSearchPhaseConfig)this.phaseConfig).getLocalSearchType() != null) {
                throw new IllegalArgumentException("The localSearchType (" + ((LocalSearchPhaseConfig)this.phaseConfig).getLocalSearchType() + ") must not be configured if the foragerConfig (" + ((LocalSearchPhaseConfig)this.phaseConfig).getForagerConfig() + ") is explicitly configured.");
            }
            foragerConfig_ = ((LocalSearchPhaseConfig)this.phaseConfig).getForagerConfig();
        } else {
            LocalSearchType localSearchType_ = Objects.requireNonNullElse(((LocalSearchPhaseConfig)this.phaseConfig).getLocalSearchType(), LocalSearchType.LATE_ACCEPTANCE);
            foragerConfig_ = new LocalSearchForagerConfig();
            switch (localSearchType_) {
                case HILL_CLIMBING: {
                    foragerConfig_.setAcceptedCountLimit(1);
                    break;
                }
                case TABU_SEARCH: {
                    foragerConfig_.setAcceptedCountLimit(1000);
                    break;
                }
                case SIMULATED_ANNEALING: 
                case LATE_ACCEPTANCE: 
                case GREAT_DELUGE: {
                    foragerConfig_.setAcceptedCountLimit(1);
                    break;
                }
                case VARIABLE_NEIGHBORHOOD_DESCENT: {
                    foragerConfig_.setPickEarlyType(LocalSearchPickEarlyType.FIRST_LAST_STEP_SCORE_IMPROVING);
                    break;
                }
                default: {
                    throw new IllegalStateException("The localSearchType (" + localSearchType_ + ") is not implemented.");
                }
            }
        }
        return LocalSearchForagerFactory.create(foragerConfig_).buildForager();
    }

    protected MoveSelector<Solution_> buildMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy) {
        MoveSelector<Solution_> moveSelector;
        SelectionCacheType defaultCacheType = SelectionCacheType.JUST_IN_TIME;
        SelectionOrder defaultSelectionOrder = ((LocalSearchPhaseConfig)this.phaseConfig).getLocalSearchType() == LocalSearchType.VARIABLE_NEIGHBORHOOD_DESCENT ? SelectionOrder.ORIGINAL : SelectionOrder.RANDOM;
        MoveSelectorConfig moveSelectorConfig = ((LocalSearchPhaseConfig)this.phaseConfig).getMoveSelectorConfig();
        if (moveSelectorConfig == null) {
            moveSelector = new UnionMoveSelectorFactory<Solution_>(this.determineDefaultMoveSelectorConfig(configPolicy)).buildMoveSelector(configPolicy, defaultCacheType, defaultSelectionOrder, true);
        } else {
            AbstractMoveSelectorFactory<Solution_, Object> moveSelectorFactory = MoveSelectorFactory.create(moveSelectorConfig);
            if (configPolicy.getNearbyDistanceMeterClass() != null && NearbyAutoConfigurationEnabled.class.isAssignableFrom(moveSelectorConfig.getClass()) && !UnionMoveSelectorConfig.class.isAssignableFrom(moveSelectorConfig.getClass())) {
                MoveSelectorConfig moveSelectorCopy = (MoveSelectorConfig)moveSelectorConfig.copyConfig();
                UnionMoveSelectorConfig updatedConfig = new UnionMoveSelectorConfig().withMoveSelectors(moveSelectorCopy);
                moveSelectorFactory = MoveSelectorFactory.create(updatedConfig);
            }
            moveSelector = moveSelectorFactory.buildMoveSelector(configPolicy, defaultCacheType, defaultSelectionOrder, true);
        }
        return moveSelector;
    }

    private UnionMoveSelectorConfig determineDefaultMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        SolutionDescriptor<Solution_> solutionDescriptor = configPolicy.getSolutionDescriptor();
        List<GenuineVariableDescriptor> basicVariableDescriptorList = solutionDescriptor.getEntityDescriptors().stream().flatMap(entityDescriptor -> entityDescriptor.getGenuineVariableDescriptorList().stream()).filter(variableDescriptor -> !variableDescriptor.isListVariable()).distinct().toList();
        boolean hasChainedVariable = basicVariableDescriptorList.stream().filter(v -> v instanceof BasicVariableDescriptor).anyMatch(v -> ((BasicVariableDescriptor)v).isChained());
        ListVariableDescriptor<Solution_> listVariableDescriptor = solutionDescriptor.getListVariableDescriptor();
        if (basicVariableDescriptorList.isEmpty()) {
            return new UnionMoveSelectorConfig().withMoveSelectors(new ListChangeMoveSelectorConfig(), new ListSwapMoveSelectorConfig(), new KOptListMoveSelectorConfig());
        }
        if (listVariableDescriptor == null) {
            if (hasChainedVariable && basicVariableDescriptorList.size() == 1) {
                return new UnionMoveSelectorConfig().withMoveSelectors(new ChangeMoveSelectorConfig(), new SwapMoveSelectorConfig(), new TailChainSwapMoveSelectorConfig());
            }
            return new UnionMoveSelectorConfig().withMoveSelectors(new ChangeMoveSelectorConfig(), new SwapMoveSelectorConfig());
        }
        if (configPolicy.getNearbyDistanceMeterClass() != null) {
            throw new IllegalArgumentException("The configuration contains both basic and list variables, which makes it incompatible with using a top-level nearbyDistanceMeterClass (%s).\nSpecify move selectors manually or remove the top-level nearbyDistanceMeterClass from your solver config.".formatted(configPolicy.getNearbyDistanceMeterClass()));
        }
        return new UnionMoveSelectorConfig().withMoveSelectors(new ChangeMoveSelectorConfig(), new SwapMoveSelectorConfig());
    }
}

