/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch.decider.forager;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.config.localsearch.decider.forager.LocalSearchPickEarlyType;
import ai.timefold.solver.core.impl.localsearch.decider.forager.AbstractLocalSearchForager;
import ai.timefold.solver.core.impl.localsearch.decider.forager.finalist.FinalistPodium;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchMoveScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchPhaseScope;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.List;

public class AcceptedLocalSearchForager<Solution_>
extends AbstractLocalSearchForager<Solution_> {
    protected final FinalistPodium<Solution_> finalistPodium;
    protected final LocalSearchPickEarlyType pickEarlyType;
    protected final int acceptedCountLimit;
    protected final boolean breakTieRandomly;
    protected long selectedMoveCount;
    protected long acceptedMoveCount;
    protected LocalSearchMoveScope<Solution_> earlyPickedMoveScope;

    public AcceptedLocalSearchForager(FinalistPodium<Solution_> finalistPodium, LocalSearchPickEarlyType pickEarlyType, int acceptedCountLimit, boolean breakTieRandomly) {
        this.finalistPodium = finalistPodium;
        this.pickEarlyType = pickEarlyType;
        this.acceptedCountLimit = acceptedCountLimit;
        if (acceptedCountLimit < 1) {
            throw new IllegalArgumentException("The acceptedCountLimit (" + acceptedCountLimit + ") cannot be negative or zero.");
        }
        this.breakTieRandomly = breakTieRandomly;
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.finalistPodium.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.finalistPodium.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(LocalSearchStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        this.finalistPodium.stepStarted(stepScope);
        this.selectedMoveCount = 0L;
        this.acceptedMoveCount = 0L;
        this.earlyPickedMoveScope = null;
    }

    @Override
    public boolean supportsNeverEndingMoveSelector() {
        return this.acceptedCountLimit < Integer.MAX_VALUE;
    }

    @Override
    public void addMove(LocalSearchMoveScope<Solution_> moveScope) {
        ++this.selectedMoveCount;
        ((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope().addMoveEvaluationCount(moveScope.getMove(), 1L);
        if (moveScope.getAccepted().booleanValue()) {
            ++this.acceptedMoveCount;
            this.checkPickEarly(moveScope);
        }
        this.finalistPodium.addMove(moveScope);
    }

    protected void checkPickEarly(LocalSearchMoveScope<Solution_> moveScope) {
        switch (this.pickEarlyType) {
            case NEVER: {
                break;
            }
            case FIRST_BEST_SCORE_IMPROVING: {
                Object bestScore = ((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope().getBestScore();
                if (moveScope.getScore().compareTo(bestScore) <= 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            case FIRST_LAST_STEP_SCORE_IMPROVING: {
                Score<?> lastStepScore = ((LocalSearchPhaseScope)((LocalSearchStepScope)moveScope.getStepScope()).getPhaseScope()).getLastCompletedStepScope().getScore();
                if (moveScope.getScore().compareTo(lastStepScore) <= 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            default: {
                throw new IllegalStateException("The pickEarlyType (" + this.pickEarlyType + ") is not implemented.");
            }
        }
    }

    @Override
    public boolean isQuitEarly() {
        return this.earlyPickedMoveScope != null || this.acceptedMoveCount >= (long)this.acceptedCountLimit;
    }

    @Override
    public LocalSearchMoveScope<Solution_> pickMove(LocalSearchStepScope<Solution_> stepScope) {
        stepScope.setSelectedMoveCount(this.selectedMoveCount);
        stepScope.setAcceptedMoveCount(this.acceptedMoveCount);
        if (this.earlyPickedMoveScope != null) {
            return this.earlyPickedMoveScope;
        }
        List<LocalSearchMoveScope<Solution_>> finalistList = this.finalistPodium.getFinalistList();
        if (finalistList.isEmpty()) {
            return null;
        }
        if (finalistList.size() == 1 || !this.breakTieRandomly) {
            return finalistList.get(0);
        }
        int randomIndex = stepScope.getWorkingRandom().nextInt(finalistList.size());
        return finalistList.get(randomIndex);
    }

    @Override
    public void stepEnded(LocalSearchStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        this.finalistPodium.stepEnded(stepScope);
    }

    @Override
    public void phaseEnded(LocalSearchPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.finalistPodium.phaseEnded(phaseScope);
        this.selectedMoveCount = 0L;
        this.acceptedMoveCount = 0L;
        this.earlyPickedMoveScope = null;
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.finalistPodium.solvingEnded(solverScope);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.pickEarlyType + ", " + this.acceptedCountLimit + ")";
    }
}

