/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.director;

import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningListVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningVariableMetaModel;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.move.InnerMutableSolutionView;
import ai.timefold.solver.core.impl.move.director.EphemeralMoveDirector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementLocation;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class MoveDirector<Solution_>
implements InnerMutableSolutionView<Solution_>,
Rebaser {
    protected final VariableDescriptorAwareScoreDirector<Solution_> scoreDirector;

    public MoveDirector(VariableDescriptorAwareScoreDirector<Solution_> scoreDirector) {
        this.scoreDirector = Objects.requireNonNull(scoreDirector);
    }

    @Override
    public final <Entity_, Value_> void changeVariable(@NonNull PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, @NonNull Entity_ entity, Value_ newValue) {
        BasicVariableDescriptor<Solution_> variableDescriptor = MoveDirector.extractVariableDescriptor(variableMetaModel);
        this.scoreDirector.beforeVariableChanged(variableDescriptor, entity);
        variableDescriptor.setValue(entity, newValue);
        this.scoreDirector.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public final <Entity_, Value_> void moveValueBetweenLists(@NonNull PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, @NonNull Entity_ sourceEntity, int sourceIndex, @NonNull Entity_ destinationEntity, int destinationIndex) {
        if (sourceEntity == destinationEntity) {
            this.moveValueInList(variableMetaModel, sourceEntity, sourceIndex, destinationIndex);
            return;
        }
        ListVariableDescriptor<Solution_> variableDescriptor = MoveDirector.extractVariableDescriptor(variableMetaModel);
        this.scoreDirector.beforeListVariableChanged(variableDescriptor, sourceEntity, sourceIndex, sourceIndex + 1);
        Object element = variableDescriptor.removeElement(sourceEntity, sourceIndex);
        this.scoreDirector.afterListVariableChanged(variableDescriptor, sourceEntity, sourceIndex, sourceIndex);
        this.scoreDirector.beforeListVariableChanged(variableDescriptor, destinationEntity, destinationIndex, destinationIndex);
        variableDescriptor.addElement(destinationEntity, destinationIndex, element);
        this.scoreDirector.afterListVariableChanged(variableDescriptor, destinationEntity, destinationIndex, destinationIndex + 1);
    }

    @Override
    public final <Entity_, Value_> void moveValueInList(@NonNull PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, @NonNull Entity_ entity, int sourceIndex, int destinationIndex) {
        if (sourceIndex == destinationIndex) {
            return;
        }
        if (sourceIndex > destinationIndex) {
            this.moveValueInList(variableMetaModel, entity, destinationIndex, sourceIndex);
            return;
        }
        ListVariableDescriptor<Solution_> variableDescriptor = MoveDirector.extractVariableDescriptor(variableMetaModel);
        int toIndex = destinationIndex + 1;
        this.scoreDirector.beforeListVariableChanged(variableDescriptor, entity, sourceIndex, toIndex);
        Object variable = variableDescriptor.getValue(entity);
        Object value = variable.remove(sourceIndex);
        variable.add(destinationIndex, value);
        this.scoreDirector.afterListVariableChanged(variableDescriptor, entity, sourceIndex, toIndex);
    }

    @Override
    public final void updateShadowVariables() {
        this.scoreDirector.triggerVariableListeners();
    }

    @Override
    public final <Entity_, Value_> Value_ getValue(@NonNull PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, @NonNull Entity_ entity) {
        return (Value_)MoveDirector.extractVariableDescriptor(variableMetaModel).getValue(entity);
    }

    @Override
    public final <Entity_, Value_> Value_ getValueAtIndex(@NonNull PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, @NonNull Entity_ entity, int index) {
        return (Value_)MoveDirector.extractVariableDescriptor(variableMetaModel).getValue(entity).get(index);
    }

    @Override
    public <Entity_, Value_> @NonNull ElementLocation getPositionOf(@NonNull PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, @NonNull Value_ value) {
        return MoveDirector.getPositionOf((InnerScoreDirector)this.scoreDirector, variableMetaModel, value);
    }

    protected static <Solution_, Entity_, Value_> ElementLocation getPositionOf(InnerScoreDirector<Solution_, ?> scoreDirector, PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Value_ value) {
        return scoreDirector.getListVariableStateSupply(MoveDirector.extractVariableDescriptor(variableMetaModel)).getLocationInList(value);
    }

    @Override
    public final <T> T rebase(@NonNull T problemFactOrPlanningEntity) {
        return this.scoreDirector.lookUpWorkingObject(problemFactOrPlanningEntity);
    }

    private static <Solution_, Entity_, Value_> BasicVariableDescriptor<Solution_> extractVariableDescriptor(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return ((DefaultPlanningVariableMetaModel)variableMetaModel).variableDescriptor();
    }

    private static <Solution_, Entity_, Value_> ListVariableDescriptor<Solution_> extractVariableDescriptor(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return ((DefaultPlanningListVariableMetaModel)variableMetaModel).variableDescriptor();
    }

    public EphemeralMoveDirector<Solution_> ephemeral() {
        return new EphemeralMoveDirector<Solution_>(this.scoreDirector);
    }

    @Override
    public VariableDescriptorAwareScoreDirector<Solution_> getScoreDirector() {
        return this.scoreDirector;
    }
}

