/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.director;

import ai.timefold.solver.core.impl.move.InnerMutableSolutionView;
import ai.timefold.solver.core.impl.move.director.ChangeAction;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.preview.api.move.Move;
import ai.timefold.solver.core.preview.api.move.MutableSolutionView;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

final class RecordedUndoMove<Solution_>
implements Move<Solution_> {
    private final List<ChangeAction<Solution_>> variableChangeActionList;

    RecordedUndoMove(List<ChangeAction<Solution_>> variableChangeActionList) {
        this.variableChangeActionList = Objects.requireNonNull(variableChangeActionList);
    }

    @Override
    public void execute(@NonNull MutableSolutionView<Solution_> solutionView) {
        VariableDescriptorAwareScoreDirector scoreDirector = ((InnerMutableSolutionView)solutionView).getScoreDirector();
        for (ChangeAction changeAction : this.variableChangeActionList) {
            changeAction.undo(scoreDirector);
        }
    }

    @Override
    public @NonNull Move<Solution_> rebase(@NonNull Rebaser rebaser) {
        return new RecordedUndoMove<Solution_>(this.variableChangeActionList.stream().map(changeAction -> changeAction.rebase(rebaser)).toList());
    }
}

