/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.director;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.move.director.ChangeAction;
import ai.timefold.solver.core.impl.move.director.ListVariableAfterAssignmentAction;
import ai.timefold.solver.core.impl.move.director.ListVariableAfterChangeAction;
import ai.timefold.solver.core.impl.move.director.ListVariableAfterUnassignmentAction;
import ai.timefold.solver.core.impl.move.director.ListVariableBeforeAssignmentAction;
import ai.timefold.solver.core.impl.move.director.ListVariableBeforeChangeAction;
import ai.timefold.solver.core.impl.move.director.ListVariableBeforeUnassignmentAction;
import ai.timefold.solver.core.impl.move.director.VariableChangeAction;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorCache;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class VariableChangeRecordingScoreDirector<Solution_>
implements VariableDescriptorAwareScoreDirector<Solution_> {
    private final InnerScoreDirector<Solution_, ?> delegate;
    private final List<ChangeAction<Solution_>> variableChanges;
    private final Map<Object, Integer> cache;

    public VariableChangeRecordingScoreDirector(ScoreDirector<Solution_> delegate) {
        this(delegate, true);
    }

    public VariableChangeRecordingScoreDirector(ScoreDirector<Solution_> delegate, boolean requiresIndexCache) {
        this.delegate = (InnerScoreDirector)delegate;
        this.cache = requiresIndexCache ? new IdentityHashMap() : null;
        this.variableChanges = new LinkedList<ChangeAction<Solution_>>();
    }

    List<ChangeAction<Solution_>> copyVariableChanges() {
        return List.copyOf(this.variableChanges);
    }

    public void undoChanges() {
        int changeCount = this.variableChanges.size();
        if (changeCount == 0) {
            return;
        }
        ListIterator<ChangeAction<Solution_>> listIterator = this.variableChanges.listIterator(changeCount);
        while (listIterator.hasPrevious()) {
            ChangeAction<Solution_> changeAction = listIterator.previous();
            changeAction.undo(this.delegate);
        }
        this.delegate.triggerVariableListeners();
        this.variableChanges.clear();
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        this.variableChanges.add(new VariableChangeAction<Solution_, Object, Object>(entity, variableDescriptor.getValue(entity), variableDescriptor));
        this.delegate.beforeVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void afterVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        this.delegate.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public void beforeListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        if (this.cache != null) {
            this.cache.put(entity, fromIndex);
        }
        Object list = variableDescriptor.getValue(entity);
        this.variableChanges.add(new ListVariableBeforeChangeAction(entity, List.copyOf(list.subList(fromIndex, toIndex)), fromIndex, toIndex, variableDescriptor));
        this.delegate.beforeListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public void afterListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        Integer requiredFromIndex;
        if (this.cache != null && (requiredFromIndex = this.cache.remove(entity)) != fromIndex) {
            throw new IllegalArgumentException("The fromIndex of afterListVariableChanged (%d) must match the fromIndex of its beforeListVariableChanged counterpart (%d).\nMaybe check implementation of your %s.".formatted(fromIndex, requiredFromIndex, AbstractMove.class.getSimpleName()));
        }
        this.variableChanges.add(new ListVariableAfterChangeAction(entity, fromIndex, toIndex, variableDescriptor));
        this.delegate.afterListVariableChanged(variableDescriptor, entity, fromIndex, toIndex);
    }

    @Override
    public void beforeListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.variableChanges.add(new ListVariableBeforeAssignmentAction<Solution_>(element, variableDescriptor));
        this.delegate.beforeListVariableElementAssigned(variableDescriptor, element);
    }

    @Override
    public void afterListVariableElementAssigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.variableChanges.add(new ListVariableAfterAssignmentAction<Solution_>(element, variableDescriptor));
        this.delegate.afterListVariableElementAssigned(variableDescriptor, element);
    }

    @Override
    public void beforeListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.variableChanges.add(new ListVariableBeforeUnassignmentAction<Solution_>(element, variableDescriptor));
        this.delegate.beforeListVariableElementUnassigned(variableDescriptor, element);
    }

    @Override
    public void afterListVariableElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        this.variableChanges.add(new ListVariableAfterUnassignmentAction<Solution_>(element, variableDescriptor));
        this.delegate.afterListVariableElementUnassigned(variableDescriptor, element);
    }

    @Override
    public SolutionDescriptor<Solution_> getSolutionDescriptor() {
        return this.delegate.getSolutionDescriptor();
    }

    public InnerScoreDirector<Solution_, ?> getDelegate() {
        return this.delegate;
    }

    @Override
    public Solution_ getWorkingSolution() {
        return this.delegate.getWorkingSolution();
    }

    @Override
    public VariableDescriptorCache<Solution_> getVariableDescriptorCache() {
        return this.delegate.getVariableDescriptorCache();
    }

    @Override
    public void triggerVariableListeners() {
        this.delegate.triggerVariableListeners();
    }

    @Override
    public <E> E lookUpWorkingObject(E externalObject) {
        return this.delegate.lookUpWorkingObject(externalObject);
    }

    @Override
    public <E> E lookUpWorkingObjectOrReturnNull(E externalObject) {
        return this.delegate.lookUpWorkingObjectOrReturnNull(externalObject);
    }

    @Override
    public void changeVariableFacade(VariableDescriptor<Solution_> variableDescriptor, Object entity, Object newValue) {
        this.beforeVariableChanged(variableDescriptor, entity);
        variableDescriptor.setValue(entity, newValue);
        this.afterVariableChanged(variableDescriptor, entity);
    }

    public void recordListAssignment(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, List<Object> values) {
        for (Object element : values) {
            this.variableChanges.add(new ListVariableBeforeAssignmentAction<Solution_>(element, variableDescriptor));
        }
        this.variableChanges.add(new ListVariableAfterChangeAction(entity, variableDescriptor.getFirstUnpinnedIndex(entity), variableDescriptor.getListSize(entity), variableDescriptor));
        for (Object element : values) {
            this.variableChanges.add(new ListVariableAfterAssignmentAction<Solution_>(element, variableDescriptor));
        }
    }
}

