/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.phase;

import ai.timefold.solver.core.config.constructionheuristic.ConstructionHeuristicPhaseConfig;
import ai.timefold.solver.core.config.exhaustivesearch.ExhaustiveSearchPhaseConfig;
import ai.timefold.solver.core.config.localsearch.LocalSearchPhaseConfig;
import ai.timefold.solver.core.config.partitionedsearch.PartitionedSearchPhaseConfig;
import ai.timefold.solver.core.config.phase.NoChangePhaseConfig;
import ai.timefold.solver.core.config.phase.PhaseConfig;
import ai.timefold.solver.core.config.phase.custom.CustomPhaseConfig;
import ai.timefold.solver.core.config.solver.termination.TerminationConfig;
import ai.timefold.solver.core.impl.constructionheuristic.DefaultConstructionHeuristicPhaseFactory;
import ai.timefold.solver.core.impl.exhaustivesearch.DefaultExhaustiveSearchPhaseFactory;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.localsearch.DefaultLocalSearchPhaseFactory;
import ai.timefold.solver.core.impl.partitionedsearch.DefaultPartitionedSearchPhaseFactory;
import ai.timefold.solver.core.impl.phase.NoChangePhaseFactory;
import ai.timefold.solver.core.impl.phase.Phase;
import ai.timefold.solver.core.impl.phase.custom.DefaultCustomPhaseFactory;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import java.util.ArrayList;
import java.util.List;

public interface PhaseFactory<Solution_> {
    public static <Solution_> PhaseFactory<Solution_> create(PhaseConfig<?> phaseConfig) {
        if (LocalSearchPhaseConfig.class.isAssignableFrom(phaseConfig.getClass())) {
            return new DefaultLocalSearchPhaseFactory((LocalSearchPhaseConfig)phaseConfig);
        }
        if (ConstructionHeuristicPhaseConfig.class.isAssignableFrom(phaseConfig.getClass())) {
            return new DefaultConstructionHeuristicPhaseFactory((ConstructionHeuristicPhaseConfig)phaseConfig);
        }
        if (PartitionedSearchPhaseConfig.class.isAssignableFrom(phaseConfig.getClass())) {
            return new DefaultPartitionedSearchPhaseFactory((PartitionedSearchPhaseConfig)phaseConfig);
        }
        if (CustomPhaseConfig.class.isAssignableFrom(phaseConfig.getClass())) {
            return new DefaultCustomPhaseFactory((CustomPhaseConfig)phaseConfig);
        }
        if (ExhaustiveSearchPhaseConfig.class.isAssignableFrom(phaseConfig.getClass())) {
            return new DefaultExhaustiveSearchPhaseFactory((ExhaustiveSearchPhaseConfig)phaseConfig);
        }
        if (NoChangePhaseConfig.class.isAssignableFrom(phaseConfig.getClass())) {
            return new NoChangePhaseFactory((NoChangePhaseConfig)phaseConfig);
        }
        throw new IllegalArgumentException(String.format("Unknown %s type: (%s).", PhaseConfig.class.getSimpleName(), phaseConfig.getClass().getName()));
    }

    public static <Solution_> List<Phase<Solution_>> buildPhases(List<PhaseConfig> phaseConfigList, HeuristicConfigPolicy<Solution_> configPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination<Solution_> termination) {
        ArrayList<Phase<Solution_>> phaseList = new ArrayList<Phase<Solution_>>(phaseConfigList.size());
        boolean isPhaseSelected = false;
        for (int phaseIndex = 0; phaseIndex < phaseConfigList.size(); ++phaseIndex) {
            PhaseConfig previousPhaseConfig;
            PhaseConfig phaseConfig = phaseConfigList.get(phaseIndex);
            if (phaseIndex > 0 && !PhaseFactory.canTerminate(previousPhaseConfig = phaseConfigList.get(phaseIndex - 1))) {
                throw new IllegalStateException("Solver configuration contains an unreachable phase. Phase #" + phaseIndex + " (" + phaseConfig + ") follows a phase without a configured termination (" + previousPhaseConfig + ").");
            }
            boolean isConstructionOrCustomPhase = ConstructionHeuristicPhaseConfig.class.isAssignableFrom(phaseConfig.getClass()) || CustomPhaseConfig.class.isAssignableFrom(phaseConfig.getClass());
            boolean isNextPhaseLocalSearch = phaseIndex + 1 < phaseConfigList.size() && LocalSearchPhaseConfig.class.isAssignableFrom(phaseConfigList.get(phaseIndex + 1).getClass());
            PhaseFactory<Solution_> phaseFactory = PhaseFactory.create(phaseConfig);
            Phase<Solution_> phase = phaseFactory.buildPhase(phaseIndex, !isPhaseSelected && isConstructionOrCustomPhase && isNextPhaseLocalSearch, configPolicy, bestSolutionRecaller, termination);
            if (!isPhaseSelected && isConstructionOrCustomPhase && isNextPhaseLocalSearch) {
                isPhaseSelected = true;
            }
            phaseList.add(phase);
        }
        return phaseList;
    }

    public static boolean canTerminate(PhaseConfig phaseConfig) {
        if (phaseConfig instanceof ConstructionHeuristicPhaseConfig || phaseConfig instanceof ExhaustiveSearchPhaseConfig || phaseConfig instanceof CustomPhaseConfig) {
            return true;
        }
        TerminationConfig terminationConfig = phaseConfig.getTerminationConfig();
        return terminationConfig != null && terminationConfig.isConfigured();
    }

    public Phase<Solution_> buildPhase(int var1, boolean var2, HeuristicConfigPolicy<Solution_> var3, BestSolutionRecaller<Solution_> var4, Termination<Solution_> var5);
}

