/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.phase.custom;

import ai.timefold.solver.core.config.phase.custom.CustomPhaseConfig;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.phase.AbstractPhaseFactory;
import ai.timefold.solver.core.impl.phase.custom.CustomPhase;
import ai.timefold.solver.core.impl.phase.custom.CustomPhaseCommand;
import ai.timefold.solver.core.impl.phase.custom.DefaultCustomPhase;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import java.util.ArrayList;
import java.util.List;

public class DefaultCustomPhaseFactory<Solution_>
extends AbstractPhaseFactory<Solution_, CustomPhaseConfig> {
    public DefaultCustomPhaseFactory(CustomPhaseConfig phaseConfig) {
        super(phaseConfig);
    }

    @Override
    public CustomPhase<Solution_> buildPhase(int phaseIndex, boolean triggerFirstInitializedSolutionEvent, HeuristicConfigPolicy<Solution_> solverConfigPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination<Solution_> solverTermination) {
        HeuristicConfigPolicy<Solution_> phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        List<Class<? extends CustomPhaseCommand>> customPhaseCommandClassList = ((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandClassList();
        List<CustomPhaseCommand> customPhaseCommandList = ((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandList();
        if (ConfigUtils.isEmptyCollection(customPhaseCommandClassList) && ConfigUtils.isEmptyCollection(customPhaseCommandList)) {
            throw new IllegalArgumentException("Configure at least 1 <customPhaseCommandClass> in the <customPhase> configuration.");
        }
        ArrayList customPhaseCommandList_ = new ArrayList(this.getCustomPhaseCommandListSize());
        if (customPhaseCommandClassList != null) {
            for (Class<? extends CustomPhaseCommand> customPhaseCommandClass : customPhaseCommandClassList) {
                if (customPhaseCommandClass == null) {
                    throw new IllegalArgumentException("The customPhaseCommandClass (%s) cannot be null in the customPhase (%s).\nMaybe there was a typo in the class name provided in the solver config XML?".formatted(customPhaseCommandClass, this.phaseConfig));
                }
                customPhaseCommandList_.add(this.createCustomPhaseCommand(customPhaseCommandClass));
            }
        }
        if (customPhaseCommandList != null) {
            customPhaseCommandList_.addAll(customPhaseCommandList);
        }
        DefaultCustomPhase.Builder<Solution_> builder = new DefaultCustomPhase.Builder<Solution_>(phaseIndex, triggerFirstInitializedSolutionEvent, solverConfigPolicy.getLogIndentation(), this.buildPhaseTermination(phaseConfigPolicy, solverTermination), customPhaseCommandList_);
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            builder.setAssertStepScoreFromScratch(true);
        }
        return builder.build();
    }

    private CustomPhaseCommand<Solution_> createCustomPhaseCommand(Class<? extends CustomPhaseCommand> customPhaseCommandClass) {
        CustomPhaseCommand customPhaseCommand = ConfigUtils.newInstance(this.phaseConfig, "customPhaseCommandClass", customPhaseCommandClass);
        ConfigUtils.applyCustomProperties(customPhaseCommand, "customPhaseCommandClass", ((CustomPhaseConfig)this.phaseConfig).getCustomProperties(), "customProperties");
        return customPhaseCommand;
    }

    private int getCustomPhaseCommandListSize() {
        List<Class<? extends CustomPhaseCommand>> customPhaseCommandClassList = ((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandClassList();
        List<CustomPhaseCommand> customPhaseCommandList = ((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandList();
        return (customPhaseCommandClassList == null ? 0 : customPhaseCommandClassList.size()) + (customPhaseCommandList == null ? 0 : customPhaseCommandList.size());
    }
}

